/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.felix.framework.Logger;
import org.apache.sling.launchpad.base.impl.ResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentException;

public class DeploymentPackageInstaller
implements ServiceListener,
FrameworkListener {
    public static final String DEPLOYMENT_ADMIN = DeploymentAdmin.class.getName();
    public static final String EXTENSION = ".dp";
    public static final String DATA_FILE = "dpi.data";
    private boolean frameworkStarted = false;
    private boolean serviceAvailable = false;
    private boolean deployed = false;
    private final BundleContext bundleContext;
    private final Logger logger;
    private final ResourceProvider resourceProvider;
    private DeploymentAdmin deploymentAdmin;
    private ServiceReference deploymentAdminReference;

    public DeploymentPackageInstaller(BundleContext bundleContext, Logger logger, ResourceProvider resourceProvider) {
        this.logger = logger;
        this.resourceProvider = resourceProvider;
        this.bundleContext = bundleContext;
    }

    public synchronized void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1 && !this.deployed) {
            this.deploymentAdminReference = this.bundleContext.getServiceReference(DEPLOYMENT_ADMIN);
            this.deploymentAdmin = (DeploymentAdmin)this.bundleContext.getService(this.deploymentAdminReference);
            this.serviceAvailable = true;
            if (this.frameworkStarted) {
                this.deploy();
            }
        }
    }

    public synchronized void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1 && !this.deployed) {
            this.frameworkStarted = true;
            if (this.serviceAvailable) {
                this.deploy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy() {
        ArrayList<String> installedPcks = null;
        File dataFile = this.bundleContext.getDataFile(DATA_FILE);
        if (dataFile != null && dataFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(dataFile);
                try {
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    try {
                        installedPcks = (ArrayList<String>)ois.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        this.logger.log(1, "Class not found!", e);
                    }
                    finally {
                        try {
                            ois.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            catch (IOException ioe) {
                this.logger.log(1, "IOException during reading of deployed packages.", ioe);
            }
        }
        try {
            Iterator<String> res = this.resourceProvider.getChildren("resources/bundles");
            while (res.hasNext()) {
                InputStream ins;
                String path = res.next();
                if (!path.endsWith(EXTENSION)) continue;
                int pos = path.lastIndexOf(47);
                String name = path.substring(pos + 1);
                if (installedPcks != null && installedPcks.contains(name) || (ins = this.resourceProvider.getResourceAsStream(path)) == null) continue;
                try {
                    this.deploymentAdmin.installDeploymentPackage(ins);
                    this.logger.log(3, "Deployment Package  installed from " + path);
                }
                catch (DeploymentException e) {
                    this.logger.log(1, "Deployment Package installation from " + path + " failed", e);
                }
                if (installedPcks == null) {
                    installedPcks = new ArrayList<String>();
                }
                installedPcks.add(name);
            }
        }
        catch (Throwable t) {
            this.logger.log(1, "Unexpected error during package deployment.", t);
        }
        if (installedPcks != null) {
            try {
                FileOutputStream fos = new FileOutputStream(dataFile);
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    try {
                        oos.writeObject(installedPcks);
                    }
                    finally {
                        try {
                            oos.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            catch (IOException ioe) {
                this.logger.log(1, "IOException during writing deployed packages.", ioe);
            }
        }
        this.deployed = true;
        this.bundleContext.ungetService(this.deploymentAdminReference);
        this.bundleContext.removeFrameworkListener(this);
        this.bundleContext.removeServiceListener(this);
        this.deploymentAdmin = null;
        this.deploymentAdminReference = null;
    }
}

