/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.eclipse.equinox.http.servlet.internal.HttpServiceFactory;
import org.eclipse.equinox.http.servlet.internal.ProxyServlet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final String DEFAULT_SERVICE_DESCRIPTION = "Equinox Servlet Bridge";
    private static final String DEFAULT_SERVICE_VENDOR = "Eclipse.org";
    private static BundleContext context;
    private static Map serviceRegistrations;
    static /* synthetic */ Class class$0;

    static {
        serviceRegistrations = new HashMap();
    }

    public void start(BundleContext context) throws Exception {
        Activator.startHttpServiceProxy(context);
    }

    public void stop(BundleContext context) throws Exception {
        Activator.stopHttpServiceProxy(context);
    }

    private static synchronized void startHttpServiceProxy(BundleContext bundleContext) {
        context = bundleContext;
        Object[] proxyServlets = serviceRegistrations.keySet().toArray();
        int i = 0;
        while (i < proxyServlets.length) {
            ServiceRegistration registration = Activator.registerHttpService((ProxyServlet)proxyServlets[i]);
            serviceRegistrations.put(proxyServlets[i], registration);
            ++i;
        }
    }

    private static synchronized void stopHttpServiceProxy(BundleContext bundleContext) {
        Object[] proxyServlets = serviceRegistrations.keySet().toArray();
        int i = 0;
        while (i < proxyServlets.length) {
            ServiceRegistration registration = serviceRegistrations.put(proxyServlets[i], null);
            registration.unregister();
            ++i;
        }
        context = null;
    }

    static synchronized void addProxyServlet(ProxyServlet proxyServlet) {
        ServiceRegistration registration = null;
        if (context != null) {
            registration = Activator.registerHttpService(proxyServlet);
        }
        serviceRegistrations.put(proxyServlet, registration);
    }

    private static ServiceRegistration registerHttpService(ProxyServlet proxyServlet) {
        Class<?> clazz;
        HttpServiceFactory factory = new HttpServiceFactory(proxyServlet);
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>(2);
        ServletConfig config = proxyServlet.getServletConfig();
        Enumeration initparameterNames = config.getInitParameterNames();
        while (initparameterNames.hasMoreElements()) {
            String name = (String)initparameterNames.nextElement();
            ((Dictionary)serviceProperties).put(name, config.getInitParameter(name));
        }
        if (((Dictionary)serviceProperties).get("service.vendor") == null) {
            ((Dictionary)serviceProperties).put("service.vendor", DEFAULT_SERVICE_VENDOR);
        }
        if (((Dictionary)serviceProperties).get("service.description") == null) {
            ((Dictionary)serviceProperties).put("service.description", DEFAULT_SERVICE_DESCRIPTION);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.http.HttpService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return context.registerService(clazz.getName(), (Object)factory, serviceProperties);
    }

    static synchronized void removeProxyServlet(ProxyServlet proxyServlet) {
        ServiceRegistration registration = (ServiceRegistration)serviceRegistrations.remove(proxyServlet);
        if (registration != null) {
            registration.unregister();
        }
    }
}

