/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.HttpServletRequestAdaptor;
import org.eclipse.equinox.http.servlet.internal.Registration;
import org.osgi.service.http.HttpContext;

public class ResourceRegistration
extends Registration {
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String ETAG = "ETag";
    private String internalName;
    HttpContext httpContext;
    ServletContext servletContext;
    private AccessControlContext acc;

    public ResourceRegistration(String internalName, HttpContext context, ServletContext servletContext, AccessControlContext acc) {
        this.internalName = internalName;
        if (internalName.equals("/")) {
            this.internalName = "";
        }
        this.httpContext = context;
        this.servletContext = servletContext;
        this.acc = acc;
    }

    public boolean handleRequest(HttpServletRequest req, HttpServletResponse resp, String alias) throws IOException {
        if (this.httpContext.handleSecurity(req, resp)) {
            String method = req.getMethod();
            if (method.equals("GET") || method.equals("POST") || method.equals("HEAD")) {
                String pathInfo = HttpServletRequestAdaptor.getDispatchPathInfo(req);
                int aliasLength = alias.equals("/") ? 0 : alias.length();
                String resourcePath = String.valueOf(this.internalName) + pathInfo.substring(aliasLength);
                URL testURL = this.httpContext.getResource(resourcePath);
                if (testURL == null || resourcePath.endsWith("/")) {
                    return false;
                }
                return this.writeResource(req, resp, resourcePath);
            }
            resp.setStatus(405);
        }
        return true;
    }

    private boolean writeResource(final HttpServletRequest req, final HttpServletResponse resp, final String resourcePath) throws IOException {
        Boolean result = Boolean.TRUE;
        try {
            result = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String contentType;
                    String ifNoneMatch;
                    URL url = ResourceRegistration.this.httpContext.getResource(resourcePath);
                    if (url == null) {
                        return Boolean.FALSE;
                    }
                    URLConnection connection = url.openConnection();
                    long lastModified = connection.getLastModified();
                    int contentLength = connection.getContentLength();
                    if (contentLength <= 0) {
                        return Boolean.FALSE;
                    }
                    String etag = null;
                    if (lastModified != -1L && contentLength != -1) {
                        etag = "W/\"" + contentLength + "-" + lastModified + "\"";
                    }
                    if ((ifNoneMatch = req.getHeader(ResourceRegistration.IF_NONE_MATCH)) != null && etag != null && ifNoneMatch.indexOf(etag) != -1) {
                        resp.setStatus(304);
                        return Boolean.TRUE;
                    }
                    long ifModifiedSince = req.getDateHeader(ResourceRegistration.IF_MODIFIED_SINCE);
                    if (ifModifiedSince > -1L && lastModified > 0L && lastModified <= ifModifiedSince + 999L) {
                        resp.setStatus(304);
                        return Boolean.TRUE;
                    }
                    if (contentLength != -1) {
                        resp.setContentLength(contentLength);
                    }
                    if ((contentType = ResourceRegistration.this.httpContext.getMimeType(resourcePath)) == null) {
                        contentType = ResourceRegistration.this.servletContext.getMimeType(resourcePath);
                    }
                    if (contentType != null) {
                        resp.setContentType(contentType);
                    }
                    if (lastModified > 0L) {
                        resp.setDateHeader(ResourceRegistration.LAST_MODIFIED, lastModified);
                    }
                    if (etag != null) {
                        resp.setHeader(ResourceRegistration.ETAG, etag);
                    }
                    try {
                        ServletOutputStream os = resp.getOutputStream();
                        int writtenContentLength = ResourceRegistration.this.writeResourceToOutputStream(connection, os);
                        if (contentLength == -1 || contentLength != writtenContentLength) {
                            resp.setContentLength(writtenContentLength);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        PrintWriter writer = resp.getWriter();
                        ResourceRegistration.this.writeResourceToWriter(connection, writer);
                    }
                    return Boolean.TRUE;
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return result;
    }

    int writeResourceToOutputStream(URLConnection connection, OutputStream os) throws IOException {
        InputStream is = connection.getInputStream();
        try {
            byte[] buffer = new byte[8192];
            int bytesRead = is.read(buffer);
            int writtenContentLength = 0;
            while (bytesRead != -1) {
                os.write(buffer, 0, bytesRead);
                writtenContentLength += bytesRead;
                bytesRead = is.read(buffer);
            }
            int n = writtenContentLength;
            return n;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    void writeResourceToWriter(URLConnection connection, Writer writer) throws IOException {
        InputStream is = connection.getInputStream();
        try {
            InputStreamReader reader = new InputStreamReader(connection.getInputStream());
            try {
                char[] buffer = new char[8192];
                int charsRead = reader.read(buffer);
                while (charsRead != -1) {
                    writer.write(buffer, 0, charsRead);
                    charsRead = reader.read(buffer);
                }
            }
            finally {
                if (reader != null) {
                    ((Reader)reader).close();
                    is = null;
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

