/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.app;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.sling.launchpad.base.impl.ClassLoaderResourceProvider;
import org.apache.sling.launchpad.base.impl.Sling;
import org.apache.sling.launchpad.base.shared.Launcher;
import org.apache.sling.launchpad.base.shared.Notifiable;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainDelegate
implements Launcher {
    private static final String[] logLevels = new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG"};
    private static final String PROP_LOG_LEVEL = "org.apache.sling.commons.log.level";
    private static final String PROP_LOG_FILE = "org.apache.sling.commons.log.file";
    private static final int DEFAULT_LOG_LEVEL = 3;
    private static final String PROP_PORT = "org.osgi.service.http.port";
    private static final String DEFAULT_PORT = "8080";
    private Notifiable notifiable;
    private Map<String, String> commandLine;
    private String slingHome;
    private Sling sling;
    private static final DateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS ");

    public void setNotifiable(Notifiable notifiable) {
        this.notifiable = notifiable;
    }

    public void setCommandLine(Map<String, String> args) {
        this.commandLine = new HashMap<String, String>();
        this.commandLine.put(PROP_PORT, DEFAULT_PORT);
        MainDelegate.parseCommandLine(args, this.commandLine);
    }

    public void setSlingHome(String slingHome) {
        this.slingHome = slingHome;
    }

    public boolean start() {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.commandLine == null) {
            this.setCommandLine(new HashMap<String, String>());
        }
        if (this.slingHome != null) {
            props.put("sling.home", this.slingHome);
        } else if (this.commandLine.containsKey("sling.home")) {
            props.put("sling.home", this.commandLine.get("sling.home"));
        }
        if (!this.commandLine.containsKey(PROP_LOG_LEVEL)) {
            int logLevel = 3;
        } else {
            int logLevel = MainDelegate.toLogLevelInt(this.commandLine.get(PROP_LOG_LEVEL), 3);
            this.commandLine.put("felix.log.level", String.valueOf(logLevel));
        }
        Logger logger = new Logger();
        MainDelegate.info("HTTP server port: " + this.commandLine.get(PROP_PORT), null);
        logger.setLogLevel(1);
        try {
            ClassLoaderResourceProvider resProvider = new ClassLoaderResourceProvider(this.getClass().getClassLoader());
            this.sling = new Sling(this.notifiable, logger, resProvider, props){

                @Override
                protected void loadPropertiesOverride(Map<String, String> properties) {
                    if (MainDelegate.this.commandLine != null) {
                        properties.putAll(MainDelegate.this.commandLine);
                    }
                }
            };
            return true;
        }
        catch (BundleException be) {
            MainDelegate.error("Failed to Start OSGi framework", be);
            return false;
        }
    }

    public void stop() {
        if (this.sling != null) {
            this.sling.destroy();
            this.sling = null;
        }
    }

    private static void parseCommandLine(Map<String, String> args, Map<String, String> props) {
        block11: for (Map.Entry<String, String> arg : args.entrySet()) {
            if (arg.getKey().length() == 1) {
                String value = arg.getValue();
                switch (arg.getKey().charAt(0)) {
                    case 'l': {
                        if (value == arg.getKey()) {
                            MainDelegate.terminate("Missing log level value", 1);
                            continue block11;
                        }
                        try {
                            int logLevel = Integer.parseInt(value);
                            value = MainDelegate.toLogLevel(logLevel);
                        }
                        catch (NumberFormatException nfe) {
                            value = MainDelegate.checkLogLevel(value);
                        }
                        if (value == null) continue block11;
                        props.put(PROP_LOG_LEVEL, value);
                        break;
                    }
                    case 'f': {
                        if (value == arg.getKey()) {
                            MainDelegate.terminate("Missing log file value", 1);
                            continue block11;
                        }
                        if ("-".equals(value)) {
                            value = "";
                        }
                        props.put(PROP_LOG_FILE, value);
                        break;
                    }
                    case 'c': {
                        if (value == arg.getKey()) {
                            MainDelegate.terminate("Missing directory value", 1);
                            continue block11;
                        }
                        props.put("sling.home", value);
                        break;
                    }
                    case 'p': {
                        if (value == arg.getKey()) {
                            MainDelegate.terminate("Missing port value", 1);
                            continue block11;
                        }
                        try {
                            Integer.parseInt(value);
                            props.put(PROP_PORT, value);
                        }
                        catch (RuntimeException e) {
                            MainDelegate.terminate("Bad port: " + value, 1);
                        }
                        break;
                    }
                    case 'a': {
                        if (value == arg.getKey()) {
                            MainDelegate.terminate("Missing address value", 1);
                            continue block11;
                        }
                        MainDelegate.info("Setting the address to bind to is not supported, binding to 0.0.0.0", null);
                        break;
                    }
                    default: {
                        MainDelegate.terminate("Unrecognized option " + arg.getKey(), 1);
                        break;
                    }
                }
                continue;
            }
            MainDelegate.terminate("Unrecognized option " + arg.getKey(), 1);
        }
    }

    private static String toLogLevel(int level) {
        if (level >= 0 && level < logLevels.length) {
            return logLevels[level];
        }
        MainDelegate.terminate("Bad log level: " + level, 1);
        return null;
    }

    private static String checkLogLevel(String level) {
        for (int i = 0; i < logLevels.length; ++i) {
            if (!logLevels[i].equalsIgnoreCase(level)) continue;
            return logLevels[i];
        }
        MainDelegate.terminate("Bad log level: " + level, 1);
        return null;
    }

    private static int toLogLevelInt(String level, int defaultLevel) {
        for (int i = 0; i < logLevels.length; ++i) {
            if (!logLevels[i].equalsIgnoreCase(level)) continue;
            return i;
        }
        return defaultLevel;
    }

    private static void terminate(String message, int code) {
        if (message != null) {
            MainDelegate.error(message + " (use -h for more information)", null);
        }
        System.exit(code);
    }

    static void info(String message, Throwable t) {
        MainDelegate.log(System.out, "*INFO*", message, t);
    }

    static void error(String message, Throwable t) {
        MainDelegate.log(System.err, "*ERROR*", message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(PrintStream out, String prefix, String message, Throwable t) {
        StringBuilder linePrefixBuilder = new StringBuilder();
        DateFormat dateFormat = fmt;
        synchronized (dateFormat) {
            linePrefixBuilder.append(fmt.format(new Date()));
        }
        linePrefixBuilder.append(prefix);
        linePrefixBuilder.append(" [");
        linePrefixBuilder.append(Thread.currentThread().getName());
        linePrefixBuilder.append("] ");
        final String linePrefix = linePrefixBuilder.toString();
        out.print(linePrefix);
        out.println(message);
        if (t != null) {
            t.printStackTrace(new PrintStream((OutputStream)out){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void println(String x) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        this.print(linePrefix);
                        super.println(x);
                        this.flush();
                    }
                }
            });
        }
    }
}

