/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.felix.framework.Logger;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.apache.sling.launchpad.base.impl.bootstrapcommands.BootstrapCommandFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BootstrapInstaller
implements BundleActivator,
FrameworkListener {
    private static final String SCHEME = "slinginstall:";
    private static final String PATH_RESOURCES = "resources/";
    private static final String PATH_STARTUP = "startup/";
    static final String PATH_CORE_BUNDLES = "resources/corebundles";
    static final String PATH_BUNDLES = "resources/bundles";
    private static final String[] BUNDLE_EXTENSIONS = new String[]{".jar", ".war"};
    static final String BND_LAST_MODIFIED_HEADER = "Bnd-LastModified";
    private static final int STARTLEVEL_CORE_BUNDLES = 1;
    private static final int STARTLEVEL_BUNDLES = 0;
    private static final int STARTLEVEL_NONE = -1;
    private static final String DATA_FILE = "bootstrapinstaller.ser";
    private static final String BOOTSTRAP_CMD_FILENAME = "sling_bootstrap.txt";
    private final Logger logger;
    private final LaunchpadContentProvider resourceProvider;
    private BundleContext bundleContext;
    private int targetStartLevel;
    private static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory();
        }
    };
    private static final FileFilter BUNDLE_FILE_FILTER = new FileFilter(){

        public boolean accept(File f) {
            return f.isFile() && BootstrapInstaller.isBundle(f.getName());
        }
    };

    BootstrapInstaller(Logger logger, LaunchpadContentProvider resourceProvider, Map<String, String> props) {
        this.logger = logger;
        this.resourceProvider = resourceProvider;
        this.targetStartLevel = BootstrapInstaller.getStartLevel(props);
    }

    @Override
    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.bundleContext.addFrameworkListener(this);
        String slingHome = context.getProperty("sling.home");
        File slingStartupDir = this.getSlingStartupDir(slingHome);
        BootstrapCommandFile cmd = new BootstrapCommandFile(this.logger, new File(slingHome, BOOTSTRAP_CMD_FILENAME));
        cmd.execute(context);
        boolean shouldInstall = false;
        String fpblString = context.getProperty("org.apache.sling.launchpad.force.package.bundle.loading");
        if (Boolean.valueOf(fpblString).booleanValue()) {
            shouldInstall = true;
        } else {
            boolean bl = shouldInstall = !this.isAlreadyInstalled(context, slingStartupDir);
        }
        if (shouldInstall) {
            String dpblString = context.getProperty("org.apache.sling.launchpad.disable.package.bundle.loading");
            Boolean disablePackageBundleLoading = Boolean.valueOf(dpblString);
            if (disablePackageBundleLoading.booleanValue()) {
                this.logger.log(3, "Package bundle loading is disabled so no bundles will be installed from the resources location in the sling jar/war");
            } else {
                Iterator resources = this.resourceProvider.getChildren(PATH_BUNDLES);
                while (resources.hasNext()) {
                    int startLevel;
                    String path = (String)resources.next();
                    if (!path.endsWith("/") || (startLevel = this.getStartLevel(path = path.substring(0, path.length() - 1))) == -1) continue;
                    this.copyBundles(slingStartupDir, path, startLevel);
                }
                this.copyBundles(slingStartupDir, PATH_CORE_BUNDLES, 1);
                this.copyBundles(slingStartupDir, PATH_BUNDLES, 0);
            }
            Bundle[] bundles = context.getBundles();
            HashMap<String, Bundle> bySymbolicName = new HashMap<String, Bundle>();
            for (int i = 0; i < bundles.length; ++i) {
                bySymbolicName.put(bundles[i].getSymbolicName(), bundles[i]);
            }
            LinkedList<Bundle> installed = new LinkedList<Bundle>();
            boolean requireRestart = this.installBundles(slingStartupDir, context, bySymbolicName, installed);
            this.startBundles(installed);
            this.markInstalled(context, slingStartupDir);
            if (requireRestart) {
                this.logger.log(3, "Framework extension(s) have been updated, restarting framework after startup has completed");
                this.targetStartLevel = -1;
            }
        }
    }

    @Override
    public void stop(BundleContext context) {
        this.bundleContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            this.bundleContext.removeFrameworkListener(this);
            if (this.targetStartLevel < 1) {
                this.logger.log(3, "Restarting framework to resolve new framework extension(s)");
                try {
                    this.bundleContext.getBundle(0L).update();
                }
                catch (BundleException be) {
                    this.logger.log(1, "Failed restarting to resolve new framework extension(s)", be);
                }
            } else {
                ServiceReference sr = this.bundleContext.getServiceReference(StartLevel.class.getName());
                if (sr != null) {
                    StartLevel sl = (StartLevel)this.bundleContext.getService(sr);
                    try {
                        this.logger.log(3, "Setting start level to " + this.targetStartLevel);
                        sl.setStartLevel(this.targetStartLevel);
                    }
                    finally {
                        this.bundleContext.ungetService(sr);
                    }
                } else {
                    this.logger.log(2, "StartLevel service not available, will not set the start level");
                }
            }
        }
    }

    private File getSlingStartupDir(String slingHome) {
        if (BootstrapInstaller.isBlank(slingHome)) {
            throw new IllegalStateException("Fatal error in bootstrap: Cannot get the sling.home value: " + slingHome);
        }
        File slingHomeDir = new File(slingHome).getAbsoluteFile();
        if (!(slingHomeDir.exists() && slingHomeDir.canRead() && slingHomeDir.canWrite() && slingHomeDir.isDirectory())) {
            throw new IllegalStateException("Fatal error in bootstrap: Cannot find accessible existing sling.home directory: " + slingHomeDir);
        }
        File slingHomeStartupDir = this.getOrCreateDirectory(slingHomeDir, PATH_STARTUP);
        return slingHomeStartupDir;
    }

    private File getOrCreateDirectory(File parentDir, String subDirName) {
        File slingHomeStartupDir = new File(parentDir, subDirName).getAbsoluteFile();
        if (slingHomeStartupDir.exists()) {
            if (!(slingHomeStartupDir.isDirectory() && parentDir.canRead() && parentDir.canWrite())) {
                throw new IllegalStateException("Fatal error in bootstrap: Cannot find accessible existing sling.homestartup/ directory: " + slingHomeStartupDir);
            }
        } else if (!slingHomeStartupDir.mkdirs()) {
            throw new IllegalStateException("Sling Home " + slingHomeStartupDir + " cannot be created as a directory");
        }
        return slingHomeStartupDir;
    }

    private void copyBundles(File slingStartupDir, String parent, int startLevel) {
        if (startLevel < 0) {
            startLevel = 0;
        }
        File startUpLevelDir = null;
        Iterator res = this.resourceProvider.getChildren(parent);
        while (res.hasNext()) {
            InputStream ins;
            String path = (String)res.next();
            if (!BootstrapInstaller.isBundle(path) || (ins = this.resourceProvider.getResourceAsStream(path)) == null) continue;
            if (startUpLevelDir == null) {
                startUpLevelDir = this.getOrCreateDirectory(slingStartupDir, String.valueOf(startLevel));
            }
            String bundleFileName = BootstrapInstaller.extractFileName(path);
            File bundleFile = new File(startUpLevelDir, bundleFileName);
            try {
                BootstrapInstaller.copyStreamToFile(ins, bundleFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Failure copying file from " + path + " to startup dir (" + startUpLevelDir + ") and name (" + bundleFileName + "): " + e, e);
            }
        }
    }

    static boolean isBundle(String path) {
        for (String extension : BUNDLE_EXTENSIONS) {
            if (!path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyStreamToFile(InputStream fromStream, File toFile) throws IOException {
        if (fromStream == null || toFile == null) {
            throw new IllegalArgumentException("fromStream and toFile must not be null");
        }
        if (!toFile.exists()) {
            toFile.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(toFile);
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = fromStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installBundles(File slingStartupDir, BundleContext context, Map<String, Bundle> currentBundles, List<Bundle> installed) {
        ServiceReference ref = context.getServiceReference(StartLevel.class.getName());
        StartLevel startLevelService = ref != null ? (StartLevel)context.getService(ref) : null;
        boolean requireRestart = false;
        try {
            File[] directories;
            for (File levelDir : directories = slingStartupDir.listFiles(DIRECTORY_FILTER)) {
                File[] bundleFiles;
                int startLevel;
                String dirName = levelDir.getName();
                try {
                    startLevel = Integer.decode(dirName);
                }
                catch (NumberFormatException e) {
                    startLevel = 0;
                }
                for (File bundleFile : bundleFiles = levelDir.listFiles(BUNDLE_FILE_FILTER)) {
                    requireRestart |= this.installBundle(bundleFile, startLevel, context, currentBundles, installed, startLevelService);
                }
            }
        }
        finally {
            if (ref != null) {
                context.ungetService(ref);
            }
        }
        return requireRestart;
    }

    private boolean installBundle(File bundleJar, int startLevel, BundleContext context, Map<String, Bundle> currentBundles, List<Bundle> installed, StartLevel startLevelService) {
        boolean requireRestart;
        FileInputStream ins;
        Manifest manifest = this.getManifest(bundleJar);
        if (manifest == null) {
            this.logger.log(1, "Ignoring " + bundleJar + ": Cannot read manifest");
            return false;
        }
        String symbolicName = this.getBundleSymbolicName(manifest);
        if (symbolicName == null) {
            this.logger.log(1, "Ignoring " + bundleJar + ": Missing " + "Bundle-SymbolicName" + " in manifest");
            return false;
        }
        Bundle installedBundle = currentBundles.get(symbolicName);
        if (this.ignore(installedBundle, manifest)) {
            this.logger.log(3, "Ignoring " + bundleJar + ": More recent version already installed");
            return false;
        }
        try {
            ins = new FileInputStream(bundleJar);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (installedBundle != null) {
            requireRestart = this.isSystemBundleFragment(installedBundle);
            try {
                installedBundle.update(ins);
                this.logger.log(3, "Bundle " + installedBundle.getSymbolicName() + " updated from " + bundleJar);
            }
            catch (BundleException be) {
                this.logger.log(1, "Bundle update from " + bundleJar + " failed", be);
            }
        } else {
            requireRestart = false;
            String path = bundleJar.getPath();
            String location = SCHEME + path.substring(path.lastIndexOf(47) + 1);
            try {
                Bundle theBundle = context.installBundle(location, ins);
                this.logger.log(3, "Bundle " + theBundle.getSymbolicName() + " installed from " + location);
                installed.add(theBundle);
                if (startLevel > 0) {
                    startLevelService.setBundleStartLevel(theBundle, startLevel);
                }
            }
            catch (BundleException be) {
                this.logger.log(1, "Bundle installation from " + location + " failed", be);
            }
        }
        return requireRestart;
    }

    private void startBundles(List<Bundle> bundles) {
        for (Bundle bundle : bundles) {
            try {
                if (BootstrapInstaller.isFragment(bundle)) continue;
                bundle.start();
            }
            catch (BundleException be) {
                this.logger.log(1, "Bundle " + bundle.getSymbolicName() + " could not be started", be);
            }
        }
    }

    private int getStartLevel(String path) {
        String name = path.substring(path.lastIndexOf(47) + 1);
        try {
            int level = Integer.parseInt(name);
            if (level >= 0) {
                return level;
            }
            this.logger.log(1, "Illegal Runlevel for " + path + ", ignoring");
        }
        catch (NumberFormatException nfe) {
            this.logger.log(3, "Folder " + path + " does not denote start level, ignoring");
        }
        return -1;
    }

    private boolean isSystemBundleFragment(Bundle installedBundle) {
        String fragmentHeader = (String)installedBundle.getHeaders().get("Fragment-Host");
        return fragmentHeader != null && fragmentHeader.indexOf("extension") > 0;
    }

    private Manifest getManifest(File jar) {
        try {
            FileInputStream ins = new FileInputStream(jar);
            return this.getManifest(ins);
        }
        catch (FileNotFoundException e) {
            this.logger.log(2, "Could not get inputstream from file (" + jar + "):" + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Manifest getManifest(InputStream ins) {
        try {
            JarInputStream jis = new JarInputStream(ins);
            Manifest manifest = jis.getManifest();
            return manifest;
        }
        catch (IOException ioe) {
            this.logger.log(1, "Failed to read manifest from stream: " + ins, ioe);
        }
        finally {
            try {
                ins.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    String getBundleSymbolicName(Manifest manifest) {
        return manifest.getMainAttributes().getValue("Bundle-SymbolicName");
    }

    private boolean ignore(Bundle installedBundle, Manifest manifest) {
        String installedVersionProp;
        Version installedVersion;
        if (installedBundle == null) {
            return false;
        }
        String versionProp = manifest.getMainAttributes().getValue("Bundle-Version");
        Version newVersion = Version.parseVersion(versionProp);
        if (newVersion.equals(installedVersion = Version.parseVersion(installedVersionProp = (String)installedBundle.getHeaders().get("Bundle-Version"))) && installedVersionProp.endsWith("SNAPSHOT") && this.isNewerSnapshot(installedBundle, manifest)) {
            this.logger.log(3, "Forcing upgrade of SNAPSHOT bundle: " + installedBundle.getSymbolicName());
            return false;
        }
        return newVersion.compareTo(installedVersion) <= 0;
    }

    private static boolean isFragment(Bundle bundle) {
        Dictionary headerMap = bundle.getHeaders();
        return headerMap.get("Fragment-Host") != null;
    }

    private boolean isNewerSnapshot(Bundle installedBundle, Manifest manifest) {
        long installedTime;
        String installedDate = (String)installedBundle.getHeaders().get(BND_LAST_MODIFIED_HEADER);
        String toBeInstalledDate = manifest.getMainAttributes().getValue(BND_LAST_MODIFIED_HEADER);
        if (installedDate == null) {
            this.logger.log(4, String.format("Currently installed bundle %s doesn't have a %s header", installedBundle.getSymbolicName(), BND_LAST_MODIFIED_HEADER));
            return true;
        }
        if (toBeInstalledDate == null) {
            this.logger.log(4, String.format("Candidate bundle %s doesn't have a %s header", installedBundle.getSymbolicName(), BND_LAST_MODIFIED_HEADER));
            return true;
        }
        long toBeInstalledTime = 0L;
        try {
            installedTime = Long.valueOf(installedDate);
        }
        catch (NumberFormatException e) {
            this.logger.log(4, String.format("%s header of currently installed bundle %s isn't parseable.", BND_LAST_MODIFIED_HEADER, installedBundle.getSymbolicName()));
            return true;
        }
        try {
            toBeInstalledTime = Long.valueOf(toBeInstalledDate);
        }
        catch (NumberFormatException e) {
            this.logger.log(4, String.format("%s header of candidate bundle %s isn't parseable.", BND_LAST_MODIFIED_HEADER, installedBundle.getSymbolicName()));
            return true;
        }
        return toBeInstalledTime > installedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlreadyInstalled(BundleContext context, File slingStartupDir) {
        File dataFile = context.getDataFile(DATA_FILE);
        if (dataFile != null && dataFile.exists()) {
            FileInputStream fis = null;
            try {
                long selfStamp = this.getSelfTimestamp(slingStartupDir);
                if (selfStamp > 0L) {
                    fis = new FileInputStream(dataFile);
                    byte[] bytes = new byte[20];
                    int len = fis.read(bytes);
                    String value = new String(bytes, 0, len);
                    long storedStamp = Long.parseLong(value);
                    this.logger.log(3, String.format("Stored timestamp: %s", storedStamp));
                    boolean bl = storedStamp >= selfStamp;
                    return bl;
                }
            }
            catch (NumberFormatException nfe) {
            }
            catch (IOException ioe) {
                this.logger.log(1, "IOException during reading of installed flag.", ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markInstalled(BundleContext context, File slingStartupDir) {
        File dataFile = context.getDataFile(DATA_FILE);
        try {
            FileOutputStream fos = new FileOutputStream(dataFile);
            try {
                fos.write(String.valueOf(this.getSelfTimestamp(slingStartupDir)).getBytes());
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (IOException ioe) {
            this.logger.log(1, "IOException during writing of installed flag.", ioe);
        }
    }

    private long getSelfTimestamp(File slingStartupDir) throws IOException {
        File[] directories;
        URLClassLoader urlLoader;
        URL[] urls;
        long selfStamp = -1L;
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader instanceof URLClassLoader && (urls = (urlLoader = (URLClassLoader)loader).getURLs()).length > 0) {
            URL url = urls[0];
            this.logger.log(3, String.format("Using timestamp from %s.", url));
            selfStamp = urls[0].openConnection().getLastModified();
        }
        for (File levelDir : directories = slingStartupDir.listFiles(DIRECTORY_FILTER)) {
            File[] jarFiles;
            for (File bundleJar : jarFiles = levelDir.listFiles(BUNDLE_FILE_FILTER)) {
                if (bundleJar.lastModified() <= selfStamp) continue;
                this.logger.log(3, String.format("Using timestamp from %s.", bundleJar));
                selfStamp = bundleJar.lastModified();
            }
        }
        this.logger.log(3, String.format("Final self timestamp: %s.", selfStamp));
        return selfStamp;
    }

    private static int getStartLevel(Map<String, String> props) {
        String startLevelS = props.get("org.osgi.framework.startlevel.beginning");
        if (startLevelS != null) {
            try {
                int startLevel = Integer.parseInt(startLevelS);
                if (startLevel >= 1) {
                    return startLevel;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    static boolean isBlank(String str) {
        return str == null || str.length() == 0 || str.trim().length() == 0;
    }

    static String extractFileName(String path) {
        if (BootstrapInstaller.isBlank(path)) {
            throw new IllegalArgumentException("Invalid blank path specified, cannot extract filename: " + path);
        }
        path = path.replace(File.separatorChar, '/');
        String name = "";
        int slashPos = path.lastIndexOf(47);
        if (slashPos == -1) {
            name = path;
        } else if (path.length() > slashPos + 1) {
            name = path.substring(slashPos + 1);
        }
        if (BootstrapInstaller.isBlank(name)) {
            throw new IllegalArgumentException("Invalid path, no filename found: " + path);
        }
        return name;
    }
}

