/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.apache.sling.launchpad.base.impl.BootstrapInstaller;
import org.apache.sling.launchpad.base.impl.ContextProtocolHandler;
import org.apache.sling.launchpad.base.impl.SlingFelix;
import org.apache.sling.launchpad.base.shared.Notifiable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.url.URLStreamHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sling
implements BundleActivator {
    private static final long serialVersionUID = 1L;
    public static final String SLING_HOME_URL = "sling.home.url";
    public static final String JCR_REPO_HOME = "sling.repository.home";
    public static final String JCR_REPO_CONFIG_FILE_URL = "sling.repository.config.file.url";
    public static final String OSGI_FRAMEWORK_BUNDLES = "org.apache.osgi.bundles";
    public static final String SLING_IGNORE_SYSTEM_PROPERTIES = "sling.ignoreSystemProperties";
    public static final String CONFIG_PROPERTIES = "sling.properties";
    public static final String PROP_SYSTEM_PACKAGES = "org.apache.sling.launcher.system.packages";
    private static final String[][] EE_NAMES = new String[][]{{"JRE-1.1"}, {"J2SE-1.2"}, {"J2SE-1.3", "OSGi/Minimum-1.0", "CDC-1.0/Foundation-1.0"}, {"J2SE-1.4", "OSGi/Minimum-1.1", "CDC-1.1/Foundation-1.1"}, {"J2SE-1.5"}, {"JavaSE-1.6"}};
    protected final Logger logger;
    private LaunchpadContentProvider resourceProvider;
    private Felix felix;
    private BundleContext bundleContext;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public Sling(Notifiable notifiable, Logger logger, LaunchpadContentProvider resourceProvider, Map<String, String> propOverwrite) throws BundleException {
        this.logger = logger;
        this.resourceProvider = resourceProvider;
        this.logger.log(3, "Starting Sling");
        Map<String, String> props = this.loadConfigProperties(propOverwrite);
        this.setInstallBundles(props);
        this.setExecutionEnvironment(props);
        BootstrapInstaller bi = new BootstrapInstaller(logger, resourceProvider, props);
        props.put("org.osgi.framework.startlevel.beginning", "1");
        ArrayList<BundleActivator> activators = new ArrayList<BundleActivator>();
        activators.add(this);
        activators.add(bi);
        HashMap<String, String> felixProps = new HashMap<String, String>(props);
        felixProps.put("felix.log.logger", (String)((Object)logger));
        felixProps.put("felix.systembundle.activators", (String)((Object)activators));
        try {
            SlingFelix tmpFelix = new SlingFelix(notifiable, felixProps);
            tmpFelix.init();
            tmpFelix.start();
            this.felix = tmpFelix;
        }
        catch (BundleException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BundleException("Uncaught Instantiation Issue: " + e, e);
        }
        this.logger.log(3, "Sling started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (this.felix != null) {
            Felix myFelix;
            Sling sling = this;
            synchronized (sling) {
                myFelix = this.felix;
                this.felix = null;
            }
            if (myFelix != null) {
                this.logger.log(3, "Shutting down Sling");
                try {
                    myFelix.stop();
                    myFelix.waitForStop(0L);
                }
                catch (BundleException be) {
                    this.logger.log(1, "Failure initiating Framework Shutdown", be);
                }
                catch (InterruptedException ie) {
                    this.logger.log(1, "Interrupted while waiting for the Framework Termination", ie);
                }
                this.logger.log(3, "Sling stopped");
            }
        }
    }

    @Override
    public final void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        props.put("url.handler.protocol", new String[]{"context"});
        ContextProtocolHandler contextHandler = new ContextProtocolHandler(this.resourceProvider);
        bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)contextHandler, props);
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        Properties mbeanProps = new Properties();
        try {
            ObjectName beanName = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
            AttributeList attrs = platformMBeanServer.getAttributes(beanName, new String[]{"MBeanServerId", "SpecificationName", "SpecificationVersion", "SpecificationVendor", "ImplementationName", "ImplementationVersion", "ImplementationVendor"});
            for (Object object : attrs) {
                Attribute attr = (Attribute)object;
                if (attr.getValue() == null) continue;
                mbeanProps.put(attr.getName(), attr.getValue().toString());
            }
        }
        catch (Exception je) {
            this.logger.log(3, "start: Cannot set service properties of Platform MBeanServer service, registering without", je);
        }
        bundleContext.registerService(MBeanServer.class.getName(), (Object)platformMBeanServer, (Dictionary)mbeanProps);
        bundleContext.registerService(LaunchpadContentProvider.class.getName(), (Object)this.resourceProvider, null);
        this.doStartBundle();
    }

    @Override
    public final void stop(BundleContext bundleContext) {
        try {
            this.doStopBundle();
        }
        catch (Exception e) {
            this.logger.log(1, "Unexpected exception caught", e);
        }
        this.bundleContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadConfigProperties(Map<String, String> propOverwrite) throws BundleException {
        String slingHome;
        HashMap<String, String> staticProps = new HashMap<String, String>();
        this.load(staticProps, CONFIG_PROPERTIES);
        this.loadIncludes(staticProps, null);
        if (propOverwrite != null) {
            staticProps.putAll(propOverwrite);
        }
        if ((slingHome = (String)staticProps.get("sling.home")) == null || slingHome.length() == 0) {
            throw new BundleException("sling.home property is missing, cannot start");
        }
        slingHome = Sling.substVars(slingHome, "sling.home", null, staticProps);
        File slingHomeFile = new File(slingHome).getAbsoluteFile();
        slingHome = slingHomeFile.getAbsolutePath();
        this.logger.log(3, "Starting sling in " + slingHome);
        File propFile = new File(slingHome, CONFIG_PROPERTIES);
        this.load(staticProps, propFile);
        this.migrateProp(staticProps, "felix.cache.profiledir", "org.osgi.framework.storage");
        this.migrateProp(staticProps, "sling.osgi-core-packages", "osgi-core-packages");
        this.migrateProp(staticProps, "sling.osgi-compendium-services", "osgi-compendium-services");
        this.migrateProp(staticProps, "org.osgi.framework.startlevel", "org.osgi.framework.startlevel.beginning");
        this.migrateProp(staticProps, "felix.startlevel.framework", "org.osgi.framework.startlevel.beginning");
        HashMap<String, String> runtimeProps = new HashMap<String, String>();
        runtimeProps.putAll(staticProps);
        String ignoreSystemProperties = (String)runtimeProps.get(SLING_IGNORE_SYSTEM_PROPERTIES);
        if (!"true".equalsIgnoreCase(ignoreSystemProperties)) {
            for (String string : runtimeProps.keySet()) {
                String sysProp = System.getProperty(string);
                if (sysProp == null) continue;
                runtimeProps.put(string, sysProp);
            }
        }
        this.loadIncludes(runtimeProps, slingHome);
        this.loadPropertiesOverride(runtimeProps);
        this.resolve(runtimeProps, "org.osgi.framework.bootdelegation", "sling.bootdelegation.");
        this.resolve(runtimeProps, "org.osgi.framework.system.packages", "sling.system.packages.");
        staticProps.put("sling.home", slingHome);
        runtimeProps.put("sling.home", slingHome);
        runtimeProps.put(SLING_HOME_URL, slingHomeFile.toURI().toString());
        runtimeProps.put(CONFIG_PROPERTIES, propFile.getAbsolutePath());
        try {
            runtimeProps.put("sling.properties.url", propFile.toURL().toString());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        for (Map.Entry entry : runtimeProps.entrySet()) {
            entry.setValue(Sling.substVars((String)entry.getValue(), (String)entry.getKey(), null, runtimeProps));
        }
        for (Map.Entry entry : runtimeProps.entrySet()) {
            String path;
            InputStream src;
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null || !value.startsWith("context:/") || (src = this.resourceProvider.getResourceAsStream(path = value.substring("context:/".length() - 1))) == null) continue;
            File target = new File(slingHome, path);
            OutputStream dest = null;
            try {
                if (!target.exists()) {
                    int rd;
                    target.getParentFile().mkdirs();
                    dest = new FileOutputStream(target);
                    byte[] buf = new byte[2048];
                    while ((rd = src.read(buf)) >= 0) {
                        dest.write(buf, 0, rd);
                    }
                }
                entry.setValue(target.getAbsolutePath());
                staticProps.put(name, "${sling.home}" + path);
            }
            catch (IOException ioe) {
                this.logger.log(1, "Cannot copy file " + value + " to " + target, ioe);
            }
            finally {
                if (dest != null) {
                    try {
                        dest.close();
                    }
                    catch (IOException ignore) {}
                }
                try {
                    src.close();
                }
                catch (IOException ignore) {}
            }
        }
        OutputStream os = null;
        try {
            propFile.getParentFile().mkdirs();
            os = new FileOutputStream(propFile);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)staticProps);
            properties.store(os, "Overlay properties for configuration");
        }
        catch (Exception exception) {
            this.logger.log(1, "Error loading overlay properties from " + propFile, exception);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return runtimeProps;
    }

    private void resolve(Map<String, String> props, String osgiProp, String prefix) {
        String propVal = props.get(osgiProp);
        StringBuffer prop = new StringBuffer(propVal == null ? "" : propVal);
        boolean mod = false;
        for (Map.Entry<String, String> pEntry : props.entrySet()) {
            String key = pEntry.getKey();
            if (!key.startsWith(prefix)) continue;
            if (key.indexOf("class.") == prefix.length()) {
                String className = key.substring(prefix.length() + "class.".length());
                try {
                    this.getClass().getClassLoader().loadClass(className);
                }
                catch (Throwable t) {
                    this.logger.log(4, "Class " + className + " not found. Ignoring '" + pEntry.getValue() + "' for property " + osgiProp);
                    continue;
                }
            }
            this.logger.log(4, "Adding '" + pEntry.getValue() + "' to property " + osgiProp);
            if (prop.length() > 0) {
                prop.append(',');
            }
            prop.append(pEntry.getValue());
            mod = true;
        }
        if (mod) {
            this.logger.log(4, "Setting property " + osgiProp + " to " + prop.toString());
            props.put(osgiProp, prop.toString());
        }
    }

    private void migrateProp(Map<String, String> props, String oldName, String newName) {
        String propValue = props.remove(oldName);
        if (propValue != null) {
            String previousNewValue = props.put(newName, propValue);
            if (previousNewValue != null) {
                this.logger.log(2, "Old value (" + previousNewValue + ") of property " + newName + " by value: " + propValue);
            } else {
                this.logger.log(3, "Property " + oldName + " (" + propValue + ") renamed to " + newName);
            }
        } else {
            this.logger.log(4, "Property " + oldName + " does not exist, nothing to do");
        }
    }

    private void setInstallBundles(Map<String, String> props) {
        String prefix = "sling.install.";
        TreeSet<String> levels = new TreeSet<String>();
        for (String key : props.keySet()) {
            if (!key.startsWith(prefix)) continue;
            levels.add(key.substring(prefix.length()));
        }
        StringBuffer buf = new StringBuffer();
        for (String level : levels) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(level);
        }
        props.put(prefix + "bundles", buf.toString());
    }

    private void setExecutionEnvironment(Map<String, String> props) {
        int javaMinor;
        String ee = props.get("org.osgi.framework.executionenvironment");
        if (ee == null) {
            ee = System.getProperty("org.osgi.framework.executionenvironment");
        }
        StringBuilder eebuilder = new StringBuilder();
        if (ee != null) {
            eebuilder.append(ee);
        }
        try {
            String specVString = System.getProperty("java.specification.version");
            javaMinor = Version.parseVersion(specVString).getMinor();
        }
        catch (IllegalArgumentException iae) {
            javaMinor = 5;
        }
        for (int i = 0; i < javaMinor && i < EE_NAMES.length; ++i) {
            String[] vmEENames;
            for (String vmEEName : vmEENames = EE_NAMES[i]) {
                if (eebuilder.indexOf(vmEEName) >= 0) continue;
                if (eebuilder.length() > 0) {
                    eebuilder.append(',');
                }
                eebuilder.append(vmEEName);
            }
        }
        ee = eebuilder.toString();
        this.logger.log(3, "Using Execution Environment setting: " + ee);
        props.put("org.osgi.framework.executionenvironment", ee);
    }

    protected void loadPropertiesOverride(Map<String, String> properties) {
    }

    protected final BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected void doStartBundle() throws Exception {
    }

    protected void doStopBundle() {
    }

    private void loadIncludes(Map<String, String> props, String slingHome) {
        TreeMap<String, String> includes = new TreeMap<String, String>();
        Iterator<Map.Entry<String, String>> pi = props.entrySet().iterator();
        while (pi.hasNext()) {
            Map.Entry<String, String> entry = pi.next();
            if (!entry.getKey().startsWith("sling.include.") && !entry.getKey().equals("sling.include")) continue;
            includes.put(entry.getKey(), entry.getValue());
            pi.remove();
        }
        for (Map.Entry entry : includes.entrySet()) {
            String key = (String)entry.getKey();
            String include = (String)entry.getValue();
            include = Sling.substVars(include, key, null, props);
            StringTokenizer tokener = new StringTokenizer(include, ",");
            while (tokener.hasMoreTokens()) {
                String file = tokener.nextToken().trim();
                InputStream is = this.resourceProvider.getResourceAsStream(file);
                try {
                    if (is == null && slingHome != null) {
                        File resFile = new File(file);
                        if (!resFile.isAbsolute()) {
                            resFile = new File(slingHome, file);
                        }
                        if (resFile.canRead()) {
                            is = new FileInputStream(resFile);
                            file = resFile.getAbsolutePath();
                        }
                    }
                    if (is == null) continue;
                    this.load(props, is);
                }
                catch (IOException ioe) {
                    this.logger.log(1, "Error loading config properties from " + file, ioe);
                }
            }
        }
    }

    private void load(Map<String, String> props, String resource) {
        InputStream is = this.resourceProvider.getResourceAsStream(resource);
        if (is != null) {
            try {
                this.load(props, is);
            }
            catch (IOException ioe) {
                this.logger.log(1, "Error loading config properties from " + resource, ioe);
            }
        }
    }

    private void load(Map<String, String> props, File file) {
        if (file != null && file.canRead()) {
            try {
                this.load(props, new FileInputStream(file));
            }
            catch (IOException ioe) {
                this.logger.log(1, "Error loading config properties from " + file.getAbsolutePath(), ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Map<String, String> props, InputStream ins) throws IOException {
        try {
            Properties tmp = new Properties();
            tmp.load(ins);
            for (Map.Entry<Object, Object> entry : tmp.entrySet()) {
                props.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            try {
                ins.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.get(variable) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = Sling.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }
}

