/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.felix.framework.Felix;
import org.apache.sling.launchpad.base.shared.Loader;
import org.apache.sling.launchpad.base.shared.Notifiable;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingFelix
extends Felix {
    private final Notifiable notifiable;
    private Notifier notifierThread;

    public SlingFelix(Notifiable notifiable, Map<?, ?> props) throws Exception {
        super(props);
        this.notifiable = notifiable;
    }

    @Override
    public void update() throws BundleException {
        this.update(null);
    }

    @Override
    public void update(InputStream is) throws BundleException {
        this.startNotifier(true, is);
        super.stop();
    }

    @Override
    public void stop() throws BundleException {
        this.startNotifier(false, null);
        super.stop();
    }

    @Override
    public void stop(int status) throws BundleException {
        this.startNotifier(false, null);
        super.stop(status);
    }

    private synchronized void startNotifier(boolean restart, InputStream ins) {
        if (this.notifierThread == null) {
            this.notifierThread = new Notifier(restart, ins);
            this.notifierThread.setDaemon(false);
            this.notifierThread.start();
        }
    }

    private class Notifier
    extends Thread {
        private final boolean restart;
        private final File updateFile;

        private Notifier(boolean restart, InputStream ins) {
            super("Sling Notifier");
            this.restart = restart;
            if (ins != null) {
                File tmpFile;
                try {
                    tmpFile = File.createTempFile("slingupdate", ".jar");
                    Loader.spool((InputStream)ins, (File)tmpFile);
                }
                catch (IOException ioe) {
                    tmpFile = null;
                }
                this.updateFile = tmpFile;
            } else {
                this.updateFile = null;
            }
        }

        public void run() {
            try {
                SlingFelix.this.waitForStop(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.restart) {
                SlingFelix.this.notifiable.updated(this.updateFile);
            } else {
                SlingFelix.this.notifiable.stopped();
            }
        }
    }
}

