/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl.bootstrapcommands;

import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.VersionRange;
import org.apache.sling.launchpad.base.impl.bootstrapcommands.Command;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class UninstallBundleCommand
implements Command {
    public static String CMD_PREFIX = "uninstall ";
    private final String bundleSymbolicName;
    private final VersionRange versionRange;

    UninstallBundleCommand() {
        this.bundleSymbolicName = null;
        this.versionRange = null;
    }

    private UninstallBundleCommand(String bundleSymbolicName, String versionRangeStr) {
        this.bundleSymbolicName = bundleSymbolicName;
        if (!versionRangeStr.contains(",")) {
            versionRangeStr = "[" + versionRangeStr + "," + versionRangeStr + "]";
        }
        this.versionRange = VersionRange.parse(versionRangeStr);
    }

    public void execute(Logger logger, BundleContext ctx) throws Exception {
        for (Bundle b : ctx.getBundles()) {
            if (!b.getSymbolicName().equals(this.bundleSymbolicName)) continue;
            if (this.versionRange.isInRange(b.getVersion())) {
                logger.log(3, this + ": uninstalling bundle version " + b.getVersion());
                b.uninstall();
                continue;
            }
            logger.log(3, this + ": bundle version (" + b.getVersion() + " not in range, ignored");
        }
    }

    public Command parse(String commandLine) throws Command.ParseException {
        if (commandLine.startsWith(CMD_PREFIX)) {
            String[] s = commandLine.split(" ");
            if (s.length == 3) {
                return new UninstallBundleCommand(s[1].trim(), s[2].trim());
            }
            throw new Command.ParseException("Syntax error: '" + commandLine + "'");
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.bundleSymbolicName + " " + this.versionRange;
    }
}

