/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.framework.Logger;
import org.apache.sling.launchpad.api.StartupHandler;
import org.apache.sling.launchpad.api.StartupListener;
import org.apache.sling.launchpad.api.StartupMode;
import org.apache.sling.launchpad.base.impl.StartupManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DefaultStartupHandler
implements StartupHandler,
BundleListener,
FrameworkListener,
Runnable {
    private final Logger logger;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final AtomicInteger startupShouldWait = new AtomicInteger(0);
    private final BlockingQueue<Boolean> queue = new LinkedBlockingQueue<Boolean>();
    private final StartLevel startLevelService;
    private final long targetStartLevel;
    private final StartupMode startupMode;
    private final ServiceTracker listenerTracker;
    private final int expectedBundlesCount;
    private final Set<String> activeBundles = new HashSet<String>();
    private final BundleContext bundleContext;
    private final boolean useIncremental;

    public DefaultStartupHandler(final BundleContext context, Logger logger, StartupManager manager) {
        this.logger = logger;
        this.bundleContext = context;
        this.startupMode = manager.getMode();
        this.targetStartLevel = manager.getTargetStartLevel();
        this.listenerTracker = new ServiceTracker(context, StartupListener.class.getName(), new ServiceTrackerCustomizer(){

            public void removedService(ServiceReference reference, Object service) {
                context.ungetService(reference);
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public Object addingService(ServiceReference reference) {
                StartupListener listener = (StartupListener)context.getService(reference);
                if (listener != null) {
                    listener.inform(DefaultStartupHandler.this.startupMode, DefaultStartupHandler.this.finished.get());
                }
                return listener;
            }
        });
        this.listenerTracker.open();
        this.startLevelService = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
        context.addFrameworkListener(this);
        boolean bl = this.useIncremental = this.startupMode != StartupMode.RESTART && manager.isIncrementalStartupEnabled();
        if (!this.useIncremental) {
            Bundle[] bundles = context.getBundles();
            this.expectedBundlesCount = bundles != null && bundles.length > 0 ? bundles.length : 10;
            context.addBundleListener(this);
        } else {
            this.expectedBundlesCount = 10;
        }
        this.bundleContext.registerService(StartupHandler.class.getName(), (Object)this, null);
        logger.log(3, "Started startup handler with target start level=" + String.valueOf(this.targetStartLevel) + ", and expected bundle count=" + String.valueOf(this.expectedBundlesCount));
        Thread t = new Thread(this);
        t.start();
    }

    public StartupMode getMode() {
        return this.startupMode;
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public void run() {
        while (!this.finished.get()) {
            Boolean doInc = null;
            try {
                doInc = this.queue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (doInc == null || !doInc.booleanValue()) continue;
            if (this.startupShouldWait.get() == 0) {
                this.sleep(2000L);
            }
            while (this.startupShouldWait.get() != 0) {
                this.sleep(50L);
            }
            this.incStartLevel();
        }
    }

    private void incStartLevel() {
        int newLevel = this.startLevelService.getStartLevel() + 1;
        this.logger.log(4, "Increasing start level to " + String.valueOf(newLevel));
        this.startLevelService.setStartLevel(newLevel);
    }

    public void waitWithStartup(boolean flag) {
        this.logger.log(4, "Wait with startup " + flag);
        if (flag) {
            this.startupShouldWait.incrementAndGet();
        } else {
            this.startupShouldWait.decrementAndGet();
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void enqueue(boolean info) {
        try {
            this.queue.put(info);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (this.finished.get()) {
            return;
        }
        this.logger.log(4, "Received framework event " + event);
        if (!this.useIncremental) {
            if (event.getType() == 1) {
                this.startupFinished();
            }
        } else if (event.getType() == 1) {
            this.enqueue(true);
        } else if (event.getType() == 8) {
            if ((long)this.startLevelService.getStartLevel() >= this.targetStartLevel) {
                this.startupFinished();
            } else {
                this.enqueue(true);
                int startLevel = this.startLevelService.getStartLevel();
                this.logger.log(3, "Startup progress " + String.valueOf(startLevel) + '/' + String.valueOf(this.targetStartLevel));
                float ratio = (float)startLevel / (float)this.targetStartLevel;
                this.startupProgress(ratio);
            }
        }
    }

    private void startupFinished() {
        this.logger.log(3, "Startup finished.");
        this.finished.set(true);
        Object[] listeners = this.listenerTracker.getServices();
        if (listeners != null) {
            for (Object l : listeners) {
                if (!(l instanceof StartupListener)) continue;
                ((StartupListener)l).startupFinished(this.startupMode);
            }
        }
        this.enqueue(false);
        this.activeBundles.clear();
        if (!this.useIncremental) {
            this.bundleContext.removeBundleListener(this);
        }
        this.bundleContext.removeFrameworkListener(this);
    }

    private void startupProgress(float ratio) {
        Object[] listeners = this.listenerTracker.getServices();
        if (listeners != null) {
            for (Object l : listeners) {
                if (!(l instanceof StartupListener)) continue;
                ((StartupListener)l).startupProgress(ratio);
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (!this.finished.get()) {
            this.logger.log(4, "Received bundle event " + event);
            if (event.getType() == 32 || event.getType() == 2) {
                this.activeBundles.add(event.getBundle().getSymbolicName());
                this.logger.log(3, "Startup progress " + String.valueOf(this.activeBundles.size()) + '/' + String.valueOf(this.expectedBundlesCount));
                float ratio = (float)this.activeBundles.size() / (float)this.expectedBundlesCount;
                this.startupProgress(ratio);
            } else if (event.getType() == 4) {
                this.activeBundles.remove(event.getBundle().getSymbolicName());
            }
        }
    }
}

