/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.apache.sling.launchpad.api.StartupMode;
import org.apache.sling.launchpad.base.impl.DirectoryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartupManager {
    private static final String DATA_FILE = "launchpad-timestamp.txt";
    private static final String OLD_DATA_FILE = "bundle0" + File.separatorChar + "bootstrapinstaller.ser";
    private static final String OVERRIDE_PROP = "org.apache.sling.launchpad.startupmode";
    private final Logger logger;
    private final StartupMode mode;
    private final File startupDir;
    private final File confDir;
    private final long targetStartLevel;
    private final boolean incrementalStartupEnabled;

    StartupManager(Map<String, String> properties, Logger logger) {
        this.logger = logger;
        this.startupDir = DirectoryUtil.getStartupDir(properties);
        this.confDir = DirectoryUtil.getConfigDir(properties);
        String overrideMode = System.getProperty(OVERRIDE_PROP, properties.get(OVERRIDE_PROP));
        if (overrideMode != null) {
            this.mode = StartupMode.valueOf(overrideMode.toUpperCase());
            this.logger.log(3, "Override property set. Starting in mode " + (Object)((Object)this.mode));
        } else {
            this.mode = this.detectMode(properties.get("org.osgi.framework.storage"));
            this.logger.log(3, "Detected startup mode. Starting in mode " + (Object)((Object)this.mode));
        }
        this.targetStartLevel = Long.valueOf(properties.get("org.osgi.framework.startlevel.beginning"));
        this.incrementalStartupEnabled = Boolean.valueOf(properties.get("sling.framework.install.incremental"));
        if (this.mode != StartupMode.RESTART && this.incrementalStartupEnabled) {
            String startLevel = properties.get("sling.framework.install.startlevel");
            properties.put("org.osgi.framework.startlevel.beginning", startLevel != null ? startLevel : "10");
        }
    }

    public StartupMode getMode() {
        return this.mode;
    }

    public boolean isIncrementalStartupEnabled() {
        return this.incrementalStartupEnabled;
    }

    public long getTargetStartLevel() {
        return this.targetStartLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StartupMode detectMode(String osgiStorageDir) {
        block21: {
            File dataFile = new File(this.confDir, DATA_FILE);
            if (dataFile.exists()) {
                InputStreamReader fis = null;
                try {
                    long selfStamp = this.getSelfTimestamp();
                    if (selfStamp > 0L) {
                        fis = new FileReader(dataFile);
                        char[] txt = new char[128];
                        int len = fis.read(txt);
                        String value = new String(txt, 0, len);
                        long storedStamp = Long.parseLong(value);
                        this.logger.log(3, String.format("Stored startup timestamp: %s", storedStamp));
                        StartupMode startupMode = storedStamp >= selfStamp ? StartupMode.RESTART : StartupMode.UPDATE;
                        return startupMode;
                    }
                    break block21;
                }
                catch (NumberFormatException nfe) {
                    StartupMode startupMode = StartupMode.RESTART;
                    return startupMode;
                }
                catch (IOException ioe) {
                    this.logger.log(1, "IOException during reading of installed flag.", ioe);
                    break block21;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
            File felixDir = new File(osgiStorageDir);
            File oldFile = new File(felixDir, OLD_DATA_FILE);
            if (oldFile.exists()) {
                oldFile.delete();
                return StartupMode.UPDATE;
            }
        }
        return StartupMode.INSTALL;
    }

    private long getTimeStampOfClass(Class<?> clazz, long selfStamp) {
        URLClassLoader urlLoader;
        URL[] urls;
        long timeStamp = selfStamp;
        ClassLoader loader = clazz.getClassLoader();
        if (loader instanceof URLClassLoader && (urls = (urlLoader = (URLClassLoader)loader).getURLs()).length > 0) {
            URL url = urls[0];
            try {
                long stamp = urls[0].openConnection().getLastModified();
                if (stamp > selfStamp) {
                    this.logger.log(3, String.format("Newer timestamp for %s from %s : %s", clazz.getName(), url, selfStamp));
                    timeStamp = selfStamp;
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return timeStamp;
    }

    private long getSelfTimestamp() {
        long selfStamp = this.getTimeStampOfClass(this.getClass(), -1L);
        selfStamp = this.getTimeStampOfClass(LaunchpadContentProvider.class, selfStamp);
        File[] directories = this.startupDir.listFiles(DirectoryUtil.DIRECTORY_FILTER);
        if (directories != null) {
            for (File levelDir : directories) {
                File[] jarFiles = levelDir.listFiles(DirectoryUtil.BUNDLE_FILE_FILTER);
                if (jarFiles == null) continue;
                for (File bundleJar : jarFiles) {
                    if (bundleJar.lastModified() <= selfStamp) continue;
                    selfStamp = bundleJar.lastModified();
                    this.logger.log(3, String.format("Newer timestamp from %s : %s", bundleJar, selfStamp));
                }
            }
        }
        this.logger.log(3, String.format("Final self timestamp: %s.", selfStamp));
        return selfStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markInstalled() {
        File dataFile = new File(this.confDir, DATA_FILE);
        try {
            this.confDir.mkdirs();
            FileWriter fos = new FileWriter(dataFile);
            try {
                fos.write(String.valueOf(System.currentTimeMillis()));
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException ioe) {
            this.logger.log(1, "IOException during writing of installed flag.", ioe);
        }
    }
}

