/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl.bootstrapcommands;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.VersionRange;
import org.apache.sling.launchpad.base.impl.bootstrapcommands.Command;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

class UninstallBundleCommand
implements Command {
    private static String CMD_PREFIX = "uninstall ";
    private final String bundleSymbolicName;
    private final VersionRange versionRange;

    UninstallBundleCommand() {
        this.bundleSymbolicName = null;
        this.versionRange = null;
    }

    private UninstallBundleCommand(String bundleSymbolicName, String versionRangeStr) {
        this.bundleSymbolicName = bundleSymbolicName;
        if (!versionRangeStr.contains(",")) {
            versionRangeStr = "[" + versionRangeStr + "," + versionRangeStr + "]";
        }
        this.versionRange = VersionRange.parse(versionRangeStr);
    }

    private UninstallBundleCommand(String bundleSymbolicName) {
        this.bundleSymbolicName = bundleSymbolicName;
        this.versionRange = null;
    }

    private static String getFragmentHostHeader(Bundle b) {
        return b.getHeaders().get("Fragment-Host");
    }

    private boolean isSystemBundleFragment(Bundle installedBundle) {
        String fragmentHeader = installedBundle.getHeaders().get("Fragment-Host");
        return fragmentHeader != null && fragmentHeader.indexOf("extension") > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Logger logger, BundleContext ctx) throws Exception {
        HashSet<String> refreshBundles = new HashSet<String>();
        boolean refreshSystemBundle = false;
        for (Bundle b : ctx.getBundles()) {
            if (!b.getSymbolicName().equals(this.bundleSymbolicName)) continue;
            if (this.versionRange == null || this.versionRange.isInRange(b.getVersion())) {
                logger.log(3, this + ": uninstalling bundle version " + b.getVersion());
                String fragmentHostHeader = UninstallBundleCommand.getFragmentHostHeader(b);
                if (fragmentHostHeader != null) {
                    if (this.isSystemBundleFragment(b)) {
                        logger.log(3, this + ": Need to do a system bundle refresh");
                        refreshSystemBundle = true;
                    } else {
                        logger.log(3, this + ": Need to do a refresh of the bundle's host: " + fragmentHostHeader);
                        refreshBundles.add(fragmentHostHeader);
                    }
                }
                b.uninstall();
                continue;
            }
            logger.log(3, this + ": bundle version (" + b.getVersion() + " not in range, ignored");
        }
        if (refreshBundles.size() > 0) {
            ServiceReference<?> paRef;
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            for (Bundle b : ctx.getBundles()) {
                if (!refreshBundles.contains(b.getSymbolicName())) continue;
                logger.log(3, this + ": Found host bundle to refresh " + b.getBundleId());
                bundles.add(b);
            }
            if (bundles.size() > 0 && (paRef = ctx.getServiceReference(PackageAdmin.class.getName())) != null) {
                try {
                    PackageAdmin pa = (PackageAdmin)ctx.getService(paRef);
                    if (pa != null) {
                        pa.refreshPackages(bundles.toArray(new Bundle[bundles.size()]));
                    }
                }
                finally {
                    ctx.ungetService(paRef);
                }
            }
        }
        return refreshSystemBundle;
    }

    public Command parse(String commandLine) throws Command.ParseException {
        if (commandLine.startsWith(CMD_PREFIX)) {
            String[] s = commandLine.split(" ");
            if (s.length == 3) {
                return new UninstallBundleCommand(s[1].trim(), s[2].trim());
            }
            if (s.length == 2) {
                return new UninstallBundleCommand(s[1].trim());
            }
            throw new Command.ParseException("Syntax error: '" + commandLine + "'");
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.bundleSymbolicName + " " + (this.versionRange != null ? this.versionRange : "");
    }
}

