/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.webapp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.launchpad.base.shared.Launcher;
import org.apache.sling.launchpad.base.shared.Loader;
import org.apache.sling.launchpad.base.shared.Notifiable;
import org.apache.sling.launchpad.webapp.SlingSessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SlingServlet
extends GenericServlet
implements Notifiable {
    private static final int MAX_START_FAILURES = 20;
    private static final String SLING_HOME_PREFIX = "sling.home.prefix";
    private static final String SLING_HOME_PREFIX_DEFAULT = "sling/";
    private Map<String, String> properties;
    private String slingHome;
    private Loader loader;
    private Servlet sling;
    private Thread startingSling;
    private int startFailureCounter = 0;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public void init() {
        this.properties = this.collectInitParameters();
        this.slingHome = this.getSlingHome(null);
        if (this.slingHome != null) {
            this.startSling();
        } else {
            this.log("Apache Sling cannot be started yet, because sling.home is not defined yet");
        }
        this.log("Servlet " + this.getServletName() + " initialized");
    }

    public String getServletInfo() {
        if (this.sling != null) {
            return this.sling.getServletInfo();
        }
        return "Sling Launchpad Proxy";
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        Servlet delegatee = this.sling;
        if (delegatee != null) {
            HttpServletRequest request = (HttpServletRequest)req;
            if (request.getPathInfo() == null && request.getServletPath() != null && request.getServletPath().endsWith(".jsp")) {
                req = new /* Unavailable Anonymous Inner Class!! */;
            }
            delegatee.service(req, res);
        } else if (this.startFailureCounter > 20) {
            ((HttpServletResponse)res).sendError(404);
        } else {
            this.startSling(req);
            ((HttpServletResponse)res).sendError(503, "Apache Sling is currently starting up, please try again");
        }
    }

    public void destroy() {
        SlingSessionListener.stopDelegatee();
        if (this.sling != null) {
            this.sling.destroy();
        }
        this.slingHome = null;
        this.loader = null;
        this.sling = null;
    }

    public void stopped() {
        this.log("Apache Sling has been stopped");
        this.sling = null;
        SlingSessionListener.stopDelegatee();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(File updateFile) {
        SlingServlet slingServlet = this;
        synchronized (slingServlet) {
            if (this.startingSling == null) {
                this.sling = null;
                SlingSessionListener.stopDelegatee();
            }
        }
        this.loader.cleanupVM();
        if (updateFile == null) {
            this.log("Restarting Framework and Apache Sling");
            this.startSling((URL)null);
        } else {
            this.log("Restarting Framework with update from " + updateFile);
            try {
                this.startSling(updateFile.toURI().toURL());
            }
            catch (MalformedURLException mue) {
                this.log("Cannot get URL for file " + updateFile, (Throwable)mue);
            }
            finally {
                updateFile.delete();
            }
        }
    }

    private void startSling(ServletRequest request) {
        if (this.startingSling == null) {
            this.slingHome = this.getSlingHome((HttpServletRequest)request);
            Thread starter = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */, "SlingStarter_" + System.currentTimeMillis());
            starter.setDaemon(true);
            starter.start();
        }
    }

    private void startSling() {
        try {
            File launchpadHome = this.getLaunchpadHome(this.slingHome);
            this.loader = new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (IllegalArgumentException iae) {
            this.startupFailure(null, (Throwable)iae);
            return;
        }
        try {
            URL launcherJar = this.getServletContext().getResource("/resources/org.apache.sling.launchpad.base.jar");
            if (launcherJar == null) {
                launcherJar = this.getServletContext().getResource("/WEB-INF/resources/org.apache.sling.launchpad.base.jar");
            }
            this.startSling(launcherJar);
        }
        catch (MalformedURLException mue) {
            this.log("Cannot load Apache Sling Launcher JAR /resources/org.apache.sling.launchpad.base.jar", (Throwable)mue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSling(URL launcherJar) {
        SlingServlet slingServlet = this;
        synchronized (slingServlet) {
            if (this.sling != null) {
                this.log("Apache Sling already started, nothing to do");
                return;
            }
            if (this.startingSling != null) {
                this.log("Apache Sling being started by Thread " + this.startingSling);
                return;
            }
            this.startingSling = Thread.currentThread();
        }
        if (launcherJar != null) {
            try {
                this.log("Checking launcher JAR in " + this.slingHome);
                this.loader.installLauncherJar(launcherJar);
            }
            catch (IOException ioe) {
                this.startupFailure("Failed installing " + launcherJar, (Throwable)ioe);
                return;
            }
        } else {
            this.log("No Launcher JAR to install");
        }
        Object object = null;
        try {
            object = this.loader.loadLauncher("org.apache.sling.launchpad.base.webapp.SlingServletDelegate");
        }
        catch (IllegalArgumentException iae) {
            this.startupFailure("Cannot load Launcher Servlet org.apache.sling.launchpad.base.webapp.SlingServletDelegate", (Throwable)iae);
            return;
        }
        if (object instanceof Servlet) {
            Servlet sling = (Servlet)object;
            if (sling instanceof Launcher) {
                Launcher slingLauncher = (Launcher)sling;
                slingLauncher.setNotifiable((Notifiable)this);
                slingLauncher.setCommandLine(this.properties);
                slingLauncher.setSlingHome(this.slingHome);
            }
            SlingSessionListener.startDelegate((ClassLoader)sling.getClass().getClassLoader());
            try {
                this.log("Starting launcher ...");
                sling.init(this.getServletConfig());
                this.sling = sling;
                this.startFailureCounter = 0;
                this.log("Startup completed");
            }
            catch (ServletException se) {
                this.startupFailure(null, (Throwable)se);
            }
        }
        SlingServlet slingServlet2 = this;
        synchronized (slingServlet2) {
            this.startingSling = null;
        }
    }

    private String getSlingHome(HttpServletRequest request) {
        String source = null;
        String slingHome = this.getServletConfig().getInitParameter("sling.home");
        if (slingHome != null) {
            source = "servlet parameter sling.home";
        } else {
            slingHome = this.getServletContext().getInitParameter("sling.home");
            if (slingHome != null) {
                source = "servlet context parameter sling.home";
            } else {
                try {
                    String contextPath = this.getServletContext().getContextPath();
                    slingHome = this.toSlingHome(contextPath);
                    source = "servlet context path";
                }
                catch (NoSuchMethodError nsme) {
                    if (request != null) {
                        String contextPath = request.getContextPath();
                        slingHome = this.toSlingHome(contextPath);
                        source = "servlet context path (from request)";
                    }
                    this.log("ServletContext path not available here, delaying startup until first request");
                    return null;
                }
            }
        }
        slingHome = this.substVars(slingHome);
        slingHome = new File(slingHome).getAbsolutePath();
        this.log("Setting sling.home=" + slingHome + " (" + source + ")");
        return slingHome;
    }

    private File getLaunchpadHome(String slingHome) {
        String launchpadHomeParam = (String)this.properties.get("sling.launchpad");
        if (launchpadHomeParam == null || launchpadHomeParam.length() == 0) {
            this.properties.put("sling.launchpad", slingHome);
            return new File(slingHome);
        }
        File launchpadHome = new File(launchpadHomeParam);
        if (!launchpadHome.isAbsolute()) {
            launchpadHome = new File(slingHome, launchpadHomeParam);
        }
        this.properties.put("sling.launchpad", launchpadHome.getAbsolutePath());
        return launchpadHome;
    }

    private String toSlingHome(String contextPath) {
        String prefix = System.getProperty("sling.home.prefix", "sling/");
        if (!prefix.endsWith("/")) {
            prefix = prefix.concat("/");
        }
        if (contextPath == null || contextPath.length() == 0) {
            return prefix + "_";
        }
        return prefix + contextPath.replace('/', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupFailure(String message, Throwable cause) {
        if (message == null) {
            message = "Failed to start Apache Sling in " + this.slingHome;
        }
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        this.log(message, cause);
        ++this.startFailureCounter;
        SlingServlet slingServlet = this;
        synchronized (slingServlet) {
            this.startingSling = null;
        }
    }

    private Map<String, String> collectInitParameters() {
        String key;
        HashMap<String, String> props = new HashMap<String, String>();
        Enumeration keys = this.getServletContext().getInitParameterNames();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            props.put(key, this.getServletContext().getInitParameter(key));
        }
        keys = this.getServletConfig().getInitParameterNames();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            props.put(key, this.getServletConfig().getInitParameter(key));
        }
        return props;
    }

    private String substVars(String val) {
        if (val.contains("${")) {
            return SlingServlet.substVars((String)val, null, null, (Map)this.properties);
        }
        return val;
    }

    private static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf("}");
        int startDelim = val.indexOf("${");
        while (stopDelim >= 0 && (idx = val.indexOf("${", startDelim + "${".length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + "${".length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.get(variable) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + "}".length(), val.length());
        val = SlingServlet.substVars((String)val, (String)currentKey, cycleMap, configProps);
        return val;
    }

    static /* synthetic */ void access$000(SlingServlet x0) {
        x0.startSling();
    }
}

