/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.webapp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.framework.Logger;
import org.apache.felix.http.proxy.ProxyServlet;
import org.apache.sling.launchpad.base.impl.ClassLoaderResourceProvider;
import org.apache.sling.launchpad.base.impl.Sling;
import org.apache.sling.launchpad.base.shared.Launcher;
import org.apache.sling.launchpad.base.shared.Notifiable;
import org.apache.sling.launchpad.base.webapp.SlingBridge;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingServletDelegate
extends GenericServlet
implements Launcher {
    private static final long serialVersionUID = 1L;
    private static final String[] logLevels = new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG"};
    private static final String PROP_LOG_LEVEL = "org.apache.sling.commons.log.level";
    private static final String OBR_REPOSITORY_URL = "obr.repository.url";
    private boolean servletDestroyed = false;
    private SlingBridge sling;
    private Servlet delegatee;
    private Notifiable notifiable;
    private Map<String, String> properties;
    private String slingHome;

    public void setNotifiable(Notifiable notifiable) {
        this.notifiable = notifiable;
    }

    public void setCommandLine(Map<String, String> args) {
        this.properties = args;
    }

    public void setSlingHome(String slingHome) {
        this.slingHome = slingHome;
    }

    public boolean start() {
        return false;
    }

    public void stop() {
        this.destroy();
    }

    public final void init() throws ServletException {
        Sling tmpSling = null;
        ProxyServlet tmpDelegatee = null;
        try {
            this.log("Starting Apache Sling in " + this.slingHome);
            Map<String, String> props = this.loadConfigProperties(this.slingHome);
            ServletContextLogger logger = new ServletContextLogger(this.getServletContext());
            ServletContextResourceProvider rp = new ServletContextResourceProvider(this.getServletContext());
            tmpSling = new SlingBridge(this.notifiable, logger, rp, props, this.getServletContext());
            tmpDelegatee = new ProxyServlet();
            tmpDelegatee.init(this.getServletConfig());
            if (this.servletDestroyed) {
                this.log("SlingServletDelegate destroyed while starting Apache Sling, shutting Apache Sling down");
            } else {
                this.sling = tmpSling;
                this.delegatee = tmpDelegatee;
                tmpSling = null;
                tmpDelegatee = null;
                this.log("Apache Sling successfully started in " + this.slingHome);
            }
        }
        catch (BundleException be) {
            throw new ServletException("Failed to start Apache Sling in " + this.slingHome, (Throwable)be);
        }
        catch (ServletException se) {
            throw new ServletException("Failed to start bridge servlet for Apache Sling", (Throwable)se);
        }
        catch (Throwable t) {
            throw new ServletException("Uncaught Failure starting Apache Sling", t);
        }
        finally {
            if (tmpDelegatee != null) {
                tmpDelegatee.destroy();
            }
            if (tmpSling != null) {
                tmpSling.destroy();
            }
        }
    }

    public final void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        Servlet delegatee = this.getDelegatee();
        if (delegatee == null) {
            ((HttpServletResponse)res).sendError(404);
        } else {
            delegatee.service(req, res);
        }
    }

    public final void destroy() {
        this.servletDestroyed = true;
        if (this.delegatee != null) {
            this.delegatee.destroy();
            this.delegatee = null;
        }
        if (this.sling != null) {
            this.sling.destroy();
            this.sling = null;
        }
        super.destroy();
    }

    Servlet getDelegatee() {
        return this.delegatee;
    }

    private Map<String, String> loadConfigProperties(String slingHome) {
        URL url;
        HashMap<String, String> props = new HashMap<String, String>();
        String servletVersion = this.getServletContext().getMajorVersion() + "." + this.getServletContext().getMinorVersion();
        props.put("org.apache.sling.launcher.system.packages", ",javax.servlet;javax.servlet.http;javax.servlet.resources; version=" + servletVersion);
        props.put("sling.ignoreSystemProperties", "true");
        if (this.properties != null) {
            props.putAll(this.properties);
        } else {
            Enumeration cpe = this.getServletContext().getInitParameterNames();
            while (cpe.hasMoreElements()) {
                String name = (String)cpe.nextElement();
                props.put(name, this.getServletContext().getInitParameter(name));
            }
            Enumeration pe = this.getInitParameterNames();
            while (pe.hasMoreElements()) {
                String name = (String)pe.nextElement();
                props.put(name, this.getInitParameter(name));
            }
        }
        this.checkLogSettings(props);
        String repoLocation = (String)props.get(OBR_REPOSITORY_URL);
        if (this.insideWebapp(repoLocation) && (url = this.getUrl(repoLocation)) != null) {
            props.put(OBR_REPOSITORY_URL, url.toExternalForm());
        }
        props.put("sling.home", slingHome);
        if (!props.containsKey("sling.launchpad")) {
            props.put("sling.launchpad", slingHome);
        }
        return props;
    }

    private void checkLogSettings(Map<String, String> props) {
        String logLevelString = props.get(PROP_LOG_LEVEL);
        if (logLevelString != null) {
            int logLevel = 1;
            try {
                logLevel = Integer.parseInt(logLevelString);
            }
            catch (NumberFormatException nfe) {
                for (int i = 0; i < logLevels.length; ++i) {
                    if (!logLevels[i].equalsIgnoreCase(logLevelString)) continue;
                    logLevel = i;
                    break;
                }
            }
            props.put("felix.log.level", String.valueOf(logLevel));
        }
    }

    private boolean insideWebapp(String path) {
        return path != null && path.indexOf(":/") < 1 && path.startsWith("/");
    }

    private URL getUrl(String path) {
        try {
            return this.getServletContext().getResource(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServletContextResourceProvider
    extends ClassLoaderResourceProvider {
        private static final String WEB_INF = "/WEB-INF";
        private ServletContext servletContext;

        private ServletContextResourceProvider(ServletContext servletContext) {
            super(SlingServletDelegate.class.getClassLoader());
            this.servletContext = servletContext;
        }

        @Override
        public Iterator<String> getChildren(String path) {
            Set resources;
            if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            if ((resources = this.servletContext.getResourcePaths(path)) == null || resources.isEmpty()) {
                resources = this.servletContext.getResourcePaths(WEB_INF + path);
            }
            if (resources == null || resources.isEmpty()) {
                Iterator<String> resourceIterator = super.getChildren(path);
                if (resourceIterator.hasNext()) {
                    return resourceIterator;
                }
                resourceIterator = super.getChildren(WEB_INF + path);
                if (resourceIterator.hasNext()) {
                    return resourceIterator;
                }
            }
            if (resources == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            return resources.iterator();
        }

        @Override
        public URL getResource(String path) {
            if (path == null || path.length() == 0) {
                return null;
            }
            if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            try {
                URL resource = this.servletContext.getResource(path);
                if (resource != null) {
                    return resource;
                }
                resource = this.servletContext.getResource(WEB_INF + path);
                if (resource != null) {
                    return resource;
                }
                resource = super.getResource(path);
                if (resource != null) {
                    return resource;
                }
                resource = super.getResource(WEB_INF + path);
                if (resource != null) {
                    return resource;
                }
            }
            catch (MalformedURLException mue) {
                this.servletContext.log("Failure to get resource " + path, (Throwable)mue);
            }
            return null;
        }
    }

    private static class ServletContextLogger
    extends Logger {
        private ServletContext servletContext;

        private ServletContextLogger(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        protected void doLog(Bundle bundle, ServiceReference sr, int level, String msg, Throwable throwable) {
            if (throwable instanceof BundleException && ((BundleException)throwable).getNestedException() != null) {
                throwable = ((BundleException)throwable).getNestedException();
            }
            String s = sr == null ? null : "SvcRef " + sr;
            s = s == null ? null : s + " Bundle '" + bundle.getBundleId() + "'";
            s = s == null ? msg : s + " " + msg;
            s = throwable == null ? s : s + " (" + throwable + ")";
            switch (level) {
                case 4: {
                    this.servletContext.log("DEBUG: " + s);
                    break;
                }
                case 1: {
                    if (throwable == null) {
                        this.servletContext.log("ERROR: " + s);
                        break;
                    }
                    this.servletContext.log("ERROR: " + s, throwable);
                    break;
                }
                case 3: {
                    this.servletContext.log("INFO: " + s);
                    break;
                }
                case 2: {
                    this.servletContext.log("WARNING: " + s);
                    break;
                }
                default: {
                    this.servletContext.log("UNKNOWN[" + level + "]: " + s);
                }
            }
        }
    }
}

