/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.net.ContentHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.felix.framework.ServiceRegistrationImpl;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClassListener;
import org.osgi.service.url.URLStreamHandlerService;

public class HookRegistry {
    private static final Map<String, Class<?>> HOOK_CLASSES = new HashMap();
    private final Map<String, Set<ServiceReference<?>>> m_allHooks = new HashMap();
    private final WeakHashMap<ServiceReference<?>, ServiceReference<?>> m_blackList = new WeakHashMap();

    private static void addHookClass(Class<?> c) {
        HOOK_CLASSES.put(c.getName(), c);
    }

    static boolean isHook(String[] classNames, Class<?> hookClass, Object svcObj) {
        for (String serviceName : classNames) {
            if (!serviceName.equals(hookClass.getName())) continue;
            if (svcObj instanceof ServiceFactory) {
                return true;
            }
            if (!hookClass.isAssignableFrom(svcObj.getClass())) continue;
            return true;
        }
        return false;
    }

    private boolean isHook(String serviceName, Object svcObj) {
        Class<?> hookClass = HOOK_CLASSES.get(serviceName);
        if (hookClass != null) {
            if (svcObj instanceof ServiceFactory) {
                return true;
            }
            if (hookClass.isAssignableFrom(svcObj.getClass())) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHooks(String[] classNames, Object svcObj, ServiceReference<?> ref) {
        for (String serviceName : classNames) {
            if (!this.isHook(serviceName, svcObj)) continue;
            Map<String, Set<ServiceReference<?>>> map = this.m_allHooks;
            synchronized (map) {
                Set<ServiceReference<?>> hooks = this.m_allHooks.get(serviceName);
                if (hooks == null) {
                    hooks = new TreeSet(Collections.reverseOrder());
                    this.m_allHooks.put(serviceName, hooks);
                }
                hooks.add(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHooks(ServiceReference<?> ref) {
        String[] classNames;
        Object svcObj = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration().getService();
        for (String serviceName : classNames = (String[])ref.getProperty("objectClass")) {
            if (!this.isHook(serviceName, svcObj)) continue;
            Map<String, Set<ServiceReference<?>>> map = this.m_allHooks;
            synchronized (map) {
                Set<ServiceReference<?>> hooks = this.m_allHooks.get(serviceName);
                if (hooks != null) {
                    ArrayList refs = new ArrayList(hooks);
                    hooks.clear();
                    hooks.addAll(refs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHooks(ServiceReference<?> ref) {
        String[] classNames;
        Object svcObj = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration().getService();
        for (String serviceName : classNames = (String[])ref.getProperty("objectClass")) {
            if (!this.isHook(serviceName, svcObj)) continue;
            Map<String, Set<ServiceReference<?>>> map = this.m_allHooks;
            synchronized (map) {
                Set<ServiceReference<?>> hooks = this.m_allHooks.get(serviceName);
                if (hooks != null) {
                    hooks.remove(ref);
                    if (hooks.isEmpty()) {
                        this.m_allHooks.remove(serviceName);
                    }
                }
            }
        }
        this.m_blackList.remove(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> Set<ServiceReference<S>> getHooks(Class<S> hookClass) {
        Map<String, Set<ServiceReference<?>>> map = this.m_allHooks;
        synchronized (map) {
            Set<ServiceReference<?>> hooks = this.m_allHooks.get(hookClass.getName());
            if (hooks != null) {
                TreeSet<ServiceReference<S>> sorted = new TreeSet<ServiceReference<S>>(Collections.reverseOrder());
                sorted.addAll(hooks);
                return sorted;
            }
            return Collections.emptySet();
        }
    }

    public boolean isHookBlackListed(ServiceReference<?> sr) {
        return this.m_blackList.containsKey(sr);
    }

    public void blackListHook(ServiceReference<?> sr) {
        this.m_blackList.put(sr, sr);
    }

    static {
        HookRegistry.addHookClass(CollisionHook.class);
        HookRegistry.addHookClass(org.osgi.framework.hooks.bundle.FindHook.class);
        HookRegistry.addHookClass(org.osgi.framework.hooks.bundle.EventHook.class);
        HookRegistry.addHookClass(EventHook.class);
        HookRegistry.addHookClass(EventListenerHook.class);
        HookRegistry.addHookClass(FindHook.class);
        HookRegistry.addHookClass(ListenerHook.class);
        HookRegistry.addHookClass(WeavingHook.class);
        HookRegistry.addHookClass(WovenClassListener.class);
        HookRegistry.addHookClass(ResolverHookFactory.class);
        HookRegistry.addHookClass(URLStreamHandlerService.class);
        HookRegistry.addHookClass(ContentHandler.class);
    }
}

