/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl.bootstrapcommands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.framework.Logger;
import org.apache.sling.launchpad.base.impl.bootstrapcommands.Command;
import org.apache.sling.launchpad.base.impl.bootstrapcommands.UninstallBundleCommand;
import org.osgi.framework.BundleContext;

public class BootstrapCommandFile {
    public static final String DATA_FILENAME = BootstrapCommandFile.class.getSimpleName() + "_timestamp.txt";
    public static final String COMMENT_PREFIX = "#";
    private final File commandFile;
    private final Logger logger;
    private static final List<Command> commandPrototypes = new ArrayList<Command>();

    public BootstrapCommandFile(Logger logger, File cmdFile) {
        this.logger = logger;
        this.commandFile = cmdFile;
    }

    boolean anythingToExecute(BundleContext ctx) {
        boolean result = false;
        if (this.commandFile != null && this.commandFile.exists() && this.commandFile.canRead()) {
            long cmdTs = this.commandFile.lastModified();
            long lastExecution = 0L;
            try {
                lastExecution = this.loadTimestamp(ctx);
            }
            catch (IOException ioe) {
                this.logger.log(3, "IOException reading timestamp", ioe);
            }
            if (cmdTs > lastExecution) {
                this.logger.log(3, "Command file timestamp > stored timestamp, need to execute commands (" + this.commandFile.getAbsolutePath() + ")");
                result = true;
            }
        }
        if (!result) {
            this.logger.log(3, "Command file absent or older than last execution timestamp, nothing to execute (" + this.commandFile.getAbsolutePath() + ")");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(BundleContext ctx) throws IOException {
        boolean needsRestart = false;
        if (this.anythingToExecute(ctx)) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.commandFile);
                List<Command> cmds = this.parse(is);
                for (Command cmd : cmds) {
                    try {
                        this.logger.log(4, "Executing command: " + cmd);
                        needsRestart |= cmd.execute(this.logger, ctx);
                    }
                    catch (Exception e) {
                        this.logger.log(2, "Exception in command execution (" + cmd + ") :" + e);
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ignore) {}
                }
            }
            try {
                this.storeTimestamp(ctx);
            }
            catch (IOException ioe) {
                this.logger.log(2, "IOException while storing timestamp", ioe);
            }
        }
        return needsRestart;
    }

    List<Command> parse(InputStream is) throws IOException {
        ArrayList<Command> result = new ArrayList<Command>();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = r.readLine()) != null) {
            Command proto;
            if ((line = line.trim()).length() <= 0 || line.startsWith(COMMENT_PREFIX)) continue;
            Command toAdd = null;
            Iterator<Command> i$ = commandPrototypes.iterator();
            while (i$.hasNext() && (toAdd = (proto = i$.next()).parse(line)) == null) {
            }
            if (toAdd == null) {
                throw new Command.ParseException("Invalid command '" + line + "'");
            }
            result.add(toAdd);
        }
        return result;
    }

    private File getTimestampFile(BundleContext ctx) {
        return ctx.getDataFile(DATA_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadTimestamp(BundleContext ctx) throws IOException {
        long result = 0L;
        File f = this.getTimestampFile(ctx);
        if (f.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                byte[] bytes = new byte[20];
                int len = fis.read(bytes);
                if (len > 0) {
                    result = Long.parseLong(new String(bytes, 0, len));
                }
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTimestamp(BundleContext ctx) throws IOException {
        File f = this.getTimestampFile(ctx);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            fos.write(String.valueOf(System.currentTimeMillis()).getBytes());
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    static {
        commandPrototypes.add(new UninstallBundleCommand());
    }
}

