/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.framework.Logger;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.apache.sling.launchpad.base.impl.BootstrapInstaller;
import org.apache.sling.launchpad.base.impl.ContextProtocolHandler;
import org.apache.sling.launchpad.base.impl.DefaultStartupHandler;
import org.apache.sling.launchpad.base.impl.SlingFelix;
import org.apache.sling.launchpad.base.impl.StartupManager;
import org.apache.sling.launchpad.base.shared.Notifiable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.service.url.URLStreamHandlerService;

public class Sling {
    public static final String SLING_HOME_URL = "sling.home.url";
    public static final String JCR_REPO_HOME = "sling.repository.home";
    public static final String JCR_REPO_CONFIG_FILE_URL = "sling.repository.config.file.url";
    public static final String OSGI_FRAMEWORK_BUNDLES = "org.apache.osgi.bundles";
    public static final String SLING_IGNORE_SYSTEM_PROPERTIES = "sling.ignoreSystemProperties";
    public static final String CONFIG_PROPERTIES = "sling.properties";
    public static final String PROP_SYSTEM_PACKAGES = "org.apache.sling.launcher.system.packages";
    public static final String PROP_EXTRA_CAPS = "org.apache.sling.launcher.system.capabilities.extra";
    private static final long REINIT_TIMEOUT = 1000L;
    protected final Logger logger;
    private LaunchpadContentProvider resourceProvider;
    private Framework framework;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public Sling(Notifiable notifiable, Logger logger, LaunchpadContentProvider resourceProvider, Map<String, String> propOverwrite) throws BundleException {
        this.logger = logger;
        this.resourceProvider = resourceProvider;
        long startedAt = System.currentTimeMillis();
        this.logger.log(3, "Starting Apache Sling");
        Map<String, String> props = this.loadConfigProperties(propOverwrite);
        this.copyBootstrapCommandFile(props);
        try {
            StartupManager startupManager = new StartupManager(props, logger);
            Framework tmpFramework = this.createFramework(notifiable, logger, props);
            this.init(tmpFramework);
            boolean restart = new BootstrapInstaller(tmpFramework.getBundleContext(), logger, resourceProvider, startupManager.getMode()).install();
            startupManager.markInstalled();
            if (restart) {
                this.restart(tmpFramework);
                tmpFramework = this.createFramework(notifiable, logger, props);
                this.init(tmpFramework);
            }
            new DefaultStartupHandler(tmpFramework.getBundleContext(), logger, startupManager, startedAt);
            tmpFramework.start();
            this.framework = tmpFramework;
        }
        catch (BundleException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BundleException("Uncaught Instantiation Issue: " + e, e);
        }
        this.logger.log(3, "Apache Sling started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (this.framework != null) {
            Framework myFramework;
            Sling sling = this;
            synchronized (sling) {
                myFramework = this.framework;
                this.framework = null;
            }
            if (myFramework != null) {
                this.logger.log(3, "Shutting down Apache Sling");
                try {
                    myFramework.stop();
                    myFramework.waitForStop(0L);
                }
                catch (BundleException be) {
                    this.logger.log(1, "Failure initiating Framework Shutdown", be);
                }
                catch (InterruptedException ie) {
                    this.logger.log(1, "Interrupted while waiting for the Framework Termination", ie);
                }
                this.logger.log(3, "Apache Sling stopped");
            }
        }
    }

    private final void startup(BundleContext bundleContext) {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        props.put("url.handler.protocol", new String[]{"context"});
        ContextProtocolHandler contextHandler = new ContextProtocolHandler(this.resourceProvider);
        bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)contextHandler, props);
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
        try {
            ObjectName beanName = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
            AttributeList attrs = platformMBeanServer.getAttributes(beanName, new String[]{"MBeanServerId", "SpecificationName", "SpecificationVersion", "SpecificationVendor", "ImplementationName", "ImplementationVersion", "ImplementationVendor"});
            for (Object object : attrs) {
                Attribute attr = (Attribute)object;
                if (attr.getValue() == null) continue;
                mbeanProps.put(attr.getName(), attr.getValue().toString());
            }
        }
        catch (Exception je) {
            this.logger.log(3, "start: Cannot set service properties of Platform MBeanServer service, registering without", je);
        }
        bundleContext.registerService(MBeanServer.class.getName(), (Object)platformMBeanServer, mbeanProps);
        bundleContext.registerService(LaunchpadContentProvider.class.getName(), (Object)this.resourceProvider, null);
    }

    private Framework createFramework(Notifiable notifiable, Logger logger, Map props) throws Exception {
        props.put("felix.log.logger", logger);
        return new SlingFelix(notifiable, props);
    }

    private void init(Framework framework) throws BundleException {
        framework.init();
        this.startup(framework.getBundleContext());
    }

    private void restart(Framework framework) throws BundleException {
        if ((framework.getState() & 0x38) != 0) {
            if (framework instanceof SlingFelix) {
                ((SlingFelix)framework).restart();
            } else {
                framework.stop();
            }
            try {
                framework.waitForStop(1000L);
            }
            catch (InterruptedException ie) {
                throw new BundleException("Interrupted while waiting for the framework stop before reinitialization");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadConfigProperties(Map<String, String> propOverwrite) throws BundleException {
        String slingHome;
        HashMap<String, String> staticProps = new HashMap<String, String>();
        this.load(staticProps, CONFIG_PROPERTIES);
        this.loadIncludes(staticProps, null);
        if (propOverwrite != null) {
            staticProps.putAll(propOverwrite);
        }
        if ((slingHome = (String)staticProps.get("sling.home")) == null || slingHome.length() == 0) {
            throw new BundleException("sling.home property is missing, cannot start");
        }
        slingHome = Sling.substVars(slingHome, "sling.home", null, staticProps);
        File slingHomeFile = new File(slingHome).getAbsoluteFile();
        slingHome = slingHomeFile.getAbsolutePath();
        this.logger.log(3, "Starting Apache Sling in " + slingHome);
        File propFile = this.getSlingProperties(slingHome, staticProps);
        this.load(staticProps, propFile);
        this.migrateProp(staticProps, "framework.cache.profiledir", "org.osgi.framework.storage");
        this.migrateProp(staticProps, "sling.osgi-core-packages", "osgi-core-packages");
        this.migrateProp(staticProps, "sling.osgi-compendium-services", "osgi-compendium-services");
        this.migrateProp(staticProps, "org.osgi.framework.startlevel", "org.osgi.framework.startlevel.beginning");
        this.migrateProp(staticProps, "framework.startlevel.framework", "org.osgi.framework.startlevel.beginning");
        HashMap<String, String> runtimeProps = new HashMap<String, String>();
        runtimeProps.putAll(staticProps);
        String ignoreSystemProperties = (String)runtimeProps.get(SLING_IGNORE_SYSTEM_PROPERTIES);
        if (!"true".equalsIgnoreCase(ignoreSystemProperties)) {
            for (String string : runtimeProps.keySet()) {
                String sysProp = System.getProperty(string);
                if (sysProp == null) continue;
                runtimeProps.put(string, sysProp);
            }
        }
        this.loadIncludes(runtimeProps, slingHome);
        this.loadPropertiesOverride(runtimeProps);
        this.resolve(runtimeProps, "org.osgi.framework.bootdelegation", "sling.bootdelegation.");
        this.resolve(runtimeProps, "org.osgi.framework.system.packages", "sling.system.packages.");
        staticProps.put("sling.home", slingHome);
        runtimeProps.put("sling.home", slingHome);
        runtimeProps.put(SLING_HOME_URL, slingHomeFile.toURI().toString());
        runtimeProps.put(CONFIG_PROPERTIES, propFile.getAbsolutePath());
        runtimeProps.put("sling.properties.url", propFile.toURI().toString());
        for (Map.Entry entry : runtimeProps.entrySet()) {
            entry.setValue(Sling.substVars((String)entry.getValue(), (String)entry.getKey(), null, runtimeProps));
        }
        for (Map.Entry entry : runtimeProps.entrySet()) {
            String path;
            InputStream src;
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null || !value.startsWith("context:/") || (src = this.resourceProvider.getResourceAsStream(path = value.substring("context:/".length() - 1))) == null) continue;
            File target = new File(slingHome, path);
            OutputStream dest = null;
            try {
                if (!target.exists()) {
                    int rd;
                    target.getParentFile().mkdirs();
                    dest = new FileOutputStream(target);
                    byte[] buf = new byte[2048];
                    while ((rd = src.read(buf)) >= 0) {
                        dest.write(buf, 0, rd);
                    }
                }
                entry.setValue(target.getAbsolutePath());
                staticProps.put(name, "${sling.home}" + path);
            }
            catch (IOException ioe) {
                this.logger.log(1, "Cannot copy file " + value + " to " + target, ioe);
            }
            finally {
                if (dest != null) {
                    try {
                        dest.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    src.close();
                }
                catch (IOException iOException) {}
            }
        }
        OutputStream os = null;
        try {
            propFile.getParentFile().mkdirs();
            os = new FileOutputStream(propFile);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)staticProps);
            properties.remove("sling.home");
            properties.remove("sling.launchpad");
            properties.remove(CONFIG_PROPERTIES);
            properties.store(os, "Overlay properties for configuration");
        }
        catch (Exception exception) {
            this.logger.log(1, "Error loading overlay properties from " + propFile, exception);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return runtimeProps;
    }

    private void resolve(Map<String, String> props, String osgiProp, String prefix) {
        String propVal = props.get(osgiProp);
        StringBuffer prop = new StringBuffer(propVal == null ? "" : propVal);
        boolean mod = false;
        for (Map.Entry<String, String> pEntry : props.entrySet()) {
            String key = pEntry.getKey();
            if (!key.startsWith(prefix)) continue;
            if (key.indexOf("class.") == prefix.length()) {
                String className = key.substring(prefix.length() + "class.".length());
                try {
                    this.getClass().getClassLoader().loadClass(className);
                }
                catch (Throwable t) {
                    this.logger.log(4, "Class " + className + " not found. Ignoring '" + pEntry.getValue() + "' for property " + osgiProp);
                    continue;
                }
            }
            this.logger.log(4, "Adding '" + pEntry.getValue() + "' to property " + osgiProp);
            if (prop.length() > 0) {
                prop.append(',');
            }
            prop.append(pEntry.getValue());
            mod = true;
        }
        if (mod) {
            this.logger.log(4, "Setting property " + osgiProp + " to " + prop.toString());
            props.put(osgiProp, prop.toString());
        }
    }

    private void migrateProp(Map<String, String> props, String oldName, String newName) {
        String propValue = props.remove(oldName);
        if (propValue != null) {
            String previousNewValue = props.put(newName, propValue);
            if (previousNewValue != null) {
                this.logger.log(2, "Old value (" + previousNewValue + ") of property " + newName + " by value: " + propValue);
            } else {
                this.logger.log(3, "Property " + oldName + " (" + propValue + ") renamed to " + newName);
            }
        } else {
            this.logger.log(4, "Property " + oldName + " does not exist, nothing to do");
        }
    }

    protected void loadPropertiesOverride(Map<String, String> properties) {
    }

    public final BundleContext getBundleContext() {
        return this.framework.getBundleContext();
    }

    private File getSlingProperties(String slingHome, Map<String, String> properties) {
        String prop = properties.get(CONFIG_PROPERTIES);
        if (prop == null) {
            return new File(slingHome, CONFIG_PROPERTIES);
        }
        File propFile = new File(prop);
        return propFile.isAbsolute() ? propFile : new File(slingHome, prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIncludes(Map<String, String> props, String slingHome) {
        TreeMap<String, String> includes = new TreeMap<String, String>();
        Iterator<Map.Entry<String, String>> pi = props.entrySet().iterator();
        while (pi.hasNext()) {
            Map.Entry<String, String> entry = pi.next();
            if (!entry.getKey().startsWith("sling.include.") && !entry.getKey().equals("sling.include")) continue;
            includes.put(entry.getKey(), entry.getValue());
            pi.remove();
        }
        for (Map.Entry entry : includes.entrySet()) {
            String key = (String)entry.getKey();
            String include = (String)entry.getValue();
            include = Sling.substVars(include, key, null, props);
            StringTokenizer tokener = new StringTokenizer(include, ",");
            while (tokener.hasMoreTokens()) {
                String file = tokener.nextToken().trim();
                InputStream is = this.resourceProvider.getResourceAsStream(file);
                try {
                    if (is == null && slingHome != null) {
                        File resFile = new File(file);
                        if (!resFile.isAbsolute()) {
                            resFile = new File(slingHome, file);
                        }
                        if (resFile.canRead()) {
                            is = new FileInputStream(resFile);
                            file = resFile.getAbsolutePath();
                        }
                    }
                    if (is == null) continue;
                    this.load(props, is);
                }
                catch (IOException ioe) {
                    this.logger.log(1, "Error loading config properties from " + file, ioe);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Map<String, String> props, String resource) {
        InputStream is = this.resourceProvider.getResourceAsStream(resource);
        if (is != null) {
            try {
                this.load(props, is);
            }
            catch (IOException ioe) {
                this.logger.log(1, "Error loading config properties from " + resource, ioe);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void load(Map<String, String> props, File file) {
        if (file != null && file.canRead()) {
            try {
                this.load(props, new FileInputStream(file));
            }
            catch (IOException ioe) {
                this.logger.log(1, "Error loading config properties from " + file.getAbsolutePath(), ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Map<String, String> props, InputStream ins) throws IOException {
        try {
            Properties tmp = new Properties();
            tmp.load(ins);
            for (Map.Entry<Object, Object> entry : tmp.entrySet()) {
                String value = (String)entry.getValue();
                props.put((String)entry.getKey(), value == null ? null : value.trim());
            }
        }
        finally {
            try {
                ins.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.get(variable) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = Sling.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyBootstrapCommandFile(Map<String, String> props) {
        URL url = this.resourceProvider.getResource("sling_bootstrap.txt");
        if (url != null) {
            this.logger.log(4, "Checking last modification date of bootstrap command file.");
            InputStream is = null;
            OutputStream os = null;
            try {
                int l;
                long lastModified = url.openConnection().getLastModified();
                File launchpadHome = new File(props.get("sling.launchpad"));
                File cmdFile = new File(launchpadHome, "sling_bootstrap.txt");
                boolean copyFile = true;
                if (cmdFile.exists() && cmdFile.lastModified() >= lastModified) {
                    copyFile = false;
                }
                if (!copyFile) return;
                this.logger.log(3, "Copying bootstrap command file.");
                is = this.resourceProvider.getResourceAsStream("sling_bootstrap.txt");
                os = new FileOutputStream(cmdFile);
                byte[] buffer = new byte[2048];
                while ((l = is.read(buffer, 0, buffer.length)) != -1) {
                    os.write(buffer, 0, l);
                }
                return;
            }
            catch (IOException ioe) {
                this.logger.log(3, "Ignoring exception during processing of bootstrap command file.", ioe);
                return;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.logger.log(4, "Bootstrap command file not found.");
    }
}

