/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.Util;
import org.apache.sling.launchpad.base.shared.Loader;
import org.apache.sling.launchpad.base.shared.Notifiable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class SlingFelix
extends Felix {
    private final Notifiable notifiable;
    private Thread notifierThread;
    private Method getBundleMethod;

    public SlingFelix(Notifiable notifiable, Map props) throws Exception {
        super(SlingFelix.getPropsAndDefaultProps(props));
        this.notifiable = notifiable;
    }

    private static Map getPropsAndDefaultProps(Map props) {
        Logger logger = (Logger)props.get("felix.log.logger");
        if (logger != null) {
            Properties fullProps = new Properties();
            Properties defaultProps = Util.loadDefaultProperties(logger);
            fullProps.putAll((Map<?, ?>)defaultProps);
            fullProps.putAll((Map<?, ?>)props);
            for (Object name : defaultProps.keySet()) {
                if (props.containsKey(name)) continue;
                String value = (String)fullProps.get(name);
                String substValue = Util.substVars(value, name.toString(), null, fullProps);
                fullProps.put(name, substValue);
            }
            return fullProps;
        }
        return props;
    }

    @Override
    public void update() throws BundleException {
        this.update(null);
    }

    @Override
    public void update(InputStream is) throws BundleException {
        try {
            this.startNotifier(true, is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        super.stop();
    }

    public void restart() throws BundleException {
        super.stop();
    }

    @Override
    public void stop() throws BundleException {
        this.startNotifier(false, null);
        super.stop();
    }

    @Override
    public void stop(int status) throws BundleException {
        this.startNotifier(false, null);
        super.stop(status);
    }

    private synchronized void startNotifier(boolean restart, InputStream ins) {
        if (this.notifierThread == null) {
            this.notifierThread = new Thread((Runnable)new Notifier(restart, ins), "Sling Notifier");
            this.notifierThread.setDaemon(false);
            this.notifierThread.start();
        }
    }

    public Bundle getBundle(Class<?> clazz) {
        block7: {
            Method getBundleMethod = this.getBundleMethod;
            if (getBundleMethod == null) {
                Class<Felix> provider = Felix.class;
                try {
                    getBundleMethod = provider.getDeclaredMethod("getBundle", Class.class);
                    getBundleMethod.setAccessible(true);
                    this.getBundleMethod = getBundleMethod;
                }
                catch (Exception e) {
                    throw new NoSuchMethodError("getBundle");
                }
            }
            try {
                return (Bundle)getBundleMethod.invoke((Object)this, clazz);
            }
            catch (IllegalArgumentException provider) {
            }
            catch (IllegalAccessException provider) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (!(t instanceof RuntimeException)) break block7;
                throw (RuntimeException)t;
            }
        }
        return null;
    }

    private class Notifier
    implements Runnable {
        private final boolean restart;
        private final File updateFile;

        private Notifier(boolean restart, InputStream ins) {
            this.restart = restart;
            if (ins != null) {
                File tmpFile;
                try {
                    tmpFile = File.createTempFile("slingupdate", ".jar");
                    Loader.spool((InputStream)ins, (File)tmpFile);
                }
                catch (IOException ioe) {
                    tmpFile = null;
                }
                this.updateFile = tmpFile;
            } else {
                this.updateFile = null;
            }
        }

        @Override
        public void run() {
            try {
                SlingFelix.this.waitForStop(0L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            if (this.restart) {
                SlingFelix.this.notifiable.updated(this.updateFile);
            } else {
                SlingFelix.this.notifiable.stopped();
            }
        }
    }
}

