/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.proxy.impl;

import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.proxy.impl.EventDispatcherTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

@WebListener
public class ProxyServletContextListener
implements ServletContextListener {
    private volatile ServletContext servletContext;
    private volatile EventDispatcherTracker eventDispatcherTracker;

    public void contextInitialized(ServletContextEvent sce) {
        this.servletContext = sce.getServletContext();
        this.servletContext.addListener((EventListener)new HttpSessionListener(){

            private HttpSessionListener getHttpSessionListener() {
                EventDispatcherTracker tracker = ProxyServletContextListener.this.eventDispatcherTracker;
                if (tracker != null) {
                    return tracker.getHttpSessionListener();
                }
                return null;
            }

            public void sessionCreated(HttpSessionEvent se) {
                HttpSessionListener sessionDispatcher = this.getHttpSessionListener();
                if (sessionDispatcher != null) {
                    sessionDispatcher.sessionCreated(se);
                }
            }

            public void sessionDestroyed(HttpSessionEvent se) {
                HttpSessionListener sessionDispatcher = this.getHttpSessionListener();
                if (sessionDispatcher != null) {
                    sessionDispatcher.sessionDestroyed(se);
                }
            }
        });
        this.servletContext.addListener((EventListener)new HttpSessionIdListener(){

            private HttpSessionIdListener getHttpSessionIdListener() {
                EventDispatcherTracker tracker = ProxyServletContextListener.this.eventDispatcherTracker;
                if (tracker != null) {
                    return tracker.getHttpSessionIdListener();
                }
                return null;
            }

            public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
                HttpSessionIdListener sessionIdDispatcher = this.getHttpSessionIdListener();
                if (sessionIdDispatcher != null) {
                    sessionIdDispatcher.sessionIdChanged(event, oldSessionId);
                }
            }
        });
        this.servletContext.addListener((EventListener)new HttpSessionAttributeListener(){

            private HttpSessionAttributeListener getHttpSessionAttributeListener() {
                EventDispatcherTracker tracker = ProxyServletContextListener.this.eventDispatcherTracker;
                if (tracker != null) {
                    return tracker.getHttpSessionAttributeListener();
                }
                return null;
            }

            public void attributeAdded(HttpSessionBindingEvent se) {
                HttpSessionAttributeListener attributeDispatcher = this.getHttpSessionAttributeListener();
                if (attributeDispatcher != null) {
                    attributeDispatcher.attributeAdded(se);
                }
            }

            public void attributeRemoved(HttpSessionBindingEvent se) {
                HttpSessionAttributeListener attributeDispatcher = this.getHttpSessionAttributeListener();
                if (attributeDispatcher != null) {
                    attributeDispatcher.attributeRemoved(se);
                }
            }

            public void attributeReplaced(HttpSessionBindingEvent se) {
                HttpSessionAttributeListener attributeDispatcher = this.getHttpSessionAttributeListener();
                if (attributeDispatcher != null) {
                    attributeDispatcher.attributeReplaced(se);
                }
            }
        });
        this.servletContext.addListener((EventListener)new ServletContextAttributeListener(){

            public void attributeAdded(ServletContextAttributeEvent event) {
                if (event.getName().equals(BundleContext.class.getName())) {
                    ProxyServletContextListener.this.startTracker(event.getValue());
                }
            }

            public void attributeRemoved(ServletContextAttributeEvent event) {
                if (event.getName().equals(BundleContext.class.getName())) {
                    ProxyServletContextListener.this.stopTracker();
                }
            }

            public void attributeReplaced(ServletContextAttributeEvent event) {
                if (event.getName().equals(BundleContext.class.getName())) {
                    ProxyServletContextListener.this.stopTracker();
                    ProxyServletContextListener.this.startTracker(event.getServletContext().getAttribute(event.getName()));
                }
            }
        });
    }

    private void startTracker(Object bundleContextAttr) {
        if (bundleContextAttr instanceof BundleContext) {
            try {
                BundleContext bundleContext = (BundleContext)bundleContextAttr;
                this.eventDispatcherTracker = new EventDispatcherTracker(bundleContext);
                this.eventDispatcherTracker.open();
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    private void stopTracker() {
        if (this.eventDispatcherTracker != null) {
            this.eventDispatcherTracker.close();
            this.eventDispatcherTracker = null;
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.stopTracker();
        this.servletContext = null;
    }
}

