/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.installer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchpadConfigInstaller {
    private static final String ROOT_CONFIG_PATH = "resources/config";
    private static final String ROOT_INSTALL_PATH = "resources/install";
    private static final Integer PRIORITY = new Integer(50);

    private static boolean checkPath(LaunchpadContentProvider resourceProvider, Collection<InstallableResource> installables, String rootPath, String resourceType) {
        int count = 0;
        Logger logger = LoggerFactory.getLogger(LaunchpadConfigInstaller.class);
        Iterator configPaths = resourceProvider.getChildren(rootPath);
        if (configPaths != null) {
            int hintPos = rootPath.lastIndexOf(47);
            String hint = rootPath.substring(hintPos + 1);
            while (configPaths.hasNext()) {
                String path = (String)configPaths.next();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (LaunchpadConfigInstaller.checkPath(resourceProvider, installables, path, resourceType)) continue;
                logger.info("Launchpad {} will be installed: {}", (Object)resourceType, (Object)path);
                URL url = resourceProvider.getResource(path);
                Hashtable<String, String> dict = null;
                if ("file".equals(resourceType)) {
                    dict = new Hashtable<String, String>();
                    ((Dictionary)dict).put("installation.hint", hint);
                    try {
                        ((Dictionary)dict).put("resource.uri.hint", url.toURI().toString());
                    }
                    catch (URISyntaxException e) {
                        // empty catch block
                    }
                }
                long lastModified = -1L;
                try {
                    lastModified = url.openConnection().getLastModified();
                }
                catch (IOException e) {
                    // empty catch block
                }
                String digest = lastModified > 0L ? String.valueOf(lastModified) : null;
                InputStream stream = resourceProvider.getResourceAsStream(path);
                installables.add(new InstallableResource(path, stream, dict, digest, resourceType, PRIORITY));
                ++count;
            }
        }
        return count > 0;
    }

    public static void install(OsgiInstaller installer, LaunchpadContentProvider resourceProvider) {
        Logger logger = LoggerFactory.getLogger(LaunchpadConfigInstaller.class);
        logger.info("Activating launchpad config installer, configuration path={}, install path={}", (Object)ROOT_CONFIG_PATH, (Object)ROOT_INSTALL_PATH);
        HashSet<InstallableResource> installables = new HashSet<InstallableResource>();
        LaunchpadConfigInstaller.checkPath(resourceProvider, installables, ROOT_CONFIG_PATH, "properties");
        LaunchpadConfigInstaller.checkPath(resourceProvider, installables, ROOT_INSTALL_PATH, "file");
        InstallableResource[] toInstall = installables.toArray(new InstallableResource[0]);
        installer.registerResources("launchpad", toInstall);
        logger.info("{} resources registered with OsgiInstaller", (Object)toInstall.length);
    }
}

