/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.app;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.apache.sling.launchpad.app.Main;

class ControlListener
implements Runnable {
    static final String COMMAND_STOP = "stop";
    static final String COMMAND_STATUS = "status";
    private static final String RESPONSE_OK = "OK";
    private static final int DEFAULT_LISTEN_PORT = 63000;
    private final Main slingMain;
    private final SocketAddress socketAddress;

    ControlListener(Main slingMain, String listenSpec) {
        this.slingMain = slingMain;
        this.socketAddress = this.getSocketAddress(listenSpec);
    }

    void listen() {
        if (this.socketAddress != null) {
            Thread listener = new Thread((Runnable)this);
            listener.setDaemon(true);
            listener.setName("Sling Control Listener@" + this.socketAddress);
            listener.start();
        } else {
            Main.info((String)"No socket address to listen to", null);
        }
    }

    void shutdownServer() {
        this.sendCommand(COMMAND_STOP);
    }

    void statusServer() {
        this.sendCommand(COMMAND_STATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ServerSocket server = null;
        try {
            server = new ServerSocket();
            server.bind(this.socketAddress);
            Main.info((String)"Sling Control Server started", null);
        }
        catch (IOException ioe) {
            Main.error((String)"Failed to start Sling Control Server", (Throwable)ioe);
            return;
        }
        while (true) {
            try {
                try {
                    Socket s = server.accept();
                    try {
                        String command = this.readLine(s);
                        Main.info((String)(s.getRemoteSocketAddress() + ">" + command), null);
                        if (COMMAND_STOP.equals(command)) {
                            this.slingMain.shutdown();
                            this.writeLine(s, RESPONSE_OK);
                            Main.info((String)"Sling shut down, exiting Java VM", null);
                            System.exit(0);
                            continue;
                        }
                        if (COMMAND_STATUS.equals(command)) {
                            this.writeLine(s, RESPONSE_OK);
                            continue;
                        }
                        this.writeLine(s, "ERR:" + command);
                    }
                    finally {
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException ioe) {
                    Main.error((String)"Failure reading from client", (Throwable)ioe);
                    try {
                        server.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
            }
            catch (Throwable throwable) {
                try {
                    server.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private SocketAddress getSocketAddress(String listenSpec) {
        try {
            if (listenSpec != null) {
                int colon = listenSpec.indexOf(58);
                if (colon < 0) {
                    return new InetSocketAddress(InetAddress.getLocalHost(), Integer.parseInt(listenSpec));
                }
                return new InetSocketAddress(listenSpec.substring(0, colon), Integer.parseInt(listenSpec.substring(colon + 1)));
            }
            return new InetSocketAddress(InetAddress.getLocalHost(), 63000);
        }
        catch (NumberFormatException nfe) {
            Main.error((String)("Cannot parse port number from '" + listenSpec + "'"), null);
        }
        catch (UnknownHostException uhe) {
            Main.error((String)("Unknown host in '" + listenSpec + "': " + uhe.getMessage()), null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(String command) {
        if (this.socketAddress != null) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(this.socketAddress);
                this.writeLine(socket, command);
                String result = this.readLine(socket);
                Main.info((String)("Sent '" + command + "' to " + this.socketAddress + ": " + result), null);
            }
            catch (ConnectException ce) {
                Main.info((String)("No Sling running at " + this.socketAddress), null);
            }
            catch (IOException ioe) {
                Main.error((String)("Failed sending '" + command + "' to " + this.socketAddress), (Throwable)ioe);
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        } else {
            Main.info((String)("No socket address to send '" + command + "' to"), null);
        }
    }

    private String readLine(Socket socket) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        return br.readLine();
    }

    private void writeLine(Socket socket, String line) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
        bw.write(line);
        bw.write("\r\n");
        bw.flush();
    }
}

