/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.app;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.launchpad.app.ControlListener;
import org.apache.sling.launchpad.app.Main;
import org.apache.sling.launchpad.base.shared.Launcher;
import org.apache.sling.launchpad.base.shared.Loader;
import org.apache.sling.launchpad.base.shared.Notifiable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Main
extends Thread
implements Notifiable {
    private static final String ENV_SLING_HOME = "SLING_HOME";
    private final Map<String, String> commandLineArgs;
    private final String slingHome;
    private final Loader loader;
    private Launcher sling;
    private static final DateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS ");

    public static void main(String[] args) {
        new Main(args);
    }

    private Main(String[] args) {
        super("Sling Terminator");
        this.commandLineArgs = Main.parseCommandLine((String[])args);
        this.doHelp();
        this.doControlCommand();
        this.slingHome = Main.getSlingHome((Map)this.commandLineArgs);
        File slingHomeFile = new File(this.slingHome);
        if (slingHomeFile.isAbsolute()) {
            Main.info((String)("Starting Sling in " + this.slingHome), null);
        } else {
            Main.info((String)("Starting Sling in " + this.slingHome + " (" + slingHomeFile.getAbsolutePath() + ")"), null);
        }
        1 loaderTmp = null;
        try {
            loaderTmp = new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (IllegalArgumentException iae) {
            this.startupFailure(iae.getMessage(), null);
        }
        this.loader = loaderTmp;
        Runtime.getRuntime().addShutdownHook((Thread)this);
        this.startSling(this.getClass().getResource("/resources/org.apache.sling.launchpad.base.jar"));
    }

    void shutdown() {
        try {
            Runtime.getRuntime().removeShutdownHook((Thread)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.sling != null) {
            Main.info((String)"Stopping Sling", null);
            this.sling.stop();
        }
    }

    public void stopped() {
        Main.info((String)"Sling has been stopped", null);
        this.sling = null;
        try {
            Runtime.getRuntime().removeShutdownHook((Thread)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(File updateFile) {
        this.sling = null;
        this.loader.cleanupVM();
        if (updateFile == null) {
            Main.info((String)"Restarting Framework and Sling", null);
            this.startSling(null);
        } else {
            Main.info((String)("Restarting Framework with update from " + updateFile), null);
            try {
                this.startSling(updateFile.toURI().toURL());
            }
            catch (MalformedURLException mue) {
                Main.error((String)("Cannot get URL for file " + updateFile), (Throwable)mue);
            }
            finally {
                updateFile.delete();
            }
        }
    }

    @Override
    public void run() {
        Main.info((String)"Java VM is shutting down", null);
        this.shutdown();
    }

    private void startSling(URL launcherJar) {
        if (launcherJar != null) {
            try {
                Main.info((String)("Checking launcher JAR in folder " + this.slingHome), null);
                this.loader.installLauncherJar(launcherJar);
            }
            catch (IOException ioe) {
                this.startupFailure("Failed installing " + launcherJar, (Throwable)ioe);
            }
        } else {
            Main.info((String)"No Launcher JAR to install", null);
        }
        Object object = null;
        try {
            object = this.loader.loadLauncher("org.apache.sling.launchpad.base.app.MainDelegate");
        }
        catch (IllegalArgumentException iae) {
            this.startupFailure("Failed loading Sling class org.apache.sling.launchpad.base.app.MainDelegate", (Throwable)iae);
        }
        if (object instanceof Launcher) {
            Launcher sling = (Launcher)object;
            sling.setNotifiable((Notifiable)this);
            sling.setCommandLine(this.commandLineArgs);
            sling.setSlingHome(this.slingHome);
            Main.info((String)"Starting launcher ...", null);
            if (sling.start()) {
                Main.info((String)"Startup completed", null);
                this.sling = sling;
            } else {
                Main.error((String)"There was a problem launching Sling", null);
            }
        }
    }

    static Map<String, String> parseCommandLine(String[] args) {
        HashMap<String, String> commandLine = new HashMap<String, String>();
        boolean readUnparsed = false;
        for (int argc = 0; args != null && argc < args.length; ++argc) {
            String arg = args[argc];
            if (readUnparsed) {
                commandLine.put(arg, arg);
                continue;
            }
            if (arg.startsWith("-")) {
                if (arg.length() == 1) {
                    readUnparsed = true;
                    continue;
                }
                String key = String.valueOf(arg.charAt(1));
                if (arg.length() > 2) {
                    commandLine.put(key, arg.substring(2));
                    continue;
                }
                if (++argc < args.length && (args[argc].equals("-") || !args[argc].startsWith("-"))) {
                    commandLine.put(key, args[argc]);
                    continue;
                }
                commandLine.put(key, key);
                --argc;
                continue;
            }
            commandLine.put(arg, arg);
        }
        return commandLine;
    }

    private static String getSlingHome(Map<String, String> commandLine) {
        String source = null;
        String slingHome = commandLine.get("c");
        if (slingHome != null) {
            source = "command line";
        } else {
            slingHome = System.getProperty("sling.home");
            if (slingHome != null) {
                source = "system property sling.home";
            } else {
                slingHome = System.getenv("SLING_HOME");
                if (slingHome != null) {
                    source = "environment variable SLING_HOME";
                } else {
                    source = "default";
                    slingHome = "sling";
                }
            }
        }
        Main.info((String)("Setting sling.home=" + slingHome + " (" + source + ")"), null);
        return slingHome;
    }

    private void startupFailure(String message, Throwable cause) {
        Main.error((String)("Launcher JAR access failure: " + message), (Throwable)cause);
        Main.error((String)"Shutting Down", null);
        System.exit(1);
    }

    static void info(String message, Throwable t) {
        Main.log((PrintStream)System.out, (String)"*INFO*", (String)message, (Throwable)t);
    }

    static void error(String message, Throwable t) {
        Main.log((PrintStream)System.err, (String)"*ERROR*", (String)message, (Throwable)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(PrintStream out, String prefix, String message, Throwable t) {
        StringBuilder linePrefixBuilder = new StringBuilder();
        DateFormat dateFormat = fmt;
        synchronized (dateFormat) {
            linePrefixBuilder.append(fmt.format(new Date()));
        }
        linePrefixBuilder.append(prefix);
        linePrefixBuilder.append(" [");
        linePrefixBuilder.append(Thread.currentThread().getName());
        linePrefixBuilder.append("] ");
        String linePrefix = linePrefixBuilder.toString();
        out.print(linePrefix);
        out.println(message);
        if (t != null) {
            t.printStackTrace((PrintStream)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void doHelp() {
        if (this.commandLineArgs.remove("h") != null) {
            System.out.println("usage: " + Main.class.getName() + " [ start | stop | status ] [ -j adr ] [ -l loglevel ] [ -f logfile ] [ -c slinghome ] [ -a address ] [ -p port ] [ -h ]");
            System.out.println("    start         listen for control connection (uses -j)");
            System.out.println("    stop          terminate running Sling (uses -j)");
            System.out.println("    status        check whether Sling is running (uses -j)");
            System.out.println("    -j adr        host and port to use for control connection in the format '[host:]port' (default localhost:63000)");
            System.out.println("    -l loglevel   the initial loglevel (0..4, FATAL, ERROR, WARN, INFO, DEBUG)");
            System.out.println("    -f logfile    the log file, \"-\" for stdout (default logs/error.log)");
            System.out.println("    -c slinghome  the sling context directory (default sling)");
            System.out.println("    -a address    the interfact to bind to (use 0.0.0.0 for any) (not supported yet)");
            System.out.println("    -p port       the port to listen to (default 8080)");
            System.out.println("    -h            prints this usage message");
            System.exit(0);
        }
    }

    private void doControlCommand() {
        String commandSocketSpec = (String)this.commandLineArgs.remove("j");
        if ("j".equals(commandSocketSpec)) {
            commandSocketSpec = null;
        }
        ControlListener sl = new ControlListener(this, commandSocketSpec);
        if (this.commandLineArgs.remove("stop") != null) {
            sl.shutdownServer();
            System.exit(0);
        } else if (this.commandLineArgs.remove("status") != null) {
            sl.statusServer();
            System.exit(0);
        } else if (this.commandLineArgs.remove("start") != null) {
            sl.listen();
        }
    }
}

