/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.annotations.apt;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.apache.sling.models.annotations.Model;

@SupportedAnnotationTypes(value={"javax.inject.Inject", "org.apache.sling.models.annotations.injectorspecific.*"})
public class ValidatingAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (!this.isSlingModel(element)) continue;
                if (this.isStaticOrFinalField(element)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Annotation " + typeElement + " may not be used on static or final fields: " + this.getSymbolName(element), element);
                    continue;
                }
                if (!this.isStaticMethod(element)) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Annotation " + typeElement + " may not be used on static methods: " + this.getSymbolName(element), element);
            }
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private String getSymbolName(Element annotatedElement) {
        String name = annotatedElement.getEnclosingElement().getSimpleName().toString() + "#" + annotatedElement.getSimpleName().toString();
        if (annotatedElement.getKind() == ElementKind.METHOD) {
            name = name + "()";
        }
        return name;
    }

    private boolean isStaticOrFinalField(Element annotatedElement) {
        return (annotatedElement.getModifiers().contains((Object)Modifier.STATIC) || annotatedElement.getModifiers().contains((Object)Modifier.FINAL)) && annotatedElement.getKind() == ElementKind.FIELD;
    }

    private boolean isStaticMethod(Element annotatedElement) {
        return annotatedElement.getModifiers().contains((Object)Modifier.STATIC) && annotatedElement.getKind() == ElementKind.METHOD;
    }

    private boolean isSlingModel(Element annotatedElement) {
        Element enclosingElement = annotatedElement.getEnclosingElement();
        return (enclosingElement.getKind() == ElementKind.CLASS || enclosingElement.getKind() == ElementKind.INTERFACE) && enclosingElement.getAnnotation(Model.class) != null;
    }
}

