/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.sling.models.spi.ImplementationPicker;

final class AdapterImplementations {
    private final ConcurrentMap<String, ConcurrentNavigableMap<String, Class<?>>> adapterImplementations = new ConcurrentHashMap();
    private volatile ImplementationPicker[] sortedImplementationPickers = new ImplementationPicker[0];

    AdapterImplementations() {
    }

    public void setImplementationPickers(Collection<ImplementationPicker> implementationPickers) {
        this.sortedImplementationPickers = implementationPickers.toArray(new ImplementationPicker[implementationPickers.size()]);
    }

    public ImplementationPicker[] getImplementationPickers() {
        return this.sortedImplementationPickers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Class<?> adapterType, Class<?> implType) {
        ConcurrentMap<String, ConcurrentNavigableMap<String, Class<?>>> concurrentMap = this.adapterImplementations;
        synchronized (concurrentMap) {
            String key = adapterType.getName();
            ConcurrentSkipListMap implementations = (ConcurrentSkipListMap)this.adapterImplementations.get(key);
            if (implementations == null) {
                implementations = new ConcurrentSkipListMap();
                this.adapterImplementations.put(key, implementations);
            }
            implementations.put(implType.getName(), implType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String adapterTypeName, String implTypeName) {
        ConcurrentMap<String, ConcurrentNavigableMap<String, Class<?>>> concurrentMap = this.adapterImplementations;
        synchronized (concurrentMap) {
            String key = adapterTypeName;
            ConcurrentNavigableMap implementations = (ConcurrentNavigableMap)this.adapterImplementations.get(key);
            if (implementations != null) {
                implementations.remove(implTypeName);
                if (implementations.isEmpty()) {
                    this.adapterImplementations.remove(key);
                }
            }
        }
    }

    public void removeAll() {
        this.adapterImplementations.clear();
    }

    public Class<?> lookup(Class<?> adapterType, Object adaptable) {
        String key = adapterType.getName();
        ConcurrentNavigableMap implementations = (ConcurrentNavigableMap)this.adapterImplementations.get(key);
        if (implementations == null || implementations.isEmpty()) {
            return null;
        }
        Collection implementationsCollection = implementations.values();
        Class[] implementationsArray = implementationsCollection.toArray(new Class[implementationsCollection.size()]);
        for (ImplementationPicker picker : this.sortedImplementationPickers) {
            Class implementation = picker.pick(adapterType, implementationsArray, adaptable);
            if (implementation == null) continue;
            return implementation;
        }
        return null;
    }
}

