/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;

public class ConstructorParameter
implements AnnotatedElement {
    private final Annotation[] annotations;
    private final Class<?> type;
    private final Type genericType;
    private final int parameterIndex;

    ConstructorParameter(Annotation[] annotations, Class<?> type, Type genericType, int parameterIndex) {
        this.annotations = annotations;
        this.type = type;
        this.genericType = genericType;
        this.parameterIndex = parameterIndex;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> paramClass) {
        return this.getAnnotation(paramClass) != null;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> paramClass) {
        for (Annotation annotation : this.annotations) {
            if (!paramClass.isInstance(annotation)) continue;
            return (T)annotation;
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.annotations;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public String toString() {
        return "Parameter" + this.parameterIndex + "[" + this.genericType.toString() + "]";
    }
}

