/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.Source;
import org.apache.sling.models.annotations.Via;
import org.apache.sling.models.impl.AdapterImplementations;
import org.apache.sling.models.impl.ConstructorParameter;
import org.apache.sling.models.impl.MapBackedInvocationHandler;
import org.apache.sling.models.impl.ModelConfigurationPrinter;
import org.apache.sling.models.impl.ModelPackageBundleListener;
import org.apache.sling.models.impl.ParameterCountInjectComparator;
import org.apache.sling.models.impl.ThreadInvocationCounter;
import org.apache.sling.models.spi.AcceptsNullName;
import org.apache.sling.models.spi.DisposalCallback;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotation;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true)
public class ModelAdapterFactory
implements AdapterFactory,
Runnable {
    private ReferenceQueue<Object> queue;
    private ConcurrentMap<Reference<Object>, DisposalCallbackRegistryImpl> disposalCallbacks;
    private static final Logger log = LoggerFactory.getLogger(ModelAdapterFactory.class);
    private static final int DEFAULT_MAX_RECURSION_DEPTH = 20;
    @Property(label="Maximum Recursion Depth", description="Maximum depth adaptation will be attempted.", intValue={20})
    private static final String PROP_MAX_RECURSION_DEPTH = "max.recursion.depth";
    @org.apache.felix.scr.annotations.Reference(name="injector", referenceInterface=Injector.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final Map<Object, Injector> injectors = new TreeMap<Object, Injector>();
    private volatile Injector[] sortedInjectors = new Injector[0];
    @org.apache.felix.scr.annotations.Reference(name="injectAnnotationProcessorFactory", referenceInterface=InjectAnnotationProcessorFactory.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final Map<Object, InjectAnnotationProcessorFactory> injectAnnotationProcessorFactories = new TreeMap<Object, InjectAnnotationProcessorFactory>();
    private volatile InjectAnnotationProcessorFactory[] sortedInjectAnnotationProcessorFactories = new InjectAnnotationProcessorFactory[0];
    @org.apache.felix.scr.annotations.Reference(name="implementationPicker", referenceInterface=ImplementationPicker.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final Map<Object, ImplementationPicker> implementationPickers = new TreeMap<Object, ImplementationPicker>();
    ModelPackageBundleListener listener;
    final AdapterImplementations adapterImplementations = new AdapterImplementations();
    private ServiceRegistration jobRegistration;
    private ServiceRegistration configPrinterRegistration;
    private ThreadLocal<ThreadInvocationCounter> invocationCountThreadLocal;

    @Override
    public void run() {
        Reference<Object> ref = this.queue.poll();
        while (ref != null) {
            log.debug("calling disposal for {}.", (Object)ref.toString());
            DisposalCallbackRegistryImpl registry = (DisposalCallbackRegistryImpl)this.disposalCallbacks.remove(ref);
            registry.onDisposed();
            ref = this.queue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        ThreadInvocationCounter threadInvocationCounter = this.invocationCountThreadLocal.get();
        if (threadInvocationCounter.isMaximumReached()) {
            log.error("Adapting {} to {} failed, too much recursive invocations (>={}).", new Object[]{adaptable, type, threadInvocationCounter.maxRecursionDepth});
            return null;
        }
        threadInvocationCounter.increase();
        try {
            Object handler;
            Class[] declaredAdaptable;
            Model modelAnnotation;
            Class<?> implementationType = this.adapterImplementations.lookup(type, adaptable);
            if (implementationType != null) {
                type = implementationType;
            }
            if ((modelAnnotation = type.getAnnotation(Model.class)) == null) {
                AdapterType AdapterType = null;
                return AdapterType;
            }
            boolean isAdaptable = false;
            for (Class clazz : declaredAdaptable = modelAnnotation.adaptables()) {
                if (!clazz.isInstance(adaptable)) continue;
                isAdaptable = true;
            }
            if (!isAdaptable) {
                Class[] arr$ = null;
                return (AdapterType)arr$;
            }
            if (type.isInterface()) {
                handler = this.createInvocationHandler(adaptable, type, modelAnnotation);
                if (handler != null) {
                    Object object = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)handler);
                    return (AdapterType)object;
                }
                AdapterType AdapterType = null;
                return AdapterType;
            }
            handler = this.createObject(adaptable, type, modelAnnotation);
            return (AdapterType)handler;
        }
        finally {
            threadInvocationCounter.decrease();
        }
    }

    private Set<Field> collectInjectableFields(Class<?> type) {
        HashSet<Field> result = new HashSet<Field>();
        while (type != null) {
            AnnotatedElement[] fields = type.getDeclaredFields();
            this.addAnnotated(fields, result);
            type = type.getSuperclass();
        }
        return result;
    }

    private Set<Method> collectInjectableMethods(Class<?> type) {
        HashSet<Method> result = new HashSet<Method>();
        while (type != null) {
            AnnotatedElement[] methods = type.getDeclaredMethods();
            this.addAnnotated(methods, result);
            type = type.getSuperclass();
        }
        return result;
    }

    private <T extends AnnotatedElement> void addAnnotated(T[] elements, Set<T> set) {
        for (T element : elements) {
            Inject injection = this.getAnnotation((AnnotatedElement)element, (Class<T>)Inject.class);
            if (injection != null) {
                set.add(element);
                continue;
            }
            InjectAnnotation modelInject = this.getAnnotation((AnnotatedElement)element, (Class<T>)InjectAnnotation.class);
            if (modelInject == null) continue;
            set.add(element);
        }
    }

    private boolean injectElement(AnnotatedElement element, Object adaptable, Type type, boolean injectPrimitiveInitialValue, Model modelAnnotation, DisposalCallbackRegistry registry, InjectCallback callback) {
        InjectAnnotationProcessorFactory factory;
        InjectAnnotationProcessor annotationProcessor = null;
        String source = this.getSource(element);
        boolean wasInjectionSuccessful = false;
        InjectAnnotationProcessorFactory[] arr$ = this.sortedInjectAnnotationProcessorFactories;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (annotationProcessor = (factory = arr$[i$]).createAnnotationProcessor(adaptable, element)) == null; ++i$) {
        }
        String name = this.getName(element, annotationProcessor);
        Object injectionAdaptable = this.getAdaptable(adaptable, element, annotationProcessor);
        for (Injector injector : this.sortedInjectors) {
            Object value;
            if (source != null && !source.equals(injector.getName()) || name == null && !(injector instanceof AcceptsNullName) || injectionAdaptable == null || !callback.inject(element, value = injector.getValue(injectionAdaptable, name, type, element, registry))) continue;
            wasInjectionSuccessful = true;
            break;
        }
        if (!wasInjectionSuccessful) {
            wasInjectionSuccessful = this.injectDefaultValue(element, type, annotationProcessor, callback);
        }
        if (!wasInjectionSuccessful) {
            if (this.isOptional(element, modelAnnotation, annotationProcessor)) {
                if (injectPrimitiveInitialValue) {
                    this.injectPrimitiveInitialValue(element, type, callback);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private InvocationHandler createInvocationHandler(Object adaptable, Class<?> type, Model modelAnnotation) {
        Set<Method> injectableMethods = this.collectInjectableMethods(type);
        HashMap<Method, Object> methods = new HashMap<Method, Object>();
        SetMethodsCallback callback = new SetMethodsCallback(methods);
        MapBackedInvocationHandler handler = new MapBackedInvocationHandler(methods);
        DisposalCallbackRegistryImpl registry = new DisposalCallbackRegistryImpl();
        this.registerCallbackRegistry(handler, registry);
        HashSet<Method> requiredMethods = new HashSet<Method>();
        for (Method method : injectableMethods) {
            Type genericReturnType = method.getGenericReturnType();
            Type returnType = ModelAdapterFactory.mapPrimitiveClasses(genericReturnType);
            boolean isPrimitive = false;
            if (returnType != genericReturnType) {
                isPrimitive = true;
            }
            if (this.injectElement(method, adaptable, returnType, isPrimitive, modelAnnotation, registry, callback)) continue;
            requiredMethods.add(method);
        }
        registry.seal();
        if (!requiredMethods.isEmpty()) {
            log.warn("Required methods {} on model interface {} were not able to be injected.", requiredMethods, type);
            return null;
        }
        return handler;
    }

    private void registerCallbackRegistry(Object object, DisposalCallbackRegistryImpl registry) {
        PhantomReference<Object> reference = new PhantomReference<Object>(object, this.queue);
        this.disposalCallbacks.put(reference, registry);
    }

    private String getSource(AnnotatedElement element) {
        Source source = this.getAnnotation(element, Source.class);
        if (source != null) {
            return source.value();
        }
        return null;
    }

    private <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> annotationClass) {
        T annotation = element.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        for (Annotation ann : element.getAnnotations()) {
            annotation = ann.annotationType().getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private <AdapterType> AdapterType createObject(Object adaptable, Class<AdapterType> type, Model modelAnnotation) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        AdapterType object;
        DisposalCallbackRegistryImpl registry = new DisposalCallbackRegistryImpl();
        Constructor<AdapterType> constructorToUse = this.getBestMatchingConstructor(adaptable, type);
        if (constructorToUse == null) {
            log.warn("Model class {} does not have a usable constructor", (Object)type.getName());
            return null;
        }
        if (constructorToUse.getParameterTypes().length == 0) {
            object = constructorToUse.newInstance(new Object[0]);
        } else {
            try {
                object = this.newInstanceWithConstructorInjection(constructorToUse, adaptable, type, modelAnnotation, registry);
            }
            catch (InstantiationException ex) {
                registry.onDisposed();
                throw ex;
            }
            catch (InvocationTargetException ex) {
                registry.onDisposed();
                throw ex;
            }
            catch (IllegalAccessException ex) {
                registry.onDisposed();
                throw ex;
            }
        }
        if (object == null) {
            registry.onDisposed();
            return null;
        }
        this.registerCallbackRegistry(object, registry);
        SetFieldCallback callback = new SetFieldCallback(object);
        HashSet<Field> requiredFields = new HashSet<Field>();
        Set<Field> injectableFields = this.collectInjectableFields(type);
        for (Field field : injectableFields) {
            Type fieldType;
            if (this.injectElement(field, adaptable, fieldType = ModelAdapterFactory.mapPrimitiveClasses(field.getGenericType()), false, modelAnnotation, registry, callback)) continue;
            requiredFields.add(field);
        }
        registry.seal();
        if (!requiredFields.isEmpty()) {
            log.warn("Required properties {} on model class {} were not able to be injected.", requiredFields, type);
            return null;
        }
        try {
            this.invokePostConstruct(object);
            return object;
        }
        catch (Exception e) {
            log.error("Unable to invoke post construct method.", (Throwable)e);
            return null;
        }
    }

    private <AdapterType> Constructor<AdapterType> getBestMatchingConstructor(Object adaptable, Class<AdapterType> type) {
        Constructor<?>[] constructors = type.getConstructors();
        Arrays.sort(constructors, new ParameterCountInjectComparator());
        for (Constructor<?> constructor : constructors) {
            Class<?> paramType;
            if (constructor.isAnnotationPresent(Inject.class)) {
                return constructor;
            }
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length == 1 && (paramType = constructor.getParameterTypes()[0]).isInstance(adaptable)) {
                return constructor;
            }
            if (constructor.getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private <AdapterType> AdapterType newInstanceWithConstructorInjection(Constructor<AdapterType> constructor, Object adaptable, Class<AdapterType> type, Model modelAnnotation, DisposalCallbackRegistry registry) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        HashSet<ConstructorParameter> requiredParameters = new HashSet<ConstructorParameter>();
        Type[] parameterTypes = constructor.getGenericParameterTypes();
        ArrayList<Object> paramValues = new ArrayList<Object>(Arrays.asList(new Object[parameterTypes.length]));
        SetConstructorParameterCallback callback = new SetConstructorParameterCallback(paramValues);
        for (int i = 0; i < parameterTypes.length; ++i) {
            ConstructorParameter constructorParameter;
            Type genericType = ModelAdapterFactory.mapPrimitiveClasses(parameterTypes[i]);
            boolean isPrimitive = false;
            if (parameterTypes[i] != genericType) {
                isPrimitive = true;
            }
            if (this.injectElement(constructorParameter = new ConstructorParameter(constructor.getParameterAnnotations()[i], constructor.getParameterTypes()[i], genericType, i), adaptable, genericType, isPrimitive, modelAnnotation, registry, callback)) continue;
            requiredParameters.add(constructorParameter);
        }
        if (!requiredParameters.isEmpty()) {
            log.warn("Required constructor parameters {} on model class {} were not able to be injected.", requiredParameters, type);
            return null;
        }
        return constructor.newInstance(paramValues.toArray(new Object[paramValues.size()]));
    }

    private boolean isOptional(AnnotatedElement point, Model modelAnnotation, InjectAnnotationProcessor annotationProcessor) {
        Boolean isOptional;
        if (annotationProcessor != null && (isOptional = annotationProcessor.isOptional()) != null) {
            return isOptional;
        }
        if (modelAnnotation.defaultInjectionStrategy() == DefaultInjectionStrategy.REQUIRED) {
            return point.getAnnotation(Optional.class) != null;
        }
        return point.getAnnotation(Required.class) == null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private boolean injectDefaultValue(AnnotatedElement point, Type type, InjectAnnotationProcessor processor, InjectCallback callback) {
        void var6_28;
        if (processor != null && processor.hasDefault()) {
            return callback.inject(point, processor.getDefault());
        }
        Default defaultAnnotation = point.getAnnotation(Default.class);
        if (defaultAnnotation == null) {
            return false;
        }
        type = ModelAdapterFactory.mapPrimitiveClasses(type);
        Object var6_6 = null;
        if (!(type instanceof Class)) {
            log.warn("Cannot provide default for {}", (Object)type);
            return false;
        }
        Class injectedClass = (Class)type;
        if (injectedClass.isArray()) {
            Class<?> componentType = injectedClass.getComponentType();
            if (componentType == String.class) {
                String[] stringArray = defaultAnnotation.values();
                return callback.inject(point, var6_28);
            }
            if (componentType == Integer.TYPE) {
                int[] nArray = defaultAnnotation.intValues();
                return callback.inject(point, var6_28);
            }
            if (componentType == Integer.class) {
                Integer[] integerArray = ArrayUtils.toObject((int[])defaultAnnotation.intValues());
                return callback.inject(point, var6_28);
            }
            if (componentType == Long.TYPE) {
                long[] lArray = defaultAnnotation.longValues();
                return callback.inject(point, var6_28);
            }
            if (componentType == Long.class) {
                Long[] longArray = ArrayUtils.toObject((long[])defaultAnnotation.longValues());
                return callback.inject(point, var6_28);
            }
            if (componentType == Boolean.TYPE) {
                boolean[] blArray = defaultAnnotation.booleanValues();
                return callback.inject(point, var6_28);
            }
            if (componentType == Boolean.class) {
                Boolean[] booleanArray = ArrayUtils.toObject((boolean[])defaultAnnotation.booleanValues());
                return callback.inject(point, var6_28);
            }
            if (componentType == Short.TYPE) {
                short[] sArray = defaultAnnotation.shortValues();
                return callback.inject(point, var6_28);
            }
            if (componentType == Short.class) {
                Short[] shortArray = ArrayUtils.toObject((short[])defaultAnnotation.shortValues());
                return callback.inject(point, var6_28);
            }
            if (componentType == Float.TYPE) {
                float[] fArray = defaultAnnotation.floatValues();
                return callback.inject(point, var6_28);
            }
            if (componentType == Float.class) {
                Float[] floatArray = ArrayUtils.toObject((float[])defaultAnnotation.floatValues());
                return callback.inject(point, var6_28);
            }
            if (componentType == Double.TYPE) {
                double[] dArray = defaultAnnotation.doubleValues();
                return callback.inject(point, var6_28);
            }
            if (componentType == Double.class) {
                Double[] doubleArray = ArrayUtils.toObject((double[])defaultAnnotation.doubleValues());
                return callback.inject(point, var6_28);
            }
            log.warn("Default values for {} are not supported", componentType);
            return false;
        }
        if (injectedClass == String.class) {
            String string = defaultAnnotation.values()[0];
            return callback.inject(point, var6_28);
        }
        if (injectedClass == Integer.class) {
            Integer n = defaultAnnotation.intValues()[0];
            return callback.inject(point, var6_28);
        }
        if (injectedClass == Long.class) {
            Long l = defaultAnnotation.longValues()[0];
            return callback.inject(point, var6_28);
        }
        if (injectedClass == Boolean.class) {
            Boolean bl = defaultAnnotation.booleanValues()[0];
            return callback.inject(point, var6_28);
        }
        if (injectedClass == Short.class) {
            Short s = defaultAnnotation.shortValues()[0];
            return callback.inject(point, var6_28);
        }
        if (injectedClass == Float.class) {
            Float f = Float.valueOf(defaultAnnotation.floatValues()[0]);
            return callback.inject(point, var6_28);
        }
        if (injectedClass == Double.class) {
            Double d = defaultAnnotation.doubleValues()[0];
            return callback.inject(point, var6_28);
        }
        log.warn("Default values for {} are not supported", (Object)injectedClass);
        return false;
    }

    private void injectPrimitiveInitialValue(AnnotatedElement point, Type wrapperType, InjectCallback callback) {
        Type primitiveType = ModelAdapterFactory.mapWrapperClasses(wrapperType);
        Constable value = null;
        if (primitiveType == Integer.TYPE) {
            value = 0;
        } else if (primitiveType == Long.TYPE) {
            value = 0L;
        } else if (primitiveType == Boolean.TYPE) {
            value = Boolean.FALSE;
        } else if (primitiveType == Double.TYPE) {
            value = 0.0;
        } else if (primitiveType == Float.TYPE) {
            value = Float.valueOf(0.0f);
        } else if (primitiveType == Short.TYPE) {
            value = (short)0;
        } else if (primitiveType == Byte.TYPE) {
            value = (byte)0;
        } else if (primitiveType == Character.TYPE) {
            value = Character.valueOf('\u0000');
        }
        if (value != null) {
            callback.inject(point, value);
        }
    }

    private Object getAdaptable(Object adaptable, AnnotatedElement point, InjectAnnotationProcessor processor) {
        String viaPropertyName = null;
        if (processor != null) {
            viaPropertyName = processor.getVia();
        }
        if (viaPropertyName == null) {
            Via viaAnnotation = point.getAnnotation(Via.class);
            if (viaAnnotation == null) {
                return adaptable;
            }
            viaPropertyName = viaAnnotation.value();
        }
        try {
            return PropertyUtils.getProperty((Object)adaptable, (String)viaPropertyName);
        }
        catch (Exception e) {
            log.error("Unable to execution projection " + viaPropertyName, (Throwable)e);
            return null;
        }
    }

    private String getName(AnnotatedElement element, InjectAnnotationProcessor processor) {
        String name;
        if (processor != null && (name = processor.getName()) != null) {
            return name;
        }
        Named named = element.getAnnotation(Named.class);
        if (named != null) {
            return named.value();
        }
        if (element instanceof Method) {
            return this.getNameFromMethod((Method)element);
        }
        if (element instanceof Field) {
            return this.getNameFromField((Field)element);
        }
        if (element instanceof ConstructorParameter) {
            return null;
        }
        throw new IllegalArgumentException("The given element must be either method or field but is " + element);
    }

    private String getNameFromField(Field field) {
        return field.getName();
    }

    private String getNameFromMethod(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        if (methodName.startsWith("is")) {
            return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        }
        return methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokePostConstruct(Object object) throws Exception {
        ArrayList<Method> postConstructMethods = new ArrayList<Method>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PostConstruct.class)) continue;
                postConstructMethods.add(method);
            }
        }
        Collections.reverse(postConstructMethods);
        for (Method method : postConstructMethods) {
            boolean accessible = method.isAccessible();
            try {
                if (!accessible) {
                    method.setAccessible(true);
                }
                method.invoke(object, new Object[0]);
            }
            finally {
                if (accessible) continue;
                method.setAccessible(false);
            }
        }
    }

    private static Type mapPrimitiveClasses(Type type) {
        if (type instanceof Class) {
            return ClassUtils.primitiveToWrapper((Class)((Class)type));
        }
        return type;
    }

    private static Type mapWrapperClasses(Type type) {
        if (type instanceof Class) {
            return ClassUtils.wrapperToPrimitive((Class)((Class)type));
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setField(Field field, Object createdObject, Object value) {
        if (value != null) {
            if ((value = ModelAdapterFactory.adaptIfNecessary(value, field.getType(), field.getGenericType())) == null) {
                return false;
            }
            boolean accessible = field.isAccessible();
            try {
                if (!accessible) {
                    field.setAccessible(true);
                }
                field.set(createdObject, value);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                log.error("unable to inject field", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
        }
        return false;
    }

    private static boolean setMethod(Method method, Map<Method, Object> methods, Object value) {
        if (value != null) {
            if ((value = ModelAdapterFactory.adaptIfNecessary(value, method.getReturnType(), method.getGenericReturnType())) == null) {
                return false;
            }
            methods.put(method, value);
            return true;
        }
        return false;
    }

    private static boolean setConstructorParameter(ConstructorParameter constructorParameter, List<Object> parameterValues, Object value) {
        if (value != null && constructorParameter.getType() instanceof Class) {
            if ((value = ModelAdapterFactory.adaptIfNecessary(value, constructorParameter.getType(), constructorParameter.getGenericType())) == null) {
                return false;
            }
            parameterValues.set(constructorParameter.getParameterIndex(), value);
            return true;
        }
        return false;
    }

    private static Object adaptIfNecessary(Object value, Class<?> type, Type genericType) {
        if (!ModelAdapterFactory.isAcceptableType(type, genericType, value)) {
            Class<?> declaredType = type;
            if (value instanceof Adaptable) {
                value = ((Adaptable)value).adaptTo(type);
            } else if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Class<?> collectionType = declaredType;
                if (value instanceof Collection && (collectionType.equals(Collection.class) || collectionType.equals(List.class)) && parameterizedType.getActualTypeArguments().length == 1) {
                    ArrayList<Object> result = new ArrayList<Object>();
                    for (Object valueObject : (Collection)value) {
                        Object adapted;
                        if (!(valueObject instanceof Adaptable) || (adapted = ((Adaptable)valueObject).adaptTo((Class)parameterizedType.getActualTypeArguments()[0])) == null) continue;
                        result.add(adapted);
                    }
                    value = result;
                }
            }
        }
        return value;
    }

    private static boolean isAcceptableType(Class<?> type, Type genericType, Object value) {
        if (type.isInstance(value)) {
            if ((type == Collection.class || type == List.class) && genericType instanceof ParameterizedType && value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                if (!it.hasNext()) {
                    return true;
                }
                Class<?> actualComponentType = it.next().getClass();
                Class desiredComponentType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                return desiredComponentType.isAssignableFrom(actualComponentType);
            }
            return true;
        }
        if (type == Integer.TYPE) {
            return Integer.class.isInstance(value);
        }
        if (type == Long.TYPE) {
            return Long.class.isInstance(value);
        }
        if (type == Boolean.TYPE) {
            return Boolean.class.isInstance(value);
        }
        if (type == Double.TYPE) {
            return Double.class.isInstance(value);
        }
        if (type == Float.TYPE) {
            return Float.class.isInstance(value);
        }
        if (type == Short.TYPE) {
            return Short.class.isInstance(value);
        }
        if (type == Byte.TYPE) {
            return Byte.class.isInstance(value);
        }
        if (type == Character.TYPE) {
            return Character.class.isInstance(value);
        }
        return false;
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        Dictionary props = ctx.getProperties();
        final int maxRecursionDepth = PropertiesUtil.toInteger(props.get(PROP_MAX_RECURSION_DEPTH), (int)20);
        this.invocationCountThreadLocal = new ThreadLocal<ThreadInvocationCounter>(){

            @Override
            protected ThreadInvocationCounter initialValue() {
                return new ThreadInvocationCounter(maxRecursionDepth);
            }
        };
        BundleContext bundleContext = ctx.getBundleContext();
        this.queue = new ReferenceQueue();
        this.disposalCallbacks = new ConcurrentHashMap<Reference<Object>, DisposalCallbackRegistryImpl>();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("service.vendor", "Apache Software Foundation");
        properties.put("service.description", "Sling Models OSGi Service Disposal Job");
        properties.put("scheduler.concurrent", false);
        properties.put("scheduler.period", 30L);
        this.jobRegistration = bundleContext.registerService(Runnable.class.getName(), (Object)this, properties);
        this.listener = new ModelPackageBundleListener(ctx.getBundleContext(), this, this.adapterImplementations);
        Hashtable<String, String> printerProps = new Hashtable<String, String>();
        printerProps.put("service.vendor", "Apache Software Foundation");
        printerProps.put("service.description", "Sling Models Configuration Printer");
        printerProps.put("felix.webconsole.label", "slingmodels");
        printerProps.put("felix.webconsole.title", "Sling Models");
        printerProps.put("felix.webconsole.configprinter.modes", "always");
        this.configPrinterRegistration = bundleContext.registerService(Object.class.getName(), (Object)new ModelConfigurationPrinter(this), printerProps);
    }

    @Deactivate
    protected void deactivate() {
        this.listener.unregisterAll();
        this.adapterImplementations.removeAll();
        if (this.jobRegistration != null) {
            this.jobRegistration.unregister();
            this.jobRegistration = null;
        }
        if (this.configPrinterRegistration != null) {
            this.configPrinterRegistration.unregister();
            this.configPrinterRegistration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindInjector(Injector injector, Map<String, Object> props) {
        Map<Object, Injector> map = this.injectors;
        synchronized (map) {
            this.injectors.put(ServiceUtil.getComparableForServiceRanking(props), injector);
            this.sortedInjectors = this.injectors.values().toArray(new Injector[this.injectors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindInjector(Injector injector, Map<String, Object> props) {
        Map<Object, Injector> map = this.injectors;
        synchronized (map) {
            this.injectors.remove(ServiceUtil.getComparableForServiceRanking(props));
            this.sortedInjectors = this.injectors.values().toArray(new Injector[this.injectors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindInjectAnnotationProcessorFactory(InjectAnnotationProcessorFactory injector, Map<String, Object> props) {
        Map<Object, InjectAnnotationProcessorFactory> map = this.injectAnnotationProcessorFactories;
        synchronized (map) {
            this.injectAnnotationProcessorFactories.put(ServiceUtil.getComparableForServiceRanking(props), injector);
            this.sortedInjectAnnotationProcessorFactories = this.injectAnnotationProcessorFactories.values().toArray(new InjectAnnotationProcessorFactory[this.injectAnnotationProcessorFactories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindInjectAnnotationProcessorFactory(InjectAnnotationProcessorFactory injector, Map<String, Object> props) {
        Map<Object, InjectAnnotationProcessorFactory> map = this.injectAnnotationProcessorFactories;
        synchronized (map) {
            this.injectAnnotationProcessorFactories.remove(ServiceUtil.getComparableForServiceRanking(props));
            this.sortedInjectAnnotationProcessorFactories = this.injectAnnotationProcessorFactories.values().toArray(new InjectAnnotationProcessorFactory[this.injectAnnotationProcessorFactories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindImplementationPicker(ImplementationPicker implementationPicker, Map<String, Object> props) {
        Map<Object, ImplementationPicker> map = this.implementationPickers;
        synchronized (map) {
            this.implementationPickers.put(ServiceUtil.getComparableForServiceRanking(props), implementationPicker);
            this.adapterImplementations.setImplementationPickers(this.implementationPickers.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindImplementationPicker(ImplementationPicker implementationPicker, Map<String, Object> props) {
        Map<Object, ImplementationPicker> map = this.implementationPickers;
        synchronized (map) {
            this.implementationPickers.remove(ServiceUtil.getComparableForServiceRanking(props));
            this.adapterImplementations.setImplementationPickers(this.implementationPickers.values());
        }
    }

    Injector[] getInjectors() {
        return this.sortedInjectors;
    }

    InjectAnnotationProcessorFactory[] getInjectAnnotationProcessorFactories() {
        return this.sortedInjectAnnotationProcessorFactories;
    }

    ImplementationPicker[] getImplementationPickers() {
        return this.adapterImplementations.getImplementationPickers();
    }

    private static class SetConstructorParameterCallback
    implements InjectCallback {
        private final List<Object> parameterValues;

        private SetConstructorParameterCallback(List<Object> parameterValues) {
            this.parameterValues = parameterValues;
        }

        @Override
        public boolean inject(AnnotatedElement element, Object value) {
            return ModelAdapterFactory.setConstructorParameter((ConstructorParameter)element, this.parameterValues, value);
        }
    }

    private static class SetMethodsCallback
    implements InjectCallback {
        private final Map<Method, Object> methods;

        private SetMethodsCallback(Map<Method, Object> methods) {
            this.methods = methods;
        }

        @Override
        public boolean inject(AnnotatedElement element, Object value) {
            return ModelAdapterFactory.setMethod((Method)element, this.methods, value);
        }
    }

    private static class SetFieldCallback
    implements InjectCallback {
        private final Object object;

        private SetFieldCallback(Object object) {
            this.object = object;
        }

        @Override
        public boolean inject(AnnotatedElement element, Object value) {
            return ModelAdapterFactory.setField((Field)element, this.object, value);
        }
    }

    private static interface InjectCallback {
        public boolean inject(AnnotatedElement var1, Object var2);
    }

    private static class DisposalCallbackRegistryImpl
    implements DisposalCallbackRegistry {
        private List<DisposalCallback> callbacks = new ArrayList<DisposalCallback>();

        private DisposalCallbackRegistryImpl() {
        }

        public void addDisposalCallback(DisposalCallback callback) {
            this.callbacks.add(callback);
        }

        private void seal() {
            this.callbacks = Collections.unmodifiableList(this.callbacks);
        }

        private void onDisposed() {
            for (DisposalCallback callback : this.callbacks) {
                callback.onDisposed();
            }
        }
    }
}

