/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.io.PrintWriter;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;

public class ModelConfigurationPrinter {
    private final ModelAdapterFactory modelAdapterFactory;

    ModelConfigurationPrinter(ModelAdapterFactory modelAdapterFactory) {
        this.modelAdapterFactory = modelAdapterFactory;
    }

    public void printConfiguration(PrintWriter printWriter) {
        printWriter.println("Sling Models Injectors:");
        Injector[] injectors = this.modelAdapterFactory.getInjectors();
        if (injectors == null || injectors.length == 0) {
            printWriter.println("none");
        } else {
            for (Injector injector : injectors) {
                printWriter.printf("%s - %s", injector.getName(), injector.getClass().getName());
                printWriter.println();
            }
        }
        printWriter.println();
        printWriter.println("Sling Models Inject Annotation Processor Factories:");
        InjectAnnotationProcessorFactory[] factories = this.modelAdapterFactory.getInjectAnnotationProcessorFactories();
        if (factories == null || factories.length == 0) {
            printWriter.println("none");
        } else {
            for (InjectAnnotationProcessorFactory factory : factories) {
                printWriter.printf("%s", factory.getClass().getName());
                printWriter.println();
            }
        }
        printWriter.println();
        printWriter.println("Sling Models Implementation Pickers:");
        ImplementationPicker[] pickers = this.modelAdapterFactory.getImplementationPickers();
        if (pickers == null || pickers.length == 0) {
            printWriter.println("none");
        } else {
            for (ImplementationPicker picker : pickers) {
                printWriter.printf("%s", picker.getClass().getName());
                printWriter.println();
            }
        }
    }
}

