/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.AdapterImplementations;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelPackageBundleListener
implements BundleTrackerCustomizer {
    static final String HEADER = "Sling-Model-Packages";
    private static final String PROP_ADAPTER_CONDITION = "adapter.condition";
    private static final String PROP_IMPLEMENTATION_CLASS = "models.adapter.implementationClass";
    private static final Logger log = LoggerFactory.getLogger(ModelPackageBundleListener.class);
    private final BundleContext bundleContext;
    private final BundleTracker bundleTracker;
    private final AdapterFactory factory;
    private final AdapterImplementations adapterImplementations;

    public ModelPackageBundleListener(BundleContext bundleContext, AdapterFactory factory, AdapterImplementations adapterImplementations) {
        this.bundleContext = bundleContext;
        this.factory = factory;
        this.adapterImplementations = adapterImplementations;
        this.bundleTracker = new BundleTracker(bundleContext, 32, this);
        this.bundleTracker.open();
    }

    @Override
    public Object addingBundle(Bundle bundle, BundleEvent event) {
        ArrayList<ServiceRegistration> regs = new ArrayList<ServiceRegistration>();
        Dictionary headers = bundle.getHeaders();
        String packageList = PropertiesUtil.toString(headers.get(HEADER), null);
        if (packageList != null) {
            String[] packages;
            packageList = StringUtils.deleteWhitespace((String)packageList);
            for (String singlePackage : packages = packageList.split(",")) {
                Enumeration classUrls = bundle.findEntries("/" + singlePackage.replace('.', '/'), "*.class", true);
                if (classUrls == null) {
                    log.warn("No adaptable classes found in package {}, ignoring", (Object)singlePackage);
                    continue;
                }
                while (classUrls.hasMoreElements()) {
                    URL url = (URL)classUrls.nextElement();
                    String className = this.toClassName(url);
                    try {
                        Class implType = bundle.loadClass(className);
                        Model annotation = implType.getAnnotation(Model.class);
                        if (annotation == null) continue;
                        Class[] adapterTypes = annotation.adapters();
                        if (adapterTypes.length == 0) {
                            adapterTypes = new Class[]{implType};
                        }
                        if (!this.validateAdapterClasses(implType, adapterTypes)) continue;
                        for (Class adapterType : adapterTypes) {
                            if (adapterType == implType) continue;
                            this.adapterImplementations.add(adapterType, implType);
                        }
                        ServiceRegistration reg = this.registerAdapterFactory(adapterTypes, annotation.adaptables(), implType, annotation.condition());
                        regs.add(reg);
                    }
                    catch (ClassNotFoundException e) {
                        log.warn("Unable to load class", (Throwable)e);
                    }
                }
            }
        }
        return regs.toArray(new ServiceRegistration[0]);
    }

    @Override
    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    @Override
    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (object instanceof ServiceRegistration[]) {
            for (ServiceRegistration reg : (ServiceRegistration[])object) {
                ServiceReference ref = reg.getReference();
                String[] adapterTypeNames = PropertiesUtil.toStringArray((Object)ref.getProperty("adapters"));
                String implTypeName = PropertiesUtil.toString((Object)ref.getProperty(PROP_IMPLEMENTATION_CLASS), null);
                for (String adapterTypeName : adapterTypeNames) {
                    this.adapterImplementations.remove(adapterTypeName, implTypeName);
                }
                reg.unregister();
            }
        }
    }

    public synchronized void unregisterAll() {
        this.bundleTracker.close();
    }

    private String toClassName(URL url) {
        String f = url.getFile();
        String cn = f.substring(1, f.length() - ".class".length());
        return cn.replace('/', '.');
    }

    private String[] toStringArray(Class<?>[] classes) {
        String[] arr = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            arr[i] = classes[i].getName();
        }
        return arr;
    }

    private boolean validateAdapterClasses(Class<?> clazz, Class<?>[] adapterClasses) {
        for (Class<?> adapterClass : adapterClasses) {
            if (adapterClass.isAssignableFrom(clazz)) continue;
            log.warn("Unable to register model class {} because adapter class {} is not valid.", (Object)clazz.getName(), (Object)adapterClass.getName());
            return false;
        }
        return true;
    }

    private ServiceRegistration registerAdapterFactory(Class<?>[] adapterTypes, Class<?>[] adaptableTypes, Class<?> implType, String condition) {
        Hashtable<String, Object> registrationProps = new Hashtable<String, Object>();
        ((Dictionary)registrationProps).put("adapters", this.toStringArray(adapterTypes));
        ((Dictionary)registrationProps).put("adaptables", this.toStringArray(adaptableTypes));
        ((Dictionary)registrationProps).put(PROP_IMPLEMENTATION_CLASS, implType.getName());
        if (StringUtils.isNotBlank((String)condition)) {
            ((Dictionary)registrationProps).put(PROP_ADAPTER_CONDITION, condition);
        }
        return this.bundleContext.registerService(AdapterFactory.SERVICE_NAME, (Object)this.factory, registrationProps);
    }
}

