/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import javax.servlet.ServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="service.ranking", intValue={1000})
public class BindingsInjector
implements Injector,
InjectAnnotationProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(BindingsInjector.class);

    public String getName() {
        return "script-bindings";
    }

    private static Object getValue(SlingBindings bindings, String name, Class<?> type) {
        return bindings.get((Object)name);
    }

    public Object getValue(Object adaptable, String name, Type type, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        SlingBindings bindings = this.getBindings(adaptable);
        if (bindings == null) {
            return null;
        }
        if (type instanceof Class) {
            return BindingsInjector.getValue(bindings, name, (Class)type);
        }
        log.debug("BindingsInjector doesn't support non-class type {}", (Object)type);
        return null;
    }

    private SlingBindings getBindings(Object adaptable) {
        if (adaptable instanceof ServletRequest) {
            ServletRequest request = (ServletRequest)adaptable;
            return (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        }
        return null;
    }

    public InjectAnnotationProcessor createAnnotationProcessor(Object adaptable, AnnotatedElement element) {
        ScriptVariable annotation = element.getAnnotation(ScriptVariable.class);
        if (annotation != null) {
            return new ScriptVariableAnnotationProcessor(annotation);
        }
        return null;
    }

    private static class ScriptVariableAnnotationProcessor
    extends AbstractInjectAnnotationProcessor {
        private final ScriptVariable annotation;

        public ScriptVariableAnnotationProcessor(ScriptVariable annotation) {
            this.annotation = annotation;
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }

        public String getName() {
            if (this.annotation.name().isEmpty()) {
                return null;
            }
            return this.annotation.name();
        }
    }
}

