/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import javax.servlet.ServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="service.ranking", intValue={4000})
public class RequestAttributeInjector
implements Injector,
InjectAnnotationProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(RequestAttributeInjector.class);

    public String getName() {
        return "request-attributes";
    }

    public Object getValue(Object adaptable, String name, Type declaredType, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        if (!(adaptable instanceof ServletRequest)) {
            return null;
        }
        return ((ServletRequest)adaptable).getAttribute(name);
    }

    public InjectAnnotationProcessor createAnnotationProcessor(Object adaptable, AnnotatedElement element) {
        RequestAttribute annotation = element.getAnnotation(RequestAttribute.class);
        if (annotation != null) {
            return new RequestAttributeAnnotationProcessor(annotation);
        }
        return null;
    }

    private static class RequestAttributeAnnotationProcessor
    extends AbstractInjectAnnotationProcessor {
        private final RequestAttribute annotation;

        public RequestAttributeAnnotationProcessor(RequestAttribute annotation) {
            this.annotation = annotation;
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }

        public String getName() {
            if (this.annotation.name().isEmpty()) {
                return null;
            }
            return this.annotation.name();
        }
    }
}

