/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Path;
import org.apache.sling.models.annotations.injectorspecific.ResourcePath;
import org.apache.sling.models.impl.injectors.AbstractInjector;
import org.apache.sling.models.spi.AcceptsNullName;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;

@Component
@Service
@Property(name="service.ranking", intValue={2500})
public class ResourcePathInjector
extends AbstractInjector
implements Injector,
AcceptsNullName,
InjectAnnotationProcessorFactory {
    public String getName() {
        return "resource-path";
    }

    public Object getValue(Object adaptable, String name, Type declaredType, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        ResourceResolver resolver;
        String resourcePath = null;
        Path pathAnnotation = element.getAnnotation(Path.class);
        if (pathAnnotation != null) {
            resourcePath = pathAnnotation.value();
        } else {
            ValueMap map;
            ResourcePath resourcePathAnnotation = element.getAnnotation(ResourcePath.class);
            if (resourcePathAnnotation != null && (resourcePath = resourcePathAnnotation.path()).isEmpty()) {
                resourcePath = null;
            }
            if (resourcePath == null && name != null && (map = this.getValueMap(adaptable)) != null) {
                resourcePath = (String)map.get(name, String.class);
            }
        }
        if (resourcePath != null && (resolver = this.getResourceResolver(adaptable)) != null) {
            return resolver.getResource(resourcePath);
        }
        return null;
    }

    public InjectAnnotationProcessor createAnnotationProcessor(Object adaptable, AnnotatedElement element) {
        ResourcePath annotation = element.getAnnotation(ResourcePath.class);
        if (annotation != null) {
            return new ResourcePathAnnotationProcessor(annotation, adaptable);
        }
        return null;
    }

    private static class ResourcePathAnnotationProcessor
    extends AbstractInjectAnnotationProcessor {
        private final ResourcePath annotation;

        public ResourcePathAnnotationProcessor(ResourcePath annotation, Object adaptable) {
            this.annotation = annotation;
        }

        public String getName() {
            if (this.annotation.name().isEmpty()) {
                return null;
            }
            return this.annotation.name();
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }
    }
}

