/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.impl.ConstructorParameter;
import org.apache.sling.models.spi.AcceptsNullName;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;

@Component
@Service
@Property(name="service.ranking", intValue={0x7FFFFFFF})
public class SelfInjector
implements Injector,
InjectAnnotationProcessorFactory,
AcceptsNullName {
    public String getName() {
        return "self";
    }

    public Object getValue(Object adaptable, String name, Type type, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        if (element.isAnnotationPresent(Self.class)) {
            return adaptable;
        }
        if (element instanceof ConstructorParameter && ((ConstructorParameter)element).getParameterIndex() == 0 && type instanceof Class && ((Class)type).isAssignableFrom(adaptable.getClass())) {
            return adaptable;
        }
        return null;
    }

    public InjectAnnotationProcessor createAnnotationProcessor(Object adaptable, AnnotatedElement element) {
        Self annotation = element.getAnnotation(Self.class);
        if (annotation != null) {
            return new SelfAnnotationProcessor(annotation);
        }
        return null;
    }

    private static class SelfAnnotationProcessor
    extends AbstractInjectAnnotationProcessor {
        private final Self annotation;

        public SelfAnnotationProcessor(Self annotation) {
            this.annotation = annotation;
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }
    }
}

