/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.models.impl.model.ModelClass;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;

final class AdapterImplementations {
    private final ConcurrentMap<String, ConcurrentNavigableMap<String, ModelClass<?>>> adapterImplementations = new ConcurrentHashMap();
    private final ConcurrentMap<String, ModelClass<?>> modelClasses = new ConcurrentHashMap();
    private volatile ImplementationPicker[] sortedImplementationPickers = new ImplementationPicker[0];
    private volatile StaticInjectAnnotationProcessorFactory[] sortedStaticInjectAnnotationProcessorFactories = new StaticInjectAnnotationProcessorFactory[0];

    AdapterImplementations() {
    }

    public void setImplementationPickers(Collection<ImplementationPicker> implementationPickers) {
        this.sortedImplementationPickers = implementationPickers.toArray(new ImplementationPicker[implementationPickers.size()]);
    }

    public ImplementationPicker[] getImplementationPickers() {
        return this.sortedImplementationPickers;
    }

    public StaticInjectAnnotationProcessorFactory[] getStaticInjectAnnotationProcessorFactories() {
        return this.sortedStaticInjectAnnotationProcessorFactories;
    }

    public void setStaticInjectAnnotationProcessorFactories(Collection<StaticInjectAnnotationProcessorFactory> factories) {
        this.sortedStaticInjectAnnotationProcessorFactories = factories.toArray(new StaticInjectAnnotationProcessorFactory[factories.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Class<?> adapterType, Class<?> implType) {
        String key = adapterType.getName();
        if (adapterType == implType) {
            this.modelClasses.put(key, new ModelClass(implType, this.sortedStaticInjectAnnotationProcessorFactories));
        } else {
            ConcurrentMap<String, ConcurrentNavigableMap<String, ModelClass<?>>> concurrentMap = this.adapterImplementations;
            synchronized (concurrentMap) {
                ConcurrentSkipListMap implementations = (ConcurrentSkipListMap)this.adapterImplementations.get(key);
                if (implementations == null) {
                    implementations = new ConcurrentSkipListMap();
                    this.adapterImplementations.put(key, implementations);
                }
                implementations.put(implType.getName(), new ModelClass(implType, this.sortedStaticInjectAnnotationProcessorFactories));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String adapterTypeName, String implTypeName) {
        String key = adapterTypeName;
        if (StringUtils.equals((String)adapterTypeName, (String)implTypeName)) {
            this.modelClasses.remove(key);
        } else {
            ConcurrentMap<String, ConcurrentNavigableMap<String, ModelClass<?>>> concurrentMap = this.adapterImplementations;
            synchronized (concurrentMap) {
                ConcurrentNavigableMap implementations = (ConcurrentNavigableMap)this.adapterImplementations.get(key);
                if (implementations != null) {
                    implementations.remove(implTypeName);
                    if (implementations.isEmpty()) {
                        this.adapterImplementations.remove(key);
                    }
                }
            }
        }
    }

    public void removeAll() {
        this.modelClasses.clear();
        this.adapterImplementations.clear();
    }

    public <ModelType> ModelClass<ModelType> lookup(Class<ModelType> adapterType, Object adaptable) {
        String key = adapterType.getName();
        ModelClass modelClass = (ModelClass)this.modelClasses.get(key);
        if (modelClass != null) {
            return modelClass;
        }
        ConcurrentNavigableMap implementations = (ConcurrentNavigableMap)this.adapterImplementations.get(key);
        if (implementations == null || implementations.isEmpty()) {
            return null;
        }
        Collection implementationsCollection = implementations.values();
        ModelClass[] implementationWrappersArray = implementationsCollection.toArray(new ModelClass[implementationsCollection.size()]);
        Class[] implementationsArray = new Class[implementationsCollection.size()];
        for (int i = 0; i < implementationWrappersArray.length; ++i) {
            implementationsArray[i] = implementationWrappersArray[i].getType();
        }
        for (ImplementationPicker picker : this.sortedImplementationPickers) {
            Class implementation = picker.pick(adapterType, implementationsArray, adaptable);
            if (implementation == null) continue;
            for (int i = 0; i < implementationWrappersArray.length; ++i) {
                if (implementation != implementationWrappersArray[i].getType()) continue;
                return implementationWrappersArray[i];
            }
        }
        return null;
    }
}

