/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.lang.constant.Constable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.osgi.RankedServices;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.ValidationStrategy;
import org.apache.sling.models.factory.InvalidAdaptableException;
import org.apache.sling.models.factory.InvalidModelException;
import org.apache.sling.models.factory.MissingElementException;
import org.apache.sling.models.factory.MissingElementsException;
import org.apache.sling.models.factory.ModelClassException;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.models.factory.PostConstructException;
import org.apache.sling.models.factory.ValidationException;
import org.apache.sling.models.impl.AdapterImplementations;
import org.apache.sling.models.impl.MapBackedInvocationHandler;
import org.apache.sling.models.impl.ModelConfigurationPrinter;
import org.apache.sling.models.impl.ModelPackageBundleListener;
import org.apache.sling.models.impl.ReflectionUtil;
import org.apache.sling.models.impl.Result;
import org.apache.sling.models.impl.ThreadInvocationCounter;
import org.apache.sling.models.impl.model.ConstructorParameter;
import org.apache.sling.models.impl.model.InjectableElement;
import org.apache.sling.models.impl.model.InjectableField;
import org.apache.sling.models.impl.model.InjectableMethod;
import org.apache.sling.models.impl.model.ModelClass;
import org.apache.sling.models.impl.model.ModelClassConstructor;
import org.apache.sling.models.spi.AcceptsNullName;
import org.apache.sling.models.spi.DisposalCallback;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.ModelValidation;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory2;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true)
@Service(value={ModelFactory.class})
public class ModelAdapterFactory
implements AdapterFactory,
Runnable,
ModelFactory {
    private ReferenceQueue<Object> queue;
    private ConcurrentMap<Reference<Object>, DisposalCallbackRegistryImpl> disposalCallbacks;
    private static final Logger log = LoggerFactory.getLogger(ModelAdapterFactory.class);
    private static final int DEFAULT_MAX_RECURSION_DEPTH = 20;
    @Property(label="Maximum Recursion Depth", description="Maximum depth adaptation will be attempted.", intValue={20})
    private static final String PROP_MAX_RECURSION_DEPTH = "max.recursion.depth";
    @Nonnull
    @org.apache.felix.scr.annotations.Reference(name="injector", referenceInterface=Injector.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final RankedServices<Injector> injectors = new RankedServices();
    @Nonnull
    @org.apache.felix.scr.annotations.Reference(name="injectAnnotationProcessorFactory", referenceInterface=InjectAnnotationProcessorFactory.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final RankedServices<InjectAnnotationProcessorFactory> injectAnnotationProcessorFactories = new RankedServices();
    @Nonnull
    @org.apache.felix.scr.annotations.Reference(name="injectAnnotationProcessorFactory2", referenceInterface=InjectAnnotationProcessorFactory2.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final RankedServices<InjectAnnotationProcessorFactory2> injectAnnotationProcessorFactories2 = new RankedServices();
    @Nonnull
    @org.apache.felix.scr.annotations.Reference(name="staticInjectAnnotationProcessorFactory", referenceInterface=StaticInjectAnnotationProcessorFactory.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final RankedServices<StaticInjectAnnotationProcessorFactory> staticInjectAnnotationProcessorFactories = new RankedServices();
    @Nonnull
    @org.apache.felix.scr.annotations.Reference(name="implementationPicker", referenceInterface=ImplementationPicker.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final RankedServices<ImplementationPicker> implementationPickers = new RankedServices();
    @org.apache.felix.scr.annotations.Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY)
    private ModelValidation modelValidation;
    ModelPackageBundleListener listener;
    final AdapterImplementations adapterImplementations = new AdapterImplementations();
    private ServiceRegistration jobRegistration;
    private ServiceRegistration configPrinterRegistration;
    private ThreadLocal<ThreadInvocationCounter> invocationCountThreadLocal;

    @Override
    public void run() {
        Reference<Object> ref = this.queue.poll();
        while (ref != null) {
            log.debug("calling disposal for {}.", (Object)ref.toString());
            DisposalCallbackRegistryImpl registry = (DisposalCallbackRegistryImpl)this.disposalCallbacks.remove(ref);
            registry.onDisposed();
            ref = this.queue.poll();
        }
    }

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        Result<AdapterType> result = this.internalCreateModel(adaptable, type);
        if (!result.wasSuccessfull()) {
            if (result.getThrowable() instanceof PostConstructException || result.getThrowable() instanceof InvalidModelException) {
                log.debug("Could not adapt to model", (Throwable)result.getThrowable());
            } else {
                log.error("Could not adapt to model", (Throwable)result.getThrowable());
            }
            return null;
        }
        return result.getValue();
    }

    @Nonnull
    public <ModelType> ModelType createModel(@Nonnull Object adaptable, @Nonnull Class<ModelType> type) throws MissingElementsException, InvalidAdaptableException, ValidationException, InvalidModelException {
        if (adaptable == null) {
            throw new IllegalArgumentException("Given adaptable is null!");
        }
        if (type == null) {
            throw new IllegalArgumentException("Given type is null");
        }
        Result<ModelType> result = this.internalCreateModel(adaptable, type);
        if (!result.wasSuccessfull()) {
            throw result.getThrowable();
        }
        return result.getValue();
    }

    public boolean canCreateFromAdaptable(@Nonnull Object adaptable, @Nonnull Class<?> modelClass) throws ModelClassException {
        return this.internalCanCreateFromAdaptable(adaptable, modelClass);
    }

    private boolean internalCanCreateFromAdaptable(Object adaptable, Class<?> requestedType) throws ModelClassException {
        Class[] declaredAdaptable;
        ModelClass<?> modelClass = this.getImplementationTypeForAdapterType(requestedType, adaptable);
        if (!modelClass.hasModelAnnotation()) {
            throw new ModelClassException(String.format("Model class '%s' does not have a model annotation", modelClass.getType()));
        }
        for (Class clazz : declaredAdaptable = modelClass.getModelAnnotation().adaptables()) {
            if (!clazz.isInstance(adaptable)) continue;
            return true;
        }
        return false;
    }

    public boolean isModelClass(@Nonnull Object adaptable, @Nonnull Class<?> requestedType) {
        ModelClass<?> type = this.getImplementationTypeForAdapterType(requestedType, adaptable);
        return type.hasModelAnnotation();
    }

    private <ModelType> ModelClass<ModelType> getImplementationTypeForAdapterType(Class<ModelType> requestedType, Object adaptable) {
        ModelClass<ModelType> modelClass = this.adapterImplementations.lookup(requestedType, adaptable);
        if (modelClass != null) {
            log.debug("Using implementation type {} for requested adapter type {}", modelClass, requestedType);
            return modelClass;
        }
        return new ModelClass<ModelType>(requestedType, this.adapterImplementations.getStaticInjectAnnotationProcessorFactories());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ModelType> Result<ModelType> internalCreateModel(Object adaptable, Class<ModelType> requestedType) {
        ThreadInvocationCounter threadInvocationCounter = this.invocationCountThreadLocal.get();
        if (threadInvocationCounter.isMaximumReached()) {
            String msg = String.format("Adapting %s to %s failed, too much recursive invocations (>=%s).", adaptable, requestedType, threadInvocationCounter.maxRecursionDepth);
            return new Result((RuntimeException)new ModelClassException(msg));
        }
        threadInvocationCounter.increase();
        try {
            Result<Object> result;
            Object[] declaredAdaptable;
            ModelClass<ModelType> modelClass = this.getImplementationTypeForAdapterType(requestedType, adaptable);
            if (!modelClass.hasModelAnnotation()) {
                String msg = String.format("Provided Adapter class does not have a Model annotation: %s", modelClass.getType());
                Result result2 = new Result((RuntimeException)new ModelClassException(msg));
                return result2;
            }
            boolean isAdaptable = false;
            Model modelAnnotation = modelClass.getModelAnnotation();
            for (Class clazz : declaredAdaptable = modelAnnotation.adaptables()) {
                if (!clazz.isInstance(adaptable)) continue;
                isAdaptable = true;
            }
            if (!isAdaptable) {
                String string = String.format("Adaptables (%s) are not acceptable for the model class: %s", StringUtils.join((Object[])declaredAdaptable), modelClass.getType());
                Result result2 = new Result((RuntimeException)new InvalidAdaptableException(string));
                return result2;
            }
            RuntimeException runtimeException = this.validateModel(adaptable, modelClass.getType(), modelAnnotation);
            if (runtimeException != null) {
                Result result3 = new Result(runtimeException);
                return result3;
            }
            if (modelClass.getType().isInterface()) {
                Result<InvocationHandler> handlerResult = this.createInvocationHandler(adaptable, modelClass);
                if (!handlerResult.wasSuccessfull()) {
                    Result model = new Result(handlerResult.getThrowable());
                    return model;
                }
                Object model = Proxy.newProxyInstance(modelClass.getType().getClassLoader(), new Class[]{modelClass.getType()}, handlerResult.getValue());
                result = new Result<Object>(model);
            } else {
                try {
                    result = this.createObject(adaptable, modelClass);
                }
                catch (Exception e) {
                    String msg = String.format("Unable to create model %s", modelClass.getType());
                    Result result4 = new Result((RuntimeException)new ModelClassException(msg, (Throwable)e));
                    threadInvocationCounter.decrease();
                    return result4;
                }
            }
            Result<ModelType> result5 = result;
            return result5;
        }
        finally {
            threadInvocationCounter.decrease();
        }
    }

    private <ModelType> RuntimeException validateModel(Object adaptable, Class<ModelType> modelType, Model modelAnnotation) {
        if (modelAnnotation.validation() != ValidationStrategy.DISABLED) {
            if (this.modelValidation == null) {
                return new ValidationException("No active service for ModelValidation found, therefore no validation can be performed.");
            }
            return this.modelValidation.validate(adaptable, modelType, modelAnnotation.validation() == ValidationStrategy.REQUIRED);
        }
        return null;
    }

    @CheckForNull
    private RuntimeException injectElement(InjectableElement element, Object adaptable, Model modelAnnotation, @Nonnull DisposalCallbackRegistry registry, InjectCallback callback) {
        InjectAnnotationProcessorFactory2 factory;
        InjectAnnotationProcessor2 annotationProcessor = null;
        String source = element.getSource();
        boolean wasInjectionSuccessful = false;
        Iterator<InjectAnnotationProcessorFactory2> iterator = this.injectAnnotationProcessorFactories2.iterator();
        while (iterator.hasNext() && (annotationProcessor = (factory = iterator.next()).createAnnotationProcessor(adaptable, element.getAnnotatedElement())) == null) {
        }
        if (annotationProcessor == null) {
            iterator = this.injectAnnotationProcessorFactories.iterator();
            while (iterator.hasNext() && (annotationProcessor = (factory = (InjectAnnotationProcessorFactory)iterator.next()).createAnnotationProcessor(adaptable, element.getAnnotatedElement())) == null) {
            }
        }
        String name = this.getName(element, (InjectAnnotationProcessor)annotationProcessor);
        Object injectionAdaptable = this.getAdaptable(adaptable, element, (InjectAnnotationProcessor)annotationProcessor);
        Throwable lastInjectionException = null;
        if (injectionAdaptable != null) {
            for (Injector injector : this.injectors) {
                Object value;
                if (source != null && !source.equals(injector.getName()) || name == null && !(injector instanceof AcceptsNullName) || (value = injector.getValue(injectionAdaptable, name, element.getType(), element.getAnnotatedElement(), registry)) == null || (lastInjectionException = callback.inject(element, value)) != null) continue;
                wasInjectionSuccessful = true;
                break;
            }
        }
        if (!wasInjectionSuccessful) {
            Result<Boolean> defaultInjectionResult = this.injectDefaultValue(element, (InjectAnnotationProcessor)annotationProcessor, callback);
            if (defaultInjectionResult.wasSuccessfull()) {
                if (lastInjectionException != null) {
                    if (lastInjectionException instanceof PostConstructException || lastInjectionException instanceof InvalidModelException) {
                        log.debug("Although falling back to default value worked, injection into {} failed because of: " + lastInjectionException.getMessage(), (Object)element.getAnnotatedElement(), (Object)lastInjectionException);
                    } else {
                        log.warn("Although falling back to default value worked, injection into {} failed because of: " + lastInjectionException.getMessage(), (Object)element.getAnnotatedElement(), (Object)lastInjectionException);
                    }
                }
                wasInjectionSuccessful = defaultInjectionResult.getValue();
            } else {
                return defaultInjectionResult.getThrowable();
            }
        }
        if (!wasInjectionSuccessful) {
            if (element.isOptional((InjectAnnotationProcessor)annotationProcessor)) {
                RuntimeException throwable;
                if (element.isPrimitive() && (throwable = this.injectPrimitiveInitialValue(element, callback)) != null) {
                    return throwable;
                }
            } else {
                if (lastInjectionException != null) {
                    return lastInjectionException;
                }
                return new ModelClassException("No injector returned a non-null value!");
            }
        }
        return null;
    }

    private <ModelType> Result<InvocationHandler> createInvocationHandler(Object adaptable, ModelClass<ModelType> modelClass) {
        InjectableMethod[] injectableMethods = modelClass.getInjectableMethods();
        HashMap<Method, Object> methods = new HashMap<Method, Object>();
        SetMethodsCallback callback = new SetMethodsCallback(methods);
        MapBackedInvocationHandler handler = new MapBackedInvocationHandler(methods);
        DisposalCallbackRegistryImpl registry = new DisposalCallbackRegistryImpl();
        this.registerCallbackRegistry(handler, registry);
        MissingElementsException missingElements = new MissingElementsException("Could not create all mandatory methods for interface of model " + modelClass);
        for (InjectableMethod method : injectableMethods) {
            RuntimeException t = this.injectElement(method, adaptable, modelClass.getModelAnnotation(), registry, callback);
            if (t == null) continue;
            missingElements.addMissingElementExceptions(new MissingElementException(method.getAnnotatedElement(), (Throwable)t));
        }
        registry.seal();
        if (!missingElements.isEmpty()) {
            return new Result<InvocationHandler>((RuntimeException)missingElements);
        }
        return new Result<InvocationHandler>(handler);
    }

    private void registerCallbackRegistry(Object object, DisposalCallbackRegistryImpl registry) {
        PhantomReference<Object> reference = new PhantomReference<Object>(object, this.queue);
        this.disposalCallbacks.put(reference, registry);
    }

    private <ModelType> Result<ModelType> createObject(Object adaptable, ModelClass<ModelType> modelClass) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        ModelType object;
        DisposalCallbackRegistryImpl registry = new DisposalCallbackRegistryImpl();
        ModelClassConstructor<ModelType> constructorToUse = this.getBestMatchingConstructor(adaptable, modelClass);
        if (constructorToUse == null) {
            return new Result((RuntimeException)new ModelClassException("Unable to find a useable constructor for model " + modelClass.getType()));
        }
        if (constructorToUse.getConstructor().getParameterTypes().length == 0) {
            object = constructorToUse.getConstructor().newInstance(new Object[0]);
        } else {
            try {
                Result<ModelType> result = this.newInstanceWithConstructorInjection(constructorToUse, adaptable, modelClass, registry);
                if (!result.wasSuccessfull()) {
                    registry.onDisposed();
                    return result;
                }
                object = result.getValue();
            }
            catch (InstantiationException ex) {
                registry.onDisposed();
                throw ex;
            }
            catch (InvocationTargetException ex) {
                registry.onDisposed();
                throw ex;
            }
            catch (IllegalAccessException ex) {
                registry.onDisposed();
                throw ex;
            }
        }
        this.registerCallbackRegistry(object, registry);
        SetFieldCallback callback = new SetFieldCallback(object);
        InjectableField[] injectableFields = modelClass.getInjectableFields();
        MissingElementsException missingElements = new MissingElementsException("Could not inject all required fields into " + modelClass.getType());
        for (InjectableField field : injectableFields) {
            RuntimeException t = this.injectElement(field, adaptable, modelClass.getModelAnnotation(), registry, callback);
            if (t == null) continue;
            missingElements.addMissingElementExceptions(new MissingElementException(field.getAnnotatedElement(), (Throwable)t));
        }
        registry.seal();
        if (!missingElements.isEmpty()) {
            return new Result((RuntimeException)missingElements);
        }
        try {
            this.invokePostConstruct(object);
        }
        catch (InvocationTargetException e) {
            return new Result((RuntimeException)new PostConstructException("Post-construct method has thrown an exception for model " + modelClass.getType(), e.getCause()));
        }
        catch (IllegalAccessException e) {
            new Result((RuntimeException)new ModelClassException("Could not call post-construct method for model " + modelClass.getType(), (Throwable)e));
        }
        return new Result<ModelType>(object);
    }

    private <ModelType> ModelClassConstructor<ModelType> getBestMatchingConstructor(Object adaptable, ModelClass<ModelType> type) {
        ModelClassConstructor[] constructors;
        for (ModelClassConstructor constructor : constructors = type.getConstructors()) {
            Class<?> paramType;
            if (constructor.hasInjectAnnotation()) {
                return constructor;
            }
            Class<?>[] paramTypes = constructor.getConstructor().getParameterTypes();
            if (paramTypes.length == 1 && (paramType = constructor.getConstructor().getParameterTypes()[0]).isInstance(adaptable)) {
                return constructor;
            }
            if (constructor.getConstructor().getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private <ModelType> Result<ModelType> newInstanceWithConstructorInjection(ModelClassConstructor<ModelType> constructor, Object adaptable, ModelClass<ModelType> modelClass, DisposalCallbackRegistry registry) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        ConstructorParameter[] parameters = constructor.getConstructorParameters();
        ArrayList<Object> paramValues = new ArrayList<Object>(Arrays.asList(new Object[parameters.length]));
        SetConstructorParameterCallback callback = new SetConstructorParameterCallback(paramValues);
        MissingElementsException missingElements = new MissingElementsException("Required constructor parameters were not able to be injected on model " + modelClass.getType());
        for (int i = 0; i < parameters.length; ++i) {
            RuntimeException t = this.injectElement(parameters[i], adaptable, modelClass.getModelAnnotation(), registry, callback);
            if (t == null) continue;
            missingElements.addMissingElementExceptions(new MissingElementException(parameters[i].getAnnotatedElement(), (Throwable)t));
        }
        if (!missingElements.isEmpty()) {
            return new Result((RuntimeException)missingElements);
        }
        return new Result<ModelType>(constructor.getConstructor().newInstance(paramValues.toArray(new Object[paramValues.size()])));
    }

    private Result<Boolean> injectDefaultValue(InjectableElement point, InjectAnnotationProcessor processor, InjectCallback callback) {
        if (processor != null && processor.hasDefault()) {
            RuntimeException t = callback.inject(point, processor.getDefault());
            if (t == null) {
                return new Result<Boolean>(Boolean.TRUE);
            }
            return new Result<Boolean>(t);
        }
        Object value = point.getDefaultValue();
        if (value != null) {
            RuntimeException t = callback.inject(point, value);
            if (t == null) {
                return new Result<Boolean>(Boolean.TRUE);
            }
            return new Result<Boolean>(t);
        }
        return new Result<Boolean>(Boolean.FALSE);
    }

    private RuntimeException injectPrimitiveInitialValue(InjectableElement point, InjectCallback callback) {
        Type primitiveType = ReflectionUtil.mapWrapperClasses(point.getType());
        Constable value = null;
        if (primitiveType == Integer.TYPE) {
            value = 0;
        } else if (primitiveType == Long.TYPE) {
            value = 0L;
        } else if (primitiveType == Boolean.TYPE) {
            value = Boolean.FALSE;
        } else if (primitiveType == Double.TYPE) {
            value = 0.0;
        } else if (primitiveType == Float.TYPE) {
            value = Float.valueOf(0.0f);
        } else if (primitiveType == Short.TYPE) {
            value = (short)0;
        } else if (primitiveType == Byte.TYPE) {
            value = (byte)0;
        } else if (primitiveType == Character.TYPE) {
            value = Character.valueOf('\u0000');
        }
        if (value != null) {
            return callback.inject(point, value);
        }
        return new ModelClassException(String.format("Unknown primitive type %s", primitiveType.toString()));
    }

    private Object getAdaptable(Object adaptable, InjectableElement point, InjectAnnotationProcessor processor) {
        String viaPropertyName = null;
        if (processor != null) {
            viaPropertyName = processor.getVia();
        }
        if (viaPropertyName == null) {
            viaPropertyName = point.getVia();
        }
        if (viaPropertyName == null) {
            return adaptable;
        }
        try {
            return PropertyUtils.getProperty((Object)adaptable, (String)viaPropertyName);
        }
        catch (Exception e) {
            log.error("Unable to execution projection " + viaPropertyName, (Throwable)e);
            return null;
        }
    }

    private String getName(InjectableElement element, InjectAnnotationProcessor processor) {
        String name;
        if (processor != null && (name = processor.getName()) != null) {
            return name;
        }
        return element.getName();
    }

    private boolean addMethodIfNotOverriden(List<Method> methods, Method newMethod) {
        for (Method method : methods) {
            if (!method.getName().equals(newMethod.getName()) || !Arrays.equals(method.getParameterTypes(), newMethod.getParameterTypes())) continue;
            return false;
        }
        methods.add(newMethod);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokePostConstruct(Object object) throws InvocationTargetException, IllegalAccessException {
        ArrayList<Method> postConstructMethods = new ArrayList<Method>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PostConstruct.class)) continue;
                this.addMethodIfNotOverriden(postConstructMethods, method);
            }
        }
        Collections.reverse(postConstructMethods);
        for (Method method : postConstructMethods) {
            boolean accessible = method.isAccessible();
            try {
                if (!accessible) {
                    method.setAccessible(true);
                }
                method.invoke(object, new Object[0]);
            }
            finally {
                if (accessible) continue;
                method.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeException setField(InjectableField injectableField, Object createdObject, Object value) {
        Field field = injectableField.getField();
        Result<Object> result = this.adaptIfNecessary(value, field.getType(), field.getGenericType());
        if (result.wasSuccessfull()) {
            boolean accessible = field.isAccessible();
            try {
                if (!accessible) {
                    field.setAccessible(true);
                }
                field.set(createdObject, result.getValue());
            }
            catch (Exception e) {
                ModelClassException modelClassException = new ModelClassException("Could not inject field due to reflection issues", (Throwable)e);
                return modelClassException;
            }
            finally {
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
            return null;
        }
        return result.getThrowable();
    }

    private RuntimeException setMethod(InjectableMethod injectableMethod, Map<Method, Object> methods, Object value) {
        Method method = injectableMethod.getMethod();
        Result<Object> result = this.adaptIfNecessary(value, method.getReturnType(), method.getGenericReturnType());
        if (result.wasSuccessfull()) {
            methods.put(method, result.getValue());
            return null;
        }
        return result.getThrowable();
    }

    private RuntimeException setConstructorParameter(ConstructorParameter constructorParameter, List<Object> parameterValues, Object value) {
        if (constructorParameter.getParameterType() instanceof Class) {
            Result<Object> result = this.adaptIfNecessary(value, (Class)constructorParameter.getParameterType(), constructorParameter.getGenericType());
            if (result.wasSuccessfull()) {
                parameterValues.set(constructorParameter.getParameterIndex(), result.getValue());
                return null;
            }
            return result.getThrowable();
        }
        return new ModelClassException(String.format("Constructor parameter with index %d is not a class!", constructorParameter.getParameterIndex()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result<Object> adaptIfNecessary(Object value, Class<?> type, Type genericType) {
        Object adaptedValue;
        if (ModelAdapterFactory.isAcceptableType(type, genericType, value)) return new Result<Object>(value);
        Class<?> declaredType = type;
        if (this.isModelClass(value, type) && this.canCreateFromAdaptable(value, type)) {
            Result<?> result = this.internalCreateModel(value, type);
            if (!result.wasSuccessfull()) return new Result<Object>((RuntimeException)new ModelClassException(String.format("Could not create model from %s: %s", value.getClass(), result.getThrowable().getMessage()), (Throwable)result.getThrowable()));
            adaptedValue = result.getValue();
            return new Result<Object>(adaptedValue);
        } else {
            if (value instanceof Adaptable) {
                adaptedValue = ((Adaptable)value).adaptTo(type);
                if (adaptedValue != null) return new Result<Object>(adaptedValue);
                return new Result<Object>((RuntimeException)new ModelClassException(String.format("Could not adapt from %s to %s", value.getClass(), type)));
            }
            if (!(genericType instanceof ParameterizedType)) return new Result<Object>((RuntimeException)new ModelClassException(String.format("Could not adapt from %s to %s, because this class is not adaptable!", value.getClass(), type)));
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Class<?> collectionType = declaredType;
            if (!(value instanceof Collection) || !collectionType.equals(Collection.class) && !collectionType.equals(List.class) || parameterizedType.getActualTypeArguments().length != 1) return new Result<Object>((RuntimeException)new ModelClassException(String.format("%s is neither a parametererized Collection or List", collectionType)));
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object valueObject : (Collection)value) {
                if (!(valueObject instanceof Adaptable)) continue;
                Object adapted = ((Adaptable)valueObject).adaptTo((Class)parameterizedType.getActualTypeArguments()[0]);
                if (adapted == null) return new Result<Object>((RuntimeException)new ModelClassException(String.format("Could not adapt from %s to %s within the collection", value.getClass(), type)));
                result.add(adapted);
            }
            adaptedValue = result;
        }
        return new Result<Object>(adaptedValue);
    }

    private static boolean isAcceptableType(Class<?> type, Type genericType, Object value) {
        if (type.isInstance(value)) {
            if ((type == Collection.class || type == List.class) && genericType instanceof ParameterizedType && value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                if (!it.hasNext()) {
                    return true;
                }
                Class<?> actualComponentType = it.next().getClass();
                Class desiredComponentType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                return desiredComponentType.isAssignableFrom(actualComponentType);
            }
            return true;
        }
        if (type == Integer.TYPE) {
            return Integer.class.isInstance(value);
        }
        if (type == Long.TYPE) {
            return Long.class.isInstance(value);
        }
        if (type == Boolean.TYPE) {
            return Boolean.class.isInstance(value);
        }
        if (type == Double.TYPE) {
            return Double.class.isInstance(value);
        }
        if (type == Float.TYPE) {
            return Float.class.isInstance(value);
        }
        if (type == Short.TYPE) {
            return Short.class.isInstance(value);
        }
        if (type == Byte.TYPE) {
            return Byte.class.isInstance(value);
        }
        if (type == Character.TYPE) {
            return Character.class.isInstance(value);
        }
        return false;
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        Dictionary props = ctx.getProperties();
        final int maxRecursionDepth = PropertiesUtil.toInteger(props.get(PROP_MAX_RECURSION_DEPTH), 20);
        this.invocationCountThreadLocal = new ThreadLocal<ThreadInvocationCounter>(){

            @Override
            protected ThreadInvocationCounter initialValue() {
                return new ThreadInvocationCounter(maxRecursionDepth);
            }
        };
        BundleContext bundleContext = ctx.getBundleContext();
        this.queue = new ReferenceQueue();
        this.disposalCallbacks = new ConcurrentHashMap<Reference<Object>, DisposalCallbackRegistryImpl>();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("service.vendor", "Apache Software Foundation");
        properties.put("service.description", "Sling Models OSGi Service Disposal Job");
        properties.put("scheduler.concurrent", false);
        properties.put("scheduler.period", 30L);
        this.jobRegistration = bundleContext.registerService(Runnable.class.getName(), (Object)this, properties);
        this.listener = new ModelPackageBundleListener(ctx.getBundleContext(), this, this.adapterImplementations);
        Hashtable<String, String> printerProps = new Hashtable<String, String>();
        printerProps.put("service.vendor", "Apache Software Foundation");
        printerProps.put("service.description", "Sling Models Configuration Printer");
        printerProps.put("felix.webconsole.label", "slingmodels");
        printerProps.put("felix.webconsole.title", "Sling Models");
        printerProps.put("felix.webconsole.configprinter.modes", "always");
        this.configPrinterRegistration = bundleContext.registerService(Object.class.getName(), (Object)new ModelConfigurationPrinter(this), printerProps);
    }

    @Deactivate
    protected void deactivate() {
        this.listener.unregisterAll();
        this.adapterImplementations.removeAll();
        if (this.jobRegistration != null) {
            this.jobRegistration.unregister();
            this.jobRegistration = null;
        }
        if (this.configPrinterRegistration != null) {
            this.configPrinterRegistration.unregister();
            this.configPrinterRegistration = null;
        }
    }

    protected void bindInjector(Injector injector, Map<String, Object> props) {
        this.injectors.bind(injector, props);
    }

    protected void unbindInjector(Injector injector, Map<String, Object> props) {
        this.injectors.unbind(injector, props);
    }

    protected void bindInjectAnnotationProcessorFactory(InjectAnnotationProcessorFactory factory, Map<String, Object> props) {
        this.injectAnnotationProcessorFactories.bind(factory, props);
    }

    protected void unbindInjectAnnotationProcessorFactory(InjectAnnotationProcessorFactory factory, Map<String, Object> props) {
        this.injectAnnotationProcessorFactories.unbind(factory, props);
    }

    protected void bindInjectAnnotationProcessorFactory2(InjectAnnotationProcessorFactory2 factory, Map<String, Object> props) {
        this.injectAnnotationProcessorFactories2.bind(factory, props);
    }

    protected void unbindInjectAnnotationProcessorFactory2(InjectAnnotationProcessorFactory2 factory, Map<String, Object> props) {
        this.injectAnnotationProcessorFactories2.unbind(factory, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindStaticInjectAnnotationProcessorFactory(StaticInjectAnnotationProcessorFactory factory, Map<String, Object> props) {
        RankedServices<StaticInjectAnnotationProcessorFactory> rankedServices = this.staticInjectAnnotationProcessorFactories;
        synchronized (rankedServices) {
            this.staticInjectAnnotationProcessorFactories.bind(factory, props);
            this.adapterImplementations.setStaticInjectAnnotationProcessorFactories(this.staticInjectAnnotationProcessorFactories.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindStaticInjectAnnotationProcessorFactory(StaticInjectAnnotationProcessorFactory factory, Map<String, Object> props) {
        RankedServices<StaticInjectAnnotationProcessorFactory> rankedServices = this.staticInjectAnnotationProcessorFactories;
        synchronized (rankedServices) {
            this.staticInjectAnnotationProcessorFactories.unbind(factory, props);
            this.adapterImplementations.setStaticInjectAnnotationProcessorFactories(this.staticInjectAnnotationProcessorFactories.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindImplementationPicker(ImplementationPicker implementationPicker, Map<String, Object> props) {
        RankedServices<ImplementationPicker> rankedServices = this.implementationPickers;
        synchronized (rankedServices) {
            this.implementationPickers.bind(implementationPicker, props);
            this.adapterImplementations.setImplementationPickers(this.implementationPickers.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindImplementationPicker(ImplementationPicker implementationPicker, Map<String, Object> props) {
        RankedServices<ImplementationPicker> rankedServices = this.implementationPickers;
        synchronized (rankedServices) {
            this.implementationPickers.unbind(implementationPicker, props);
            this.adapterImplementations.setImplementationPickers(this.implementationPickers.get());
        }
    }

    @Nonnull
    Collection<Injector> getInjectors() {
        return this.injectors.get();
    }

    @Nonnull
    Collection<InjectAnnotationProcessorFactory> getInjectAnnotationProcessorFactories() {
        return this.injectAnnotationProcessorFactories.get();
    }

    @Nonnull
    Collection<InjectAnnotationProcessorFactory2> getInjectAnnotationProcessorFactories2() {
        return this.injectAnnotationProcessorFactories2.get();
    }

    @Nonnull
    Collection<StaticInjectAnnotationProcessorFactory> getStaticInjectAnnotationProcessorFactories() {
        return this.staticInjectAnnotationProcessorFactories.get();
    }

    @Nonnull
    ImplementationPicker[] getImplementationPickers() {
        return this.adapterImplementations.getImplementationPickers();
    }

    protected void bindModelValidation(ModelValidation modelValidation) {
        this.modelValidation = modelValidation;
    }

    protected void unbindModelValidation(ModelValidation modelValidation) {
        if (this.modelValidation == modelValidation) {
            this.modelValidation = null;
        }
    }

    private class SetConstructorParameterCallback
    implements InjectCallback {
        private final List<Object> parameterValues;

        private SetConstructorParameterCallback(List<Object> parameterValues) {
            this.parameterValues = parameterValues;
        }

        @Override
        public RuntimeException inject(InjectableElement element, Object value) {
            return ModelAdapterFactory.this.setConstructorParameter((ConstructorParameter)element, this.parameterValues, value);
        }
    }

    private class SetMethodsCallback
    implements InjectCallback {
        private final Map<Method, Object> methods;

        private SetMethodsCallback(Map<Method, Object> methods) {
            this.methods = methods;
        }

        @Override
        public RuntimeException inject(InjectableElement element, Object value) {
            return ModelAdapterFactory.this.setMethod((InjectableMethod)element, this.methods, value);
        }
    }

    private class SetFieldCallback
    implements InjectCallback {
        private final Object object;

        private SetFieldCallback(Object object) {
            this.object = object;
        }

        @Override
        public RuntimeException inject(InjectableElement element, Object value) {
            return ModelAdapterFactory.this.setField((InjectableField)element, this.object, value);
        }
    }

    private static interface InjectCallback {
        public RuntimeException inject(InjectableElement var1, Object var2);
    }

    private static class DisposalCallbackRegistryImpl
    implements DisposalCallbackRegistry {
        private List<DisposalCallback> callbacks = new ArrayList<DisposalCallback>();

        private DisposalCallbackRegistryImpl() {
        }

        public void addDisposalCallback(@Nonnull DisposalCallback callback) {
            this.callbacks.add(callback);
        }

        private void seal() {
            this.callbacks = Collections.unmodifiableList(this.callbacks);
        }

        private void onDisposed() {
            for (DisposalCallback callback : this.callbacks) {
                callback.onDisposed();
            }
        }
    }
}

