/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.models.factory.ExportException;
import org.apache.sling.models.factory.MissingExporterException;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.scripting.core.ScriptHelper;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slingmodelsimpl.org.apache.sling.scripting.core.impl.helper.ProtectedBindings;

class ExportServlet
extends SlingSafeMethodsServlet {
    private final Logger logger;
    private static final String BINDINGS_CONTEXT = "request";
    private static final String RESOLVER = "resolver";
    private static final Set<String> PROTECTED_KEYS = new HashSet<String>(Arrays.asList("request", "response", "reader", "sling", "resource", "resolver", "out", "log"));
    private final String exporterName;
    private final String registeredSelector;
    private final BundleContext bundleContext;
    private final ModelFactory modelFactory;
    private final BindingsValuesProvidersByContext bindingsValuesProvidersByContext;
    private final ScriptEngineFactory scriptEngineFactory;
    private final ExportedObjectAccessor accessor;
    private final Map<String, String> baseOptions;
    public static final ExportedObjectAccessor RESOURCE_ACCESSOR = new ExportedObjectAccessor(){

        @Override
        public String getExportedString(SlingHttpServletRequest request, Map<String, String> options, ModelFactory modelFactory, String exporterName) throws ExportException, MissingExporterException {
            return (String)modelFactory.exportModelForResource(request.getResource(), exporterName, String.class, options);
        }
    };
    public static final ExportedObjectAccessor REQUEST_ACCESSOR = new ExportedObjectAccessor(){

        @Override
        public String getExportedString(SlingHttpServletRequest request, Map<String, String> options, ModelFactory modelFactory, String exporterName) throws ExportException, MissingExporterException {
            return (String)modelFactory.exportModelForRequest(request, exporterName, String.class, options);
        }
    };

    public ExportServlet(BundleContext bundleContext, ModelFactory modelFactory, BindingsValuesProvidersByContext bindingsValuesProvidersByContext, ScriptEngineFactory scriptFactory, Class<?> annotatedClass, String registeredSelector, String exporterName, ExportedObjectAccessor accessor, Map<String, String> baseOptions) {
        this.bundleContext = bundleContext;
        this.modelFactory = modelFactory;
        this.bindingsValuesProvidersByContext = bindingsValuesProvidersByContext;
        this.scriptEngineFactory = scriptFactory;
        this.registeredSelector = registeredSelector;
        this.exporterName = exporterName;
        this.accessor = accessor;
        this.baseOptions = baseOptions;
        String loggerName = ExportServlet.class.getName() + "." + annotatedClass.getName();
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block10: {
            Map<String, String> options = this.createOptionMap(request);
            ScriptHelper scriptHelper = new ScriptHelper(this.bundleContext, null, request, response);
            try {
                String exported;
                this.addScriptBindings((SlingScriptHelper)scriptHelper, request, response);
                try {
                    exported = this.accessor.getExportedString(request, options, this.modelFactory, this.exporterName);
                }
                catch (ExportException e) {
                    this.logger.error("Could not perform export with " + this.exporterName + " requested by model.", (Throwable)e);
                    response.setStatus(500);
                    scriptHelper.cleanup();
                    return;
                }
                catch (MissingExporterException e) {
                    this.logger.error("Could not get exporter " + this.exporterName + " requested by model.", (Throwable)e);
                    response.setStatus(500);
                    scriptHelper.cleanup();
                    return;
                }
                if (exported == null) {
                    response.setStatus(404);
                    return;
                }
                response.setContentType(request.getResponseContentType());
                response.getWriter().write(exported);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                scriptHelper.cleanup();
            }
        }
    }

    private void addScriptBindings(SlingScriptHelper scriptHelper, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("sling", (Object)scriptHelper);
        bindings.put("resource", (Object)request.getResource());
        bindings.put(RESOLVER, (Object)request.getResource().getResourceResolver());
        bindings.put(BINDINGS_CONTEXT, (Object)request);
        bindings.put("response", (Object)response);
        bindings.put("reader", (Object)request.getReader());
        bindings.put("out", (Object)response.getWriter());
        bindings.put("log", (Object)this.logger);
        Collection bindingsValuesProviders = this.bindingsValuesProvidersByContext.getBindingsValuesProviders(this.scriptEngineFactory, BINDINGS_CONTEXT);
        if (!bindingsValuesProviders.isEmpty()) {
            HashSet<String> protectedKeys = new HashSet<String>();
            protectedKeys.addAll(PROTECTED_KEYS);
            ProtectedBindings protectedBindings = new ProtectedBindings(bindings, protectedKeys);
            for (BindingsValuesProvider provider : bindingsValuesProviders) {
                provider.addBindings((Bindings)protectedBindings);
            }
        }
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        request.setAttribute(SlingBindings.class.getName(), (Object)slingBindings);
    }

    private Map<String, String> createOptionMap(SlingHttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        String[] selectors = request.getRequestPathInfo().getSelectors();
        HashMap<String, String> result = new HashMap<String, String>(this.baseOptions.size() + parameterMap.size() + selectors.length - 1);
        result.putAll(this.baseOptions);
        for (String selector : selectors) {
            if (selector.equals(this.registeredSelector)) continue;
            result.put(selector, "true");
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            if (((String[])entry.getValue()).length == 0) {
                result.put((String)entry.getKey(), Boolean.TRUE.toString());
                continue;
            }
            result.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return result;
    }

    public static interface ExportedObjectAccessor {
        public String getExportedString(SlingHttpServletRequest var1, Map<String, String> var2, ModelFactory var3, String var4) throws ExportException, MissingExporterException;
    }
}

