/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import javax.servlet.Servlet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.ExporterOption;
import org.apache.sling.models.annotations.Exporters;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.AdapterImplementations;
import org.apache.sling.models.impl.ExportServlet;
import org.apache.sling.models.impl.ExporterScriptEngineFactory;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slingmodelsimpl.org.apache.sling.commons.osgi.PropertiesUtil;

public class ModelPackageBundleListener
implements BundleTrackerCustomizer {
    static final String PACKAGE_HEADER = "Sling-Model-Packages";
    static final String CLASSES_HEADER = "Sling-Model-Classes";
    static final String PROP_EXPORTER_SERVLET_CLASS = "sling.models.exporter.servlet.class";
    static final String PROP_EXPORTER_SERVLET_NAME = "sling.models.exporter.servlet.name";
    private static final String PROP_ADAPTER_CONDITION = "adapter.condition";
    private static final String PROP_IMPLEMENTATION_CLASS = "models.adapter.implementationClass";
    private static final Logger log = LoggerFactory.getLogger(ModelPackageBundleListener.class);
    private final BundleContext bundleContext;
    private final BundleTracker bundleTracker;
    private final ModelAdapterFactory factory;
    private final AdapterImplementations adapterImplementations;
    private final BindingsValuesProvidersByContext bindingsValuesProvidersByContext;
    private final ScriptEngineFactory scriptEngineFactory;

    public ModelPackageBundleListener(BundleContext bundleContext, ModelAdapterFactory factory, AdapterImplementations adapterImplementations, BindingsValuesProvidersByContext bindingsValuesProvidersByContext) {
        this.bundleContext = bundleContext;
        this.factory = factory;
        this.adapterImplementations = adapterImplementations;
        this.bindingsValuesProvidersByContext = bindingsValuesProvidersByContext;
        this.scriptEngineFactory = new ExporterScriptEngineFactory(bundleContext.getBundle());
        this.bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)this);
        this.bundleTracker.open();
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        String classesList;
        ArrayList<ServiceRegistration> regs = new ArrayList<ServiceRegistration>();
        Dictionary headers = bundle.getHeaders();
        String packageList = PropertiesUtil.toString(headers.get(PACKAGE_HEADER), null);
        if (packageList != null) {
            String[] packages;
            packageList = StringUtils.deleteWhitespace((String)packageList);
            for (String singlePackage : packages = packageList.split(",")) {
                Enumeration classUrls = bundle.findEntries("/" + singlePackage.replace('.', '/'), "*.class", true);
                if (classUrls == null) {
                    log.warn("No adaptable classes found in package {}, ignoring", (Object)singlePackage);
                    continue;
                }
                while (classUrls.hasMoreElements()) {
                    URL url = (URL)classUrls.nextElement();
                    String className = this.toClassName(url);
                    this.analyzeClass(bundle, className, regs);
                }
            }
        }
        if ((classesList = PropertiesUtil.toString(headers.get(CLASSES_HEADER), null)) != null) {
            String[] classes;
            classesList = StringUtils.deleteWhitespace((String)classesList);
            for (String className : classes = classesList.split(",")) {
                this.analyzeClass(bundle, className, regs);
            }
        }
        return regs.toArray(new ServiceRegistration[0]);
    }

    private void analyzeClass(Bundle bundle, String className, List<ServiceRegistration> regs) {
        try {
            Class implType = bundle.loadClass(className);
            Model annotation = implType.getAnnotation(Model.class);
            if (annotation != null) {
                Object[] adapterTypes = annotation.adapters();
                if (adapterTypes.length == 0) {
                    adapterTypes = new Class[]{implType};
                } else if (!ArrayUtils.contains((Object[])adapterTypes, (Object)implType)) {
                    adapterTypes = (Class[])ArrayUtils.add((Object[])adapterTypes, (Object)implType);
                }
                if (this.validateAdapterClasses(implType, (Class<?>[])adapterTypes) && this.adapterImplementations.addAll(implType, (Class<?>[])adapterTypes)) {
                    String[] resourceTypes;
                    ServiceRegistration reg = this.registerAdapterFactory((Class<?>[])adapterTypes, annotation.adaptables(), implType, annotation.condition());
                    regs.add(reg);
                    for (String resourceType : resourceTypes = annotation.resourceType()) {
                        if (!StringUtils.isNotEmpty((String)resourceType)) continue;
                        for (Class adaptable : annotation.adaptables()) {
                            Exporters exportersAnnotation;
                            this.adapterImplementations.registerModelToResourceType(bundle, resourceType, adaptable, implType);
                            ExportServlet.ExportedObjectAccessor accessor = null;
                            if (adaptable == Resource.class) {
                                accessor = new ExportServlet.ResourceAccessor(implType);
                            } else if (adaptable == SlingHttpServletRequest.class) {
                                accessor = new ExportServlet.RequestAccessor(implType);
                            }
                            Exporter exporterAnnotation = implType.getAnnotation(Exporter.class);
                            if (exporterAnnotation != null) {
                                this.registerExporter(bundle, implType, resourceType, exporterAnnotation, regs, accessor);
                            }
                            if ((exportersAnnotation = implType.getAnnotation(Exporters.class)) == null) continue;
                            for (Exporter ann : exportersAnnotation.value()) {
                                this.registerExporter(bundle, implType, resourceType, ann, regs, accessor);
                            }
                        }
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Unable to load class", (Throwable)e);
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (object instanceof ServiceRegistration[]) {
            for (ServiceRegistration reg : (ServiceRegistration[])object) {
                ServiceReference ref = reg.getReference();
                String[] adapterTypeNames = PropertiesUtil.toStringArray(ref.getProperty("adapters"));
                if (adapterTypeNames != null) {
                    String implTypeName = PropertiesUtil.toString(ref.getProperty(PROP_IMPLEMENTATION_CLASS), null);
                    for (String adapterTypeName : adapterTypeNames) {
                        this.adapterImplementations.remove(adapterTypeName, implTypeName);
                    }
                }
                reg.unregister();
            }
        }
        this.adapterImplementations.removeResourceTypeBindings(bundle);
    }

    public synchronized void unregisterAll() {
        this.bundleTracker.close();
    }

    private String toClassName(URL url) {
        String f = url.getFile();
        String cn = f.substring(1, f.length() - ".class".length());
        return cn.replace('/', '.');
    }

    private String[] toStringArray(Class<?>[] classes) {
        String[] arr = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            arr[i] = classes[i].getName();
        }
        return arr;
    }

    private boolean validateAdapterClasses(Class<?> clazz, Class<?>[] adapterClasses) {
        for (Class<?> adapterClass : adapterClasses) {
            if (adapterClass.isAssignableFrom(clazz)) continue;
            log.warn("Unable to register model class {} because adapter class {} is not valid.", (Object)clazz.getName(), (Object)adapterClass.getName());
            return false;
        }
        return true;
    }

    private ServiceRegistration registerAdapterFactory(Class<?>[] adapterTypes, Class<?>[] adaptableTypes, Class<?> implType, String condition) {
        Hashtable<String, Object> registrationProps = new Hashtable<String, Object>();
        ((Dictionary)registrationProps).put("adapters", this.toStringArray(adapterTypes));
        ((Dictionary)registrationProps).put("adaptables", this.toStringArray(adaptableTypes));
        ((Dictionary)registrationProps).put(PROP_IMPLEMENTATION_CLASS, implType.getName());
        if (StringUtils.isNotBlank((String)condition)) {
            ((Dictionary)registrationProps).put(PROP_ADAPTER_CONDITION, condition);
        }
        return this.bundleContext.registerService("org.apache.sling.api.adapter.AdapterFactory", (Object)this.factory, registrationProps);
    }

    private void registerExporter(Bundle bundle, Class<?> annotatedClass, String resourceType, Exporter exporterAnnotation, List<ServiceRegistration> regs, ExportServlet.ExportedObjectAccessor accessor) {
        if (accessor != null) {
            Map<String, String> baseOptions = this.getOptions(exporterAnnotation);
            ExportServlet servlet = new ExportServlet(bundle.getBundleContext(), this.factory, this.bindingsValuesProvidersByContext, this.scriptEngineFactory, annotatedClass, exporterAnnotation.selector(), exporterAnnotation.name(), accessor, baseOptions);
            Hashtable<String, Object> registrationProps = new Hashtable<String, Object>();
            ((Dictionary)registrationProps).put("sling.servlet.resourceTypes", resourceType);
            ((Dictionary)registrationProps).put("sling.servlet.selectors", exporterAnnotation.selector());
            ((Dictionary)registrationProps).put("sling.servlet.extensions", exporterAnnotation.extensions());
            ((Dictionary)registrationProps).put(PROP_EXPORTER_SERVLET_CLASS, annotatedClass.getName());
            ((Dictionary)registrationProps).put(PROP_EXPORTER_SERVLET_NAME, exporterAnnotation.name());
            log.info("registering servlet for {}, {}, {}", new Object[]{resourceType, exporterAnnotation.selector(), exporterAnnotation.extensions()});
            ServiceRegistration reg = this.bundleContext.registerService(Servlet.class.getName(), (Object)servlet, registrationProps);
            regs.add(reg);
        }
    }

    private Map<String, String> getOptions(Exporter annotation) {
        ExporterOption[] options = annotation.options();
        if (options.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(options.length);
        for (ExporterOption option : options) {
            map.put(option.name(), option.value());
        }
        return map;
    }
}

