/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.injectorspecific.ChildResource;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.impl.injectors.AbstractInjector;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory2;

@Component
@Service
@Property(name="service.ranking", intValue={3000})
public class ChildResourceInjector
extends AbstractInjector
implements Injector,
InjectAnnotationProcessorFactory2 {
    @Nonnull
    public String getName() {
        return "child-resources";
    }

    public Object getValue(@Nonnull Object adaptable, String name, @Nonnull Type declaredType, @Nonnull AnnotatedElement element, @Nonnull DisposalCallbackRegistry callbackRegistry) {
        Resource child;
        if (adaptable instanceof Resource && (child = ((Resource)adaptable).getChild(name)) != null) {
            return this.getValue(child, declaredType);
        }
        return null;
    }

    private Object getValue(Resource child, Type declaredType) {
        if (declaredType instanceof Class) {
            return child;
        }
        if (this.isDeclaredTypeCollection(declaredType)) {
            return this.getResultList(child, declaredType);
        }
        return null;
    }

    private Object getResultList(Resource resource, Type declaredType) {
        ArrayList result = new ArrayList();
        Class<?> type = this.getActualType((ParameterizedType)declaredType);
        if (type != null && resource != null) {
            Iterator children = resource.listChildren();
            while (children.hasNext()) {
                result.add(children.next());
            }
        }
        return result;
    }

    private Class<?> getActualType(ParameterizedType declaredType) {
        Type[] types = declaredType.getActualTypeArguments();
        if (types != null && types.length > 0) {
            return (Class)types[0];
        }
        return null;
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(Object adaptable, AnnotatedElement element) {
        ChildResource annotation = element.getAnnotation(ChildResource.class);
        if (annotation != null) {
            return new ChildResourceAnnotationProcessor(annotation, adaptable);
        }
        return null;
    }

    private static class ChildResourceAnnotationProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final ChildResource annotation;
        private final Object adaptable;

        public ChildResourceAnnotationProcessor(ChildResource annotation, Object adaptable) {
            this.annotation = annotation;
            this.adaptable = adaptable;
        }

        public String getName() {
            if (this.annotation.name().isEmpty()) {
                return null;
            }
            return this.annotation.name();
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }

        public String getVia() {
            if (StringUtils.isNotBlank((String)this.annotation.via())) {
                return this.annotation.via();
            }
            if (this.adaptable instanceof SlingHttpServletRequest) {
                return "resource";
            }
            return null;
        }
    }
}

