/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import javax.script.Bindings;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.models.impl.SlingModelsScriptEngineFactory;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;

class ResourceOverridingRequestWrapper
extends SlingHttpServletRequestWrapper {
    private final Resource resource;
    private final AdapterManager adapterManager;
    private final Bindings bindings;

    ResourceOverridingRequestWrapper(SlingHttpServletRequest wrappedRequest, Resource resource, AdapterManager adapterManager, SlingModelsScriptEngineFactory scriptEngineFactory, BindingsValuesProvidersByContext bindingsValuesProvidersByContext) {
        super(wrappedRequest);
        this.resource = resource;
        this.adapterManager = adapterManager;
        SlingBindings existingBindings = (SlingBindings)wrappedRequest.getAttribute(SlingBindings.class.getName());
        this.bindings = new SlingBindings();
        if (existingBindings != null) {
            this.bindings.put("sling", (Object)existingBindings.getSling());
            this.bindings.put("response", (Object)existingBindings.getResponse());
            this.bindings.put("reader", (Object)existingBindings.getReader());
            this.bindings.put("out", (Object)existingBindings.getOut());
            this.bindings.put("log", (Object)existingBindings.getLog());
        }
        this.bindings.put("request", (Object)this);
        this.bindings.put("resource", (Object)resource);
        this.bindings.put("resolver", (Object)resource.getResourceResolver());
        scriptEngineFactory.invokeBindingsValuesProviders(bindingsValuesProvidersByContext, this.bindings);
    }

    public Object getAttribute(String name) {
        if (SlingBindings.class.getName().equals(name)) {
            return this.bindings;
        }
        return super.getAttribute(name);
    }

    public Resource getResource() {
        return this.resource;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        return (AdapterType)this.adapterManager.getAdapter((Object)this, type);
    }
}

