/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.lang.constant.Constable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.ValidationStrategy;
import org.apache.sling.models.annotations.ViaProviderType;
import org.apache.sling.models.annotations.via.BeanProperty;
import org.apache.sling.models.export.spi.ModelExporter;
import org.apache.sling.models.factory.ExportException;
import org.apache.sling.models.factory.InvalidAdaptableException;
import org.apache.sling.models.factory.InvalidModelException;
import org.apache.sling.models.factory.MissingElementException;
import org.apache.sling.models.factory.MissingElementsException;
import org.apache.sling.models.factory.MissingExporterException;
import org.apache.sling.models.factory.ModelClassException;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.models.factory.PostConstructException;
import org.apache.sling.models.factory.ValidationException;
import org.apache.sling.models.impl.AdapterImplementations;
import org.apache.sling.models.impl.DisposalCallbackRegistryImpl;
import org.apache.sling.models.impl.MapBackedInvocationHandler;
import org.apache.sling.models.impl.ModelAdapterFactoryConfiguration;
import org.apache.sling.models.impl.ModelConfigurationPrinter;
import org.apache.sling.models.impl.ModelPackageBundleListener;
import org.apache.sling.models.impl.ReflectionUtil;
import org.apache.sling.models.impl.ResourceOverridingRequestWrapper;
import org.apache.sling.models.impl.Result;
import org.apache.sling.models.impl.SlingModelsScriptEngineFactory;
import org.apache.sling.models.impl.ThreadInvocationCounter;
import org.apache.sling.models.impl.injectors.OSGiServiceInjector;
import org.apache.sling.models.impl.model.ConstructorParameter;
import org.apache.sling.models.impl.model.InjectableElement;
import org.apache.sling.models.impl.model.InjectableField;
import org.apache.sling.models.impl.model.InjectableMethod;
import org.apache.sling.models.impl.model.ModelClass;
import org.apache.sling.models.impl.model.ModelClassConstructor;
import org.apache.sling.models.impl.model.OptionalTypedInjectableElement;
import org.apache.sling.models.spi.AcceptsNullName;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.ModelValidation;
import org.apache.sling.models.spi.ValuePreparer;
import org.apache.sling.models.spi.ViaProvider;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory2;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ModelFactory.class, ServletRequestListener.class}, property={"osgi.http.whiteboard.listener=true", "osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=*)"})
@Designate(ocd=ModelAdapterFactoryConfiguration.class)
public class ModelAdapterFactory
implements AdapterFactory,
Runnable,
ModelFactory,
ServletRequestListener {
    private static final int VALUE_PREPARERS_COUNT = 2;
    private static final String REQUEST_MARKER_ATTRIBUTE = ModelAdapterFactory.class.getName() + ".RealRequest";
    private static final String REQUEST_CACHE_ATTRIBUTE = ModelAdapterFactory.class.getName() + ".AdapterCache";
    private final Logger log = LoggerFactory.getLogger(ModelAdapterFactory.class);
    private ReferenceQueue<Object> queue;
    private ConcurrentMap<Reference<Object>, DisposalCallbackRegistryImpl> disposalCallbacks;
    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, fieldOption=FieldOption.REPLACE)
    volatile List<Injector> injectors;
    private final ConcurrentMap<Class<? extends ViaProviderType>, ViaProvider> viaProviders = new ConcurrentHashMap<Class<? extends ViaProviderType>, ViaProvider>();
    @org.osgi.service.component.annotations.Reference(name="injectAnnotationProcessorFactory", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    volatile Collection<InjectAnnotationProcessorFactory> injectAnnotationProcessorFactories;
    @org.osgi.service.component.annotations.Reference(name="injectAnnotationProcessorFactory2", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    volatile Collection<InjectAnnotationProcessorFactory2> injectAnnotationProcessorFactories2;
    private volatile Map<Comparable<?>, StaticInjectAnnotationProcessorFactory> staticInjectAnnotationProcessorFactories = Collections.emptyMap();
    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, fieldOption=FieldOption.REPLACE)
    volatile List<ImplementationPicker> implementationPickers;
    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private ModelValidation modelValidation;
    @org.osgi.service.component.annotations.Reference(name="modelExporter", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    volatile Collection<ModelExporter> modelExporters;
    @org.osgi.service.component.annotations.Reference
    BindingsValuesProvidersByContext bindingsValuesProvidersByContext;
    @org.osgi.service.component.annotations.Reference
    AdapterManager adapterManager;
    ModelPackageBundleListener listener;
    final AdapterImplementations adapterImplementations = new AdapterImplementations();
    private ServiceRegistration jobRegistration;
    private ServiceRegistration configPrinterRegistration;
    private ThreadLocal<ThreadInvocationCounter> invocationCountThreadLocal;
    private Map<Object, Map<Class<?>, SoftReference<Object>>> adapterCache;
    private SlingModelsScriptEngineFactory scriptEngineFactory;

    @Override
    public void run() {
        this.clearDisposalCallbackRegistryQueue();
    }

    private void clearDisposalCallbackRegistryQueue() {
        Reference<Object> ref = this.queue.poll();
        while (ref != null) {
            this.log.debug("calling disposal for {}.", ref);
            DisposalCallbackRegistryImpl registry = (DisposalCallbackRegistryImpl)this.disposalCallbacks.remove(ref);
            if (registry != null) {
                registry.onDisposed();
            }
            ref = this.queue.poll();
        }
    }

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        Result<AdapterType> result = this.internalCreateModel(adaptable, type);
        if (!result.wasSuccessful()) {
            if (result == Result.POST_CONSTRUCT_PREVENTED_MODEL_CONSTRUCTION) {
                this.log.debug("Could not adapt to model as PostConstruct method returned false");
            } else {
                this.log.warn("Could not adapt to model", (Throwable)result.getThrowable());
            }
            return null;
        }
        return result.getValue();
    }

    @NotNull
    public <ModelType> ModelType createModel(@NotNull Object adaptable, @NotNull Class<ModelType> type) throws MissingElementsException, InvalidAdaptableException, ValidationException, InvalidModelException {
        Result<ModelType> result = this.internalCreateModel(adaptable, type);
        if (!result.wasSuccessful()) {
            throw result.getThrowable();
        }
        return result.getValue();
    }

    @NotNull
    public <T> T createModelFromWrappedRequest(@NotNull SlingHttpServletRequest request, @NotNull Resource resource, @NotNull Class<T> targetClass) {
        return this.createModel((Object)new ResourceOverridingRequestWrapper(request, resource, this.adapterManager, this.scriptEngineFactory, this.bindingsValuesProvidersByContext), targetClass);
    }

    public boolean canCreateFromAdaptable(@NotNull Object adaptable, @NotNull Class<?> modelClass) throws ModelClassException {
        return this.internalCanCreateFromAdaptable(adaptable, modelClass);
    }

    private boolean internalCanCreateFromAdaptable(Object adaptable, Class<?> requestedType) throws ModelClassException {
        try {
            Class[] declaredAdaptable;
            ModelClass<?> modelClass = this.getImplementationTypeForAdapterType(requestedType, adaptable);
            for (Class clazz : declaredAdaptable = modelClass.getModelAnnotation().adaptables()) {
                if (!clazz.isInstance(adaptable)) continue;
                return true;
            }
        }
        catch (ModelClassException e) {
            this.log.debug("Could not find implementation for given type " + requestedType + ". Probably forgot either the model annotation or it was not registered as adapter factory (yet)", (Throwable)e);
            return false;
        }
        return false;
    }

    @Deprecated
    public boolean isModelClass(@NotNull Object adaptable, @NotNull Class<?> requestedType) {
        try {
            this.getImplementationTypeForAdapterType(requestedType, adaptable);
        }
        catch (ModelClassException e) {
            this.log.debug("Could not find implementation for given adaptable. Probably forgot either the model annotation or it was not registered as adapter factory (yet)", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isModelClass(@NotNull Class<?> type) {
        return this.adapterImplementations.isModelClass(type);
    }

    private <ModelType> ModelClass<ModelType> getImplementationTypeForAdapterType(Class<ModelType> requestedType, Object adaptable) {
        ModelClass<ModelType> modelClass = this.adapterImplementations.lookup(requestedType, adaptable, this.implementationPickers);
        if (modelClass != null) {
            this.log.debug("Using implementation type {} for requested adapter type {}", modelClass, requestedType);
            return modelClass;
        }
        throw new ModelClassException("Could not yet find an adapter factory for the model " + requestedType + " from adaptable " + adaptable.getClass());
    }

    private Map<Class<?>, SoftReference<Object>> getOrCreateCache(Object adaptable) {
        Map adaptableCache;
        if (adaptable instanceof ServletRequest) {
            ServletRequest request = (ServletRequest)adaptable;
            adaptableCache = (Map)request.getAttribute(REQUEST_CACHE_ATTRIBUTE);
            if (adaptableCache == null) {
                adaptableCache = Collections.synchronizedMap(new WeakHashMap());
                request.setAttribute(REQUEST_CACHE_ATTRIBUTE, adaptableCache);
            }
        } else {
            adaptableCache = this.adapterCache.computeIfAbsent(adaptable, k -> Collections.synchronizedMap(new WeakHashMap()));
        }
        return adaptableCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <ModelType> Result<ModelType> internalCreateModel(Object adaptable, Class<ModelType> requestedType) {
        ThreadInvocationCounter threadInvocationCounter = this.invocationCountThreadLocal.get();
        if (threadInvocationCounter.isMaximumReached()) {
            String msg = String.format("Adapting %s to %s failed, too much recursive invocations (>=%s).", adaptable, requestedType, threadInvocationCounter.maxRecursionDepth);
            return new Result((RuntimeException)((Object)new ModelClassException(msg)));
        }
        threadInvocationCounter.increase();
        try {
            Result<Object> result;
            Object[] declaredAdaptable;
            Object result7;
            SoftReference<Object> softReference;
            ModelClass<ModelType> modelClass = this.getImplementationTypeForAdapterType(requestedType, adaptable);
            if (!modelClass.hasModelAnnotation()) {
                String msg = String.format("Provided Adapter class does not have a Model annotation: %s", modelClass.getType());
                Result result2 = new Result((RuntimeException)((Object)new ModelClassException(msg)));
                return result2;
            }
            boolean isAdaptable = false;
            Model modelAnnotation = modelClass.getModelAnnotation();
            Map<Class<?>, SoftReference<Object>> adaptableCache = null;
            if (modelAnnotation.cache() && (softReference = (adaptableCache = this.getOrCreateCache(adaptable)).get(modelClass.getType())) != null && (result7 = softReference.get()) != null) {
                Result<Object> result2 = new Result<Object>(result7);
                return result2;
            }
            for (Class clazz : declaredAdaptable = modelAnnotation.adaptables()) {
                if (!clazz.isInstance(adaptable)) continue;
                isAdaptable = true;
            }
            if (!isAdaptable) {
                String string = String.format("Given adaptable (%s) is not acceptable for the model class: %s which only supports adaptables %s", adaptable.getClass(), modelClass.getType(), StringUtils.join((Object[])declaredAdaptable));
                Result result3 = new Result((RuntimeException)new InvalidAdaptableException(string));
                return result3;
            }
            RuntimeException runtimeException = this.validateModel(adaptable, modelClass.getType(), modelAnnotation);
            if (runtimeException != null) {
                Result result4 = new Result(runtimeException);
                return result4;
            }
            if (modelClass.getType().isInterface()) {
                Object model22;
                Result<InvocationHandler> handlerResult = this.createInvocationHandler(adaptable, modelClass);
                if (handlerResult.wasSuccessful()) {
                    model22 = Proxy.newProxyInstance(modelClass.getType().getClassLoader(), new Class[]{modelClass.getType()}, handlerResult.getValue());
                    if (modelAnnotation.cache() && adaptableCache != null) {
                        adaptableCache.put(modelClass.getType(), new SoftReference<Object>(model22));
                    }
                } else {
                    Result model22 = new Result(handlerResult.getThrowable());
                    return model22;
                }
                result = new Result<Object>(model22);
            } else {
                try {
                    result = this.createObject(adaptable, modelClass);
                    if (result.wasSuccessful() && modelAnnotation.cache() && adaptableCache != null) {
                        adaptableCache.put(modelClass.getType(), new SoftReference<ModelType>(result.getValue()));
                    }
                }
                catch (Exception e) {
                    String msg = String.format("Unable to create model %s", modelClass.getType());
                    Result result5 = new Result((RuntimeException)((Object)new ModelClassException(msg, (Throwable)e)));
                    threadInvocationCounter.decrease();
                    return result5;
                }
            }
            Result<ModelType> result6 = result;
            return result6;
        }
        finally {
            threadInvocationCounter.decrease();
        }
    }

    private <ModelType> RuntimeException validateModel(Object adaptable, Class<ModelType> modelType, Model modelAnnotation) {
        if (modelAnnotation.validation() != ValidationStrategy.DISABLED) {
            if (this.modelValidation == null) {
                return new ValidationException("No active service for ModelValidation found, therefore no validation can be performed.");
            }
            return this.modelValidation.validate(adaptable, modelType, modelAnnotation.validation() == ValidationStrategy.REQUIRED);
        }
        return null;
    }

    @Nullable
    private RuntimeException injectElement(InjectableElement element, Object adaptable, @NotNull DisposalCallbackRegistry registry, InjectCallback callback, @NotNull Map<ValuePreparer, Object> preparedValues, @Nullable BundleContext modelContext) {
        ParameterizedType pType;
        Type genericType;
        if (element instanceof InjectableField && (genericType = ((InjectableField)element).getFieldGenericType()) instanceof ParameterizedType && (pType = (ParameterizedType)genericType).getRawType().equals(Optional.class)) {
            OptionalTypedInjectableElement el = new OptionalTypedInjectableElement(element, pType.getActualTypeArguments()[0]);
            OptionalWrappingCallback wrappedCallback = new OptionalWrappingCallback(callback, element);
            return this.injectElementInternal(el, adaptable, registry, wrappedCallback, preparedValues, modelContext);
        }
        return this.injectElementInternal(element, adaptable, registry, callback, preparedValues, modelContext);
    }

    @Nullable
    private RuntimeException injectElementInternal(InjectableElement element, Object adaptable, @NotNull DisposalCallbackRegistry registry, InjectCallback callback, @NotNull Map<ValuePreparer, Object> preparedValues, @Nullable BundleContext modelContext) {
        InjectAnnotationProcessorFactory2 factory;
        InjectAnnotationProcessor2 annotationProcessor = null;
        String source = element.getSource();
        boolean wasInjectionSuccessful = false;
        Iterator<InjectAnnotationProcessorFactory2> iterator = this.injectAnnotationProcessorFactories2.iterator();
        while (iterator.hasNext() && (annotationProcessor = (factory = iterator.next()).createAnnotationProcessor(adaptable, element.getAnnotatedElement())) == null) {
        }
        if (annotationProcessor == null) {
            iterator = this.injectAnnotationProcessorFactories.iterator();
            while (iterator.hasNext() && (annotationProcessor = (factory = (InjectAnnotationProcessorFactory)iterator.next()).createAnnotationProcessor(adaptable, element.getAnnotatedElement())) == null) {
            }
        }
        String name = this.getName(element, (InjectAnnotationProcessor)annotationProcessor);
        Object injectionAdaptable = this.getAdaptable(adaptable, element, (InjectAnnotationProcessor)annotationProcessor);
        Throwable lastInjectionException = null;
        if (injectionAdaptable != null) {
            if (StringUtils.isEmpty((CharSequence)source)) {
                source = null;
            }
            boolean foundSource = false;
            for (Injector injector : this.injectors) {
                if (source != null && !source.equals(injector.getName())) continue;
                foundSource = true;
                if (name == null && !(injector instanceof AcceptsNullName)) continue;
                Object preparedValue = injectionAdaptable;
                if (injector instanceof ValuePreparer && adaptable == injectionAdaptable) {
                    ValuePreparer preparer = (ValuePreparer)injector;
                    Object fromMap = preparedValues.get(preparer);
                    if (fromMap != null) {
                        preparedValue = fromMap;
                    } else {
                        preparedValue = preparer.prepareValue(injectionAdaptable);
                        preparedValues.put(preparer, preparedValue);
                    }
                }
                Object value = null;
                value = injector instanceof OSGiServiceInjector ? ((OSGiServiceInjector)injector).getValue(preparedValue, name, element.getType(), element.getAnnotatedElement(), registry, modelContext) : injector.getValue(preparedValue, name, element.getType(), element.getAnnotatedElement(), registry);
                if (value == null || (lastInjectionException = callback.inject(element, value)) != null) continue;
                wasInjectionSuccessful = true;
                break;
            }
            if (!foundSource && source != null) {
                throw new IllegalArgumentException("No Sling Models Injector registered for source '" + source + "'.");
            }
        }
        if (!wasInjectionSuccessful) {
            Result<Boolean> defaultInjectionResult = this.injectDefaultValue(element, (InjectAnnotationProcessor)annotationProcessor, callback);
            if (defaultInjectionResult.wasSuccessful()) {
                wasInjectionSuccessful = defaultInjectionResult.getValue();
                if (lastInjectionException != null && wasInjectionSuccessful) {
                    this.log.debug("Although falling back to default value worked, injection into {} failed because of: " + lastInjectionException.getMessage(), (Object)element.getAnnotatedElement(), (Object)lastInjectionException);
                }
            } else {
                return defaultInjectionResult.getThrowable();
            }
        }
        if (!wasInjectionSuccessful) {
            if (element.isOptional((InjectAnnotationProcessor)annotationProcessor)) {
                RuntimeException throwable;
                if (lastInjectionException != null) {
                    this.log.debug("Injection into optional element {} failed because of: " + lastInjectionException.getMessage(), (Object)element.getAnnotatedElement(), (Object)lastInjectionException);
                }
                if (element.isPrimitive() && (throwable = this.injectPrimitiveInitialValue(element, callback)) != null) {
                    return throwable;
                }
            } else {
                if (lastInjectionException != null) {
                    return lastInjectionException;
                }
                return new ModelClassException("No injector returned a non-null value!");
            }
        }
        return null;
    }

    private BundleContext getModelBundleContext(ModelClass<?> modelClass) {
        Bundle modelBundle = FrameworkUtil.getBundle(modelClass.getType());
        if (modelBundle != null) {
            return modelBundle.getBundleContext();
        }
        return null;
    }

    private <ModelType> Result<InvocationHandler> createInvocationHandler(Object adaptable, ModelClass<ModelType> modelClass) {
        InjectableMethod[] injectableMethods = modelClass.getInjectableMethods();
        HashMap<Method, Object> methods = new HashMap<Method, Object>();
        SetMethodsCallback callback = new SetMethodsCallback(methods);
        MapBackedInvocationHandler handler = new MapBackedInvocationHandler(methods);
        DisposalCallbackRegistryImpl registry = new DisposalCallbackRegistryImpl();
        HashMap<ValuePreparer, Object> preparedValues = new HashMap<ValuePreparer, Object>(2);
        ArrayList<MissingElementException> missingElements = null;
        BundleContext modelContext = this.getModelBundleContext(modelClass);
        for (InjectableMethod method : injectableMethods) {
            RuntimeException t = this.injectElement(method, adaptable, registry, callback, preparedValues, modelContext);
            if (t == null) continue;
            if (missingElements == null) {
                missingElements = new ArrayList<MissingElementException>();
            }
            missingElements.add(new MissingElementException(method.getAnnotatedElement(), (Throwable)t));
        }
        this.registerCallbackRegistry(registry, adaptable, handler);
        if (missingElements != null) {
            MissingElementsException missingElementsException = new MissingElementsException("Could not create all mandatory methods for interface of model " + modelClass);
            for (MissingElementException me : missingElements) {
                missingElementsException.addMissingElementExceptions(me);
            }
            return new Result<InvocationHandler>((RuntimeException)missingElementsException);
        }
        return new Result<InvocationHandler>(handler);
    }

    private <ModelType> Result<ModelType> createObject(Object adaptable, ModelClass<ModelType> modelClass) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        ModelType object;
        DisposalCallbackRegistryImpl registry = new DisposalCallbackRegistryImpl();
        ModelClassConstructor<ModelType> constructorToUse = this.getBestMatchingConstructor(adaptable, modelClass);
        if (constructorToUse == null) {
            return new Result((RuntimeException)((Object)new ModelClassException("Unable to find a useable constructor for model " + modelClass.getType())));
        }
        HashMap<ValuePreparer, Object> preparedValues = new HashMap<ValuePreparer, Object>(2);
        if (constructorToUse.getConstructor().getParameterTypes().length == 0) {
            object = constructorToUse.newInstance(new Object[0]);
        } else {
            try {
                Result<ModelType> result = this.newInstanceWithConstructorInjection(constructorToUse, adaptable, modelClass, registry, preparedValues);
                if (!result.wasSuccessful()) {
                    registry.onDisposed();
                    return result;
                }
                object = result.getValue();
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                registry.onDisposed();
                throw ex;
            }
        }
        SetFieldCallback callback = new SetFieldCallback(object);
        InjectableField[] injectableFields = modelClass.getInjectableFields();
        ArrayList<MissingElementException> missingElements = null;
        BundleContext modelContext = this.getModelBundleContext(modelClass);
        for (InjectableField field : injectableFields) {
            RuntimeException t = this.injectElement(field, adaptable, registry, callback, preparedValues, modelContext);
            if (t == null) continue;
            if (missingElements == null) {
                missingElements = new ArrayList<MissingElementException>();
            }
            missingElements.add(new MissingElementException(field.getAnnotatedElement(), (Throwable)t));
        }
        this.registerCallbackRegistry(registry, adaptable, object);
        if (missingElements != null) {
            MissingElementsException missingElementsException = new MissingElementsException("Could not inject all required fields into " + modelClass.getType());
            for (MissingElementException me : missingElements) {
                missingElementsException.addMissingElementExceptions(me);
            }
            return new Result((RuntimeException)missingElementsException);
        }
        try {
            object = this.invokePostConstruct(object);
            if (object == null) {
                return Result.POST_CONSTRUCT_PREVENTED_MODEL_CONSTRUCTION;
            }
        }
        catch (InvocationTargetException e) {
            return new Result((RuntimeException)new PostConstructException("Post-construct method has thrown an exception for model " + modelClass.getType(), e.getCause()));
        }
        catch (IllegalAccessException e) {
            new Result((RuntimeException)((Object)new ModelClassException("Could not call post-construct method for model " + modelClass.getType(), (Throwable)e)));
        }
        return new Result<ModelType>(object);
    }

    private <ModelType> ModelClassConstructor<ModelType> getBestMatchingConstructor(Object adaptable, ModelClass<ModelType> type) {
        ModelClassConstructor<ModelType>[] constructors;
        for (ModelClassConstructor<ModelType> constructor : constructors = type.getConstructors()) {
            Class<?> paramType;
            if (constructor.hasInjectAnnotation()) {
                return constructor;
            }
            if (constructor.isCanonicalRecordConstructor()) {
                return constructor;
            }
            Class<?>[] paramTypes = constructor.getConstructor().getParameterTypes();
            if (paramTypes.length == 1 && (paramType = constructor.getConstructor().getParameterTypes()[0]).isInstance(adaptable)) {
                return constructor;
            }
            if (constructor.getConstructor().getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private <ModelType> Result<ModelType> newInstanceWithConstructorInjection(ModelClassConstructor<ModelType> constructor, Object adaptable, ModelClass<ModelType> modelClass, DisposalCallbackRegistry registry, @NotNull Map<ValuePreparer, Object> preparedValues) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        ConstructorParameter[] parameters = constructor.getConstructorParameters();
        ArrayList<Object> paramValues = new ArrayList<Object>(Arrays.asList(new Object[parameters.length]));
        SetConstructorParameterCallback callback = new SetConstructorParameterCallback(paramValues);
        BundleContext modelContext = this.getModelBundleContext(modelClass);
        ArrayList<MissingElementException> missingElements = null;
        for (int i = 0; i < parameters.length; ++i) {
            RuntimeException t = this.injectElement(parameters[i], adaptable, registry, callback, preparedValues, modelContext);
            if (t == null) continue;
            if (missingElements == null) {
                missingElements = new ArrayList<MissingElementException>();
            }
            missingElements.add(new MissingElementException(parameters[i].getAnnotatedElement(), (Throwable)t));
        }
        if (missingElements != null) {
            MissingElementsException missingElementsException = new MissingElementsException("Required constructor parameters were not able to be injected on model " + modelClass.getType());
            for (MissingElementException me : missingElements) {
                missingElementsException.addMissingElementExceptions(me);
            }
            return new Result((RuntimeException)missingElementsException);
        }
        return new Result<ModelType>(constructor.newInstance(paramValues.toArray(new Object[paramValues.size()])));
    }

    private Result<Boolean> injectDefaultValue(InjectableElement point, InjectAnnotationProcessor processor, InjectCallback callback) {
        if (processor != null && processor.hasDefault()) {
            RuntimeException t = callback.inject(point, processor.getDefault());
            if (t == null) {
                return new Result<Boolean>(Boolean.TRUE);
            }
            return new Result<Boolean>(t);
        }
        Object value = point.getDefaultValue();
        if (value != null) {
            RuntimeException t = callback.inject(point, value);
            if (t == null) {
                return new Result<Boolean>(Boolean.TRUE);
            }
            return new Result<Boolean>(t);
        }
        return new Result<Boolean>(Boolean.FALSE);
    }

    private RuntimeException injectPrimitiveInitialValue(InjectableElement point, InjectCallback callback) {
        Type primitiveType = ReflectionUtil.mapWrapperClasses(point.getType());
        Constable value = null;
        if (primitiveType == Integer.TYPE) {
            value = 0;
        } else if (primitiveType == Long.TYPE) {
            value = 0L;
        } else if (primitiveType == Boolean.TYPE) {
            value = Boolean.FALSE;
        } else if (primitiveType == Double.TYPE) {
            value = 0.0;
        } else if (primitiveType == Float.TYPE) {
            value = Float.valueOf(0.0f);
        } else if (primitiveType == Short.TYPE) {
            value = (short)0;
        } else if (primitiveType == Byte.TYPE) {
            value = (byte)0;
        } else if (primitiveType == Character.TYPE) {
            value = Character.valueOf('\u0000');
        }
        if (value != null) {
            return callback.inject(point, value);
        }
        return new ModelClassException(String.format("Unknown primitive type %s", primitiveType.toString()));
    }

    private Object getAdaptable(Object adaptable, InjectableElement point, InjectAnnotationProcessor processor) {
        String viaValue = null;
        Class<BeanProperty> viaProviderType = null;
        if (processor != null) {
            viaValue = processor.getVia();
            viaProviderType = BeanProperty.class;
        }
        if (StringUtils.isBlank(viaValue)) {
            viaValue = point.getVia();
            viaProviderType = point.getViaProviderType();
        }
        if (viaProviderType == null || viaValue == null) {
            return adaptable;
        }
        ViaProvider viaProvider = (ViaProvider)this.viaProviders.get(viaProviderType);
        if (viaProvider == null) {
            this.log.error("Unable to find Via provider type {}.", viaProviderType);
            return null;
        }
        Object viaResult = viaProvider.getAdaptable(adaptable, viaValue);
        if (viaResult == ViaProvider.ORIGINAL) {
            return adaptable;
        }
        return viaResult;
    }

    private String getName(InjectableElement element, InjectAnnotationProcessor processor) {
        String name;
        if (processor != null && (name = processor.getName()) != null) {
            return name;
        }
        return element.getName();
    }

    private boolean addMethodIfNotOverriden(List<Method> methods, Method newMethod) {
        for (Method method : methods) {
            if (!method.getName().equals(newMethod.getName()) || !Arrays.equals(method.getParameterTypes(), newMethod.getParameterTypes())) continue;
            return false;
        }
        methods.add(newMethod);
        return true;
    }

    private <ModelType> ModelType invokePostConstruct(ModelType object) throws InvocationTargetException, IllegalAccessException {
        ArrayList<Method> postConstructMethods = new ArrayList<Method>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PostConstruct.class)) continue;
                this.addMethodIfNotOverriden(postConstructMethods, method);
            }
        }
        Collections.reverse(postConstructMethods);
        for (Method method : postConstructMethods) {
            method.setAccessible(true);
            Object result = method.invoke(object, new Object[0]);
            if (!(result instanceof Boolean) || ((Boolean)result).booleanValue()) continue;
            this.log.debug("PostConstruct method {}.{} returned false. Returning null model.", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return null;
        }
        return object;
    }

    private RuntimeException setField(InjectableField injectableField, Object createdObject, Object value) {
        Result<Object> result = this.adaptIfNecessary(value, injectableField.getFieldType(), injectableField.getFieldGenericType());
        if (result.wasSuccessful()) {
            return injectableField.set(createdObject, result);
        }
        return result.getThrowable();
    }

    private RuntimeException setMethod(InjectableMethod injectableMethod, Map<Method, Object> methods, Object value) {
        Method method = injectableMethod.getMethod();
        Result<Object> result = this.adaptIfNecessary(value, method.getReturnType(), method.getGenericReturnType());
        if (result.wasSuccessful()) {
            methods.put(method, result.getValue());
            return null;
        }
        return result.getThrowable();
    }

    private RuntimeException setConstructorParameter(ConstructorParameter constructorParameter, List<Object> parameterValues, Object value) {
        if (constructorParameter.getParameterType() instanceof Class) {
            Result<Object> result = this.adaptIfNecessary(value, (Class)constructorParameter.getParameterType(), constructorParameter.getType());
            if (result.wasSuccessful()) {
                parameterValues.set(constructorParameter.getParameterIndex(), result.getValue());
                return null;
            }
            return result.getThrowable();
        }
        return new ModelClassException(String.format("Constructor parameter with index %d is not a class!", constructorParameter.getParameterIndex()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result<Object> adaptIfNecessary(Object value, Class<?> type, Type genericType) {
        if (ModelAdapterFactory.isAcceptableType(type, genericType, value)) return new Result<Object>(value);
        if (!(genericType instanceof ParameterizedType)) return this.adapt(value, type, false);
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        if (!(value instanceof Collection) || !type.equals(Collection.class) && !type.equals(List.class) || parameterizedType.getActualTypeArguments().length != 1) return new Result<Object>((RuntimeException)((Object)new ModelClassException(String.format("%s is neither a parameterized Collection or List", type))));
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object valueObject : (Collection)value) {
            Result<Object> singleValueResult = this.adapt(valueObject, (Class)parameterizedType.getActualTypeArguments()[0], true);
            if (!singleValueResult.wasSuccessful()) return singleValueResult;
            result.add(singleValueResult.getValue());
        }
        ArrayList<Object> adaptedValue = result;
        return new Result<Object>(adaptedValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private Result<Object> adapt(Object value, Class<?> type, boolean isWithinCollection) {
        String messageSuffix;
        Object adaptedValue = null;
        String string = messageSuffix = isWithinCollection ? " in collection" : "";
        if (this.isModelClass(type) && this.canCreateFromAdaptable(value, type)) {
            Result<?> result = this.internalCreateModel(value, type);
            if (!result.wasSuccessful()) return new Result<Object>((RuntimeException)((Object)new ModelClassException(String.format("Could not create model from %s: %s%s", value.getClass(), result.getThrowable().getMessage(), messageSuffix), (Throwable)result.getThrowable())));
            adaptedValue = result.getValue();
        } else if (value instanceof Adaptable && (adaptedValue = ((Adaptable)value).adaptTo(type)) == null) {
            return new Result<Object>((RuntimeException)((Object)new ModelClassException(String.format("Could not adapt from %s to %s%s", value.getClass(), type, messageSuffix))));
        }
        if (adaptedValue == null) return new Result<Object>((RuntimeException)((Object)new ModelClassException(String.format("Could not adapt from %s to %s%s, because this class is not adaptable!", value.getClass(), type, messageSuffix))));
        return new Result<Object>(adaptedValue);
    }

    private static boolean isAcceptableType(Class<?> type, Type genericType, Object value) {
        if (type.isInstance(value)) {
            if ((type == Collection.class || type == List.class) && genericType instanceof ParameterizedType && value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                if (!it.hasNext()) {
                    return true;
                }
                Class<?> actualComponentType = it.next().getClass();
                Class desiredComponentType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                return desiredComponentType.isAssignableFrom(actualComponentType);
            }
            return true;
        }
        if (type == Integer.TYPE) {
            return Integer.class.isInstance(value);
        }
        if (type == Long.TYPE) {
            return Long.class.isInstance(value);
        }
        if (type == Boolean.TYPE) {
            return Boolean.class.isInstance(value);
        }
        if (type == Double.TYPE) {
            return Double.class.isInstance(value);
        }
        if (type == Float.TYPE) {
            return Float.class.isInstance(value);
        }
        if (type == Short.TYPE) {
            return Short.class.isInstance(value);
        }
        if (type == Byte.TYPE) {
            return Byte.class.isInstance(value);
        }
        if (type == Character.TYPE) {
            return Character.class.isInstance(value);
        }
        return false;
    }

    @Activate
    protected void activate(ComponentContext ctx, final ModelAdapterFactoryConfiguration configuration) {
        this.invocationCountThreadLocal = new ThreadLocal<ThreadInvocationCounter>(){

            @Override
            protected ThreadInvocationCounter initialValue() {
                return new ThreadInvocationCounter(configuration.max_recursion_depth());
            }
        };
        this.adapterCache = Collections.synchronizedMap(new WeakHashMap());
        BundleContext bundleContext = ctx.getBundleContext();
        this.queue = new ReferenceQueue();
        this.disposalCallbacks = new ConcurrentHashMap<Reference<Object>, DisposalCallbackRegistryImpl>();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("service.vendor", "Apache Software Foundation");
        properties.put("service.description", "Sling Models OSGi Service Disposal Job");
        properties.put("scheduler.name", "Sling Models OSGi Service Disposal Job");
        properties.put("scheduler.concurrent", false);
        properties.put("scheduler.period", configuration.cleanup_job_period());
        this.jobRegistration = bundleContext.registerService(Runnable.class, (Object)this, properties);
        this.scriptEngineFactory = new SlingModelsScriptEngineFactory(bundleContext.getBundle());
        this.listener = new ModelPackageBundleListener(ctx.getBundleContext(), this, this.adapterImplementations, this.bindingsValuesProvidersByContext, this.scriptEngineFactory);
        Hashtable<String, String> printerProps = new Hashtable<String, String>();
        printerProps.put("service.vendor", "Apache Software Foundation");
        printerProps.put("service.description", "Sling Models Configuration Printer");
        printerProps.put("felix.webconsole.label", "slingmodels");
        printerProps.put("felix.webconsole.title", "Sling Models");
        printerProps.put("felix.webconsole.configprinter.modes", "always");
        this.configPrinterRegistration = bundleContext.registerService(Object.class, (Object)new ModelConfigurationPrinter(this, bundleContext, this.adapterImplementations), printerProps);
    }

    @Deactivate
    protected void deactivate() {
        this.adapterCache = null;
        this.clearDisposalCallbackRegistryQueue();
        this.listener.unregisterAll();
        this.adapterImplementations.removeAll();
        if (this.jobRegistration != null) {
            this.jobRegistration.unregister();
            this.jobRegistration = null;
        }
        if (this.configPrinterRegistration != null) {
            this.configPrinterRegistration.unregister();
            this.configPrinterRegistration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindStaticInjectAnnotationProcessorFactory(StaticInjectAnnotationProcessorFactory factory, Map<String, Object> props) {
        ModelAdapterFactory modelAdapterFactory = this;
        synchronized (modelAdapterFactory) {
            TreeMap factoryMap = new TreeMap(this.staticInjectAnnotationProcessorFactories);
            factoryMap.put((Comparable)((Object)props), factory);
            this.staticInjectAnnotationProcessorFactories = factoryMap;
            this.adapterImplementations.setStaticInjectAnnotationProcessorFactories(this.staticInjectAnnotationProcessorFactories.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindStaticInjectAnnotationProcessorFactory(StaticInjectAnnotationProcessorFactory factory, Map<String, Object> props) {
        ModelAdapterFactory modelAdapterFactory = this;
        synchronized (modelAdapterFactory) {
            TreeMap factoryMap = new TreeMap(this.staticInjectAnnotationProcessorFactories);
            factoryMap.remove(props);
            this.staticInjectAnnotationProcessorFactories = factoryMap;
            this.adapterImplementations.setStaticInjectAnnotationProcessorFactories(this.staticInjectAnnotationProcessorFactories.values());
        }
    }

    @org.osgi.service.component.annotations.Reference(name="viaProvider", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindViaProvider(ViaProvider viaProvider, Map<String, Object> props) {
        Class type = viaProvider.getType();
        this.viaProviders.put(type, viaProvider);
    }

    protected void unbindViaProvider(ViaProvider viaProvider, Map<String, Object> props) {
        Class type = viaProvider.getType();
        this.viaProviders.remove(type, viaProvider);
    }

    @NotNull
    Collection<Injector> getInjectors() {
        return this.injectors;
    }

    @NotNull
    Collection<InjectAnnotationProcessorFactory> getInjectAnnotationProcessorFactories() {
        return this.injectAnnotationProcessorFactories;
    }

    @NotNull
    Collection<InjectAnnotationProcessorFactory2> getInjectAnnotationProcessorFactories2() {
        return this.injectAnnotationProcessorFactories2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Collection<StaticInjectAnnotationProcessorFactory> getStaticInjectAnnotationProcessorFactories() {
        ModelAdapterFactory modelAdapterFactory = this;
        synchronized (modelAdapterFactory) {
            return new ArrayList<StaticInjectAnnotationProcessorFactory>(this.staticInjectAnnotationProcessorFactories.values());
        }
    }

    @NotNull
    List<ImplementationPicker> getImplementationPickers() {
        return this.implementationPickers;
    }

    @NotNull
    Map<Class<? extends ViaProviderType>, ViaProvider> getViaProviders() {
        return this.viaProviders;
    }

    public boolean isModelAvailableForRequest(@NotNull SlingHttpServletRequest request) {
        return this.adapterImplementations.getModelClassForRequest(request) != null;
    }

    public boolean isModelAvailableForResource(@NotNull Resource resource) {
        return this.adapterImplementations.getModelClassForResource(resource) != null;
    }

    public Object getModelFromResource(@NotNull Resource resource) {
        Class<?> clazz = this.adapterImplementations.getModelClassForResource(resource);
        if (clazz == null) {
            throw new ModelClassException("Could find model registered for resource type: " + resource.getResourceType());
        }
        return this.handleBoundModelResult(this.internalCreateModel(resource, clazz));
    }

    public Object getModelFromRequest(@NotNull SlingHttpServletRequest request) {
        Class<?> clazz = this.adapterImplementations.getModelClassForRequest(request);
        if (clazz == null) {
            throw new ModelClassException("Could find model registered for request path: " + request.getServletPath());
        }
        return this.handleBoundModelResult(this.internalCreateModel(request, clazz));
    }

    private Object handleBoundModelResult(Result<?> result) {
        if (!result.wasSuccessful()) {
            throw result.getThrowable();
        }
        return result.getValue();
    }

    public <T> T exportModel(Object model, String name, Class<T> targetClass, Map<String, String> options) throws ExportException, MissingExporterException {
        for (ModelExporter exporter : this.modelExporters) {
            if (!exporter.getName().equals(name) || !exporter.isSupported(targetClass)) continue;
            Object resultObject = exporter.export(model, targetClass, options);
            return (T)resultObject;
        }
        throw new MissingExporterException(name, targetClass);
    }

    public <T> T exportModelForResource(Resource resource, String name, Class<T> targetClass, Map<String, String> options) throws ExportException, MissingExporterException {
        Class<?> clazz = this.adapterImplementations.getModelClassForResource(resource);
        if (clazz == null) {
            throw new ModelClassException("Could find model registered for resource type: " + resource.getResourceType());
        }
        Result<?> result = this.internalCreateModel(resource, clazz);
        return this.handleAndExportResult(result, name, targetClass, options);
    }

    public <T> T exportModelForRequest(SlingHttpServletRequest request, String name, Class<T> targetClass, Map<String, String> options) throws ExportException, MissingExporterException {
        Class<?> clazz = this.adapterImplementations.getModelClassForRequest(request);
        if (clazz == null) {
            throw new ModelClassException("Could find model registered for request path: " + request.getServletPath());
        }
        Result<?> result = this.internalCreateModel(request, clazz);
        return this.handleAndExportResult(result, name, targetClass, options);
    }

    protected <T> T handleAndExportResult(Result<?> result, String name, Class<T> targetClass, Map<String, String> options) throws ExportException, MissingExporterException {
        if (result.wasSuccessful()) {
            return this.exportModel(result.getValue(), name, targetClass, options);
        }
        throw result.getThrowable();
    }

    public <T> T getModelFromWrappedRequest(@NotNull SlingHttpServletRequest request, @NotNull Resource resource, @NotNull Class<T> targetClass) {
        return new ResourceOverridingRequestWrapper(request, resource, this.adapterManager, this.scriptEngineFactory, this.bindingsValuesProvidersByContext).adaptTo(targetClass);
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        Object list = sre.getServletRequest().getAttribute(REQUEST_MARKER_ATTRIBUTE);
        if (list != null) {
            sre.getServletRequest().removeAttribute(REQUEST_MARKER_ATTRIBUTE);
            if (list instanceof List) {
                List callbackList = (List)list;
                for (Object disposable : callbackList) {
                    if (!(disposable instanceof DisposalCallbackRegistryImpl)) continue;
                    ((DisposalCallbackRegistryImpl)disposable).onDisposed();
                }
                callbackList.clear();
            }
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
        sre.getServletRequest().setAttribute(REQUEST_MARKER_ATTRIBUTE, new ArrayList());
    }

    private void registerCallbackRegistry(DisposalCallbackRegistryImpl registry, Object adaptable, Object handler) {
        if (!registry.callbacks.isEmpty()) {
            Object list;
            registry.seal();
            boolean registered = false;
            if (adaptable instanceof SlingHttpServletRequest && (list = ((SlingHttpServletRequest)adaptable).getAttribute(REQUEST_MARKER_ATTRIBUTE)) instanceof List) {
                ((List)list).add(registry);
                registered = true;
            }
            if (!registered) {
                PhantomReference<Object> reference = new PhantomReference<Object>(handler, this.queue);
                this.disposalCallbacks.put(reference, registry);
            }
        }
    }

    private class OptionalWrappingCallback
    implements InjectCallback {
        private final InjectCallback chainedCallback;
        private final InjectableElement element;

        private OptionalWrappingCallback(InjectCallback chainedCallback, InjectableElement element) {
            this.chainedCallback = chainedCallback;
            this.element = element;
        }

        @Override
        public RuntimeException inject(InjectableElement element1, Object value) {
            return this.chainedCallback.inject(this.element, ((Object)value).equals(Optional.empty()) ? value : Optional.of(value));
        }
    }

    private static interface InjectCallback {
        public RuntimeException inject(InjectableElement var1, Object var2);
    }

    private class SetMethodsCallback
    implements InjectCallback {
        private final Map<Method, Object> methods;

        private SetMethodsCallback(Map<Method, Object> methods) {
            this.methods = methods;
        }

        @Override
        public RuntimeException inject(InjectableElement element, Object value) {
            return ModelAdapterFactory.this.setMethod((InjectableMethod)element, this.methods, value);
        }
    }

    private class SetFieldCallback
    implements InjectCallback {
        private final Object object;

        private SetFieldCallback(Object object) {
            this.object = object;
        }

        @Override
        public RuntimeException inject(InjectableElement element, Object value) {
            return ModelAdapterFactory.this.setField((InjectableField)element, this.object, value);
        }
    }

    private class SetConstructorParameterCallback
    implements InjectCallback {
        private final List<Object> parameterValues;

        private SetConstructorParameterCallback(List<Object> parameterValues) {
            this.parameterValues = parameterValues;
        }

        @Override
        public RuntimeException inject(InjectableElement element, Object value) {
            return ModelAdapterFactory.this.setConstructorParameter((ConstructorParameter)element, this.parameterValues, value);
        }
    }
}

