/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Path;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ResourcePath;
import org.apache.sling.models.impl.injectors.AbstractInjector;
import org.apache.sling.models.spi.AcceptsNullName;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.ranking:Integer=2500"}, service={Injector.class, StaticInjectAnnotationProcessorFactory.class, AcceptsNullName.class})
public class ResourcePathInjector
extends AbstractInjector
implements Injector,
AcceptsNullName,
StaticInjectAnnotationProcessorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePathInjector.class);

    @NotNull
    public String getName() {
        return "resource-path";
    }

    public Object getValue(@NotNull Object adaptable, String name, @NotNull Type declaredType, @NotNull AnnotatedElement element, @NotNull DisposalCallbackRegistry callbackRegistry) {
        ValueMap map;
        Object[] resourcePaths = null;
        Path pathAnnotation = element.getAnnotation(Path.class);
        ResourcePath resourcePathAnnotation = element.getAnnotation(ResourcePath.class);
        if (pathAnnotation != null) {
            resourcePaths = this.getPathsFromAnnotation(pathAnnotation);
        } else if (resourcePathAnnotation != null) {
            resourcePaths = this.getPathsFromAnnotation(resourcePathAnnotation);
        }
        if (ArrayUtils.isEmpty((Object[])resourcePaths) && name != null && (map = this.getValueMap(adaptable)) != null) {
            resourcePaths = (String[])map.get(name, String[].class);
        }
        if (ArrayUtils.isEmpty((Object[])resourcePaths)) {
            return null;
        }
        ResourceResolver resolver = this.getResourceResolver(adaptable);
        if (resolver == null) {
            LOG.debug("Could not get resolver from adaptable {}", adaptable);
            return null;
        }
        List<Resource> resources = this.getResources(resolver, (String[])resourcePaths, name);
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        if (this.isDeclaredTypeCollection(declaredType)) {
            return resources;
        }
        if (declaredType instanceof Class && ((Class)declaredType).isArray()) {
            return resources.toArray(new Resource[0]);
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        LOG.warn("Cannot inject multiple resources into field {} since it is not declared as a list", (Object)name);
        return null;
    }

    private List<Resource> getResources(ResourceResolver resolver, String[] paths, String fieldName) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String path : paths) {
            Resource resource = resolver.getResource(path);
            if (resource == null) {
                LOG.warn("Could not retrieve resource at path {} for field {}. Since it is required it won't be injected.", (Object)path, (Object)fieldName);
                return null;
            }
            resources.add(resource);
        }
        return resources;
    }

    private String[] getPathsFromAnnotation(Path pathAnnotation) {
        String[] resourcePaths = null;
        resourcePaths = StringUtils.isNotEmpty((CharSequence)pathAnnotation.value()) ? new String[]{pathAnnotation.value()} : pathAnnotation.paths();
        return resourcePaths;
    }

    private String[] getPathsFromAnnotation(ResourcePath resourcePathAnnotation) {
        String[] resourcePaths = null;
        resourcePaths = StringUtils.isNotEmpty((CharSequence)resourcePathAnnotation.path()) ? new String[]{resourcePathAnnotation.path()} : resourcePathAnnotation.paths();
        return resourcePaths;
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(AnnotatedElement element) {
        ResourcePath annotation = element.getAnnotation(ResourcePath.class);
        if (annotation != null) {
            return new ResourcePathAnnotationProcessor(annotation);
        }
        return null;
    }

    private static class ResourcePathAnnotationProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final ResourcePath annotation;

        public ResourcePathAnnotationProcessor(ResourcePath annotation) {
            this.annotation = annotation;
        }

        public String getName() {
            if (this.annotation.name().isEmpty()) {
                return null;
            }
            return this.annotation.name();
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }
    }
}

