/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.internal.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OutputWriter {
    Logger log = LoggerFactory.getLogger(OutputWriter.class);
    public static final String KEY_SIZE = "size";
    public static final String KEY_ITEMS = "items";
    public static final String KEY_ERRORS = "errors";
    public static final String KEY_NB_ERRORS = "nbErrors";
    public static final String PARAM_SIZE = "size";
    public static final int NB_MAX = 10;
    protected long size;
    protected long nbErrors;
    protected long max = 10L;
    protected Pipe pipe;
    protected Writer writer;
    public static final String PATH_KEY = "path";
    public static final String PARAM_WRITER = "writer";
    protected Map<String, Object> customOutputs;
    protected List<String> errors = new ArrayList<String>();

    public abstract boolean handleRequest(SlingHttpServletRequest var1);

    public void init(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String writerParam;
        if (request.getParameter("size") != null) {
            this.setMax(Integer.parseInt(request.getParameter("size")));
        }
        if (StringUtils.isNotBlank((CharSequence)(writerParam = request.getParameter(PARAM_WRITER)))) {
            try {
                this.customOutputs = (Map)JsonUtil.unbox((JsonValue)JsonUtil.parseObject(writerParam));
            }
            catch (Exception e) {
                this.log.error("requested attributes can't be parsed", (Throwable)e);
            }
        }
        this.setWriter(response.getWriter());
        this.initResponse(response);
        this.starts();
    }

    public void setCustomOutputs(Map<String, Object> customOutputs) {
        this.customOutputs = customOutputs;
    }

    protected abstract void initResponse(SlingHttpServletResponse var1);

    public abstract void starts();

    public void setMax(int max) {
        this.max = max;
        if (max < 0) {
            this.max = Integer.MAX_VALUE;
        }
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void write(Resource resource) {
        if (this.size++ < this.max) {
            this.writeItem(resource);
        }
    }

    public void error(String path) {
        if (this.nbErrors++ < this.max) {
            this.errors.add(path);
        }
    }

    protected abstract void writeItem(Resource var1);

    public abstract void ends();

    public void setPipe(Pipe pipe) {
        this.pipe = pipe;
        Resource outputs = pipe.getResource().getChild(PARAM_WRITER);
        if (this.customOutputs == null && outputs != null) {
            this.customOutputs = new HashMap<String, Object>();
            this.customOutputs.putAll((Map<String, Object>)outputs.getValueMap());
            for (String ignoredKey : BasePipe.IGNORED_PROPERTIES) {
                this.customOutputs.remove(ignoredKey);
            }
        }
    }

    public String toString() {
        return this.writer.toString();
    }

    public Map<String, Object> getCustomOutputs() {
        return this.customOutputs;
    }
}

