/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SuperPipe
extends BasePipe {
    private static final Logger LOG = LoggerFactory.getLogger(SuperPipe.class);
    public static final String PN_SLEEP = "sleep";
    protected long sleep = 0L;
    protected List<Pipe> subpipes = new ArrayList<Pipe>();

    public SuperPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) throws Exception {
        super(plumber, resource, upperBindings);
        this.sleep = (Long)this.properties.get(PN_SLEEP, (Object)0L);
    }

    public abstract void buildChildren() throws Exception;

    protected abstract Iterator<Resource> computeSubpipesOutput() throws Exception;

    @Override
    protected Iterator<Resource> computeOutput() throws Exception {
        if (this.subpipes.isEmpty()) {
            this.buildChildren();
        }
        return this.computeSubpipesOutput();
    }

    protected Pipe getFirstPipe() {
        return this.subpipes.size() > 0 ? this.subpipes.get(0) : null;
    }

    protected Pipe getLastPipe() {
        return this.subpipes.size() > 0 ? this.subpipes.get(this.subpipes.size() - 1) : null;
    }

    public Pipe getPreviousPipe(Pipe pipe) {
        Pipe previousPipe = null;
        if (!this.subpipes.isEmpty()) {
            if (this.subpipes.get(0).equals(pipe) && this.parent != null) {
                return this.parent.getPreviousPipe(this);
            }
            for (Pipe candidate : this.subpipes) {
                if (candidate.equals(pipe)) {
                    return previousPipe;
                }
                previousPipe = candidate;
            }
        }
        return null;
    }

    @Override
    public boolean modifiesContent() {
        try {
            if (this.subpipes.isEmpty()) {
                this.buildChildren();
            }
            for (Pipe pipe : this.subpipes) {
                if (!pipe.modifiesContent()) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOG.error("something went wrong while building this pipe, we'll consider this pipe as modifying content", (Throwable)e);
            return true;
        }
    }

    @Override
    public void before() throws Exception {
        super.before();
        if (this.subpipes.size() == 0) {
            this.buildChildren();
        }
        for (Pipe pipe : this.subpipes) {
            pipe.before();
        }
    }

    @Override
    public void after() throws Exception {
        super.after();
        for (Pipe pipe : this.subpipes) {
            pipe.after();
        }
    }
}

