/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.SuperPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerPipe
extends SuperPipe {
    private static final Logger log = LoggerFactory.getLogger(ContainerPipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/container";

    public ContainerPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) throws Exception {
        super(plumber, resource, upperBindings);
    }

    @Override
    public void buildChildren() {
        Iterator childPipeResources = this.getConfiguration().listChildren();
        while (childPipeResources.hasNext()) {
            Resource pipeResource = (Resource)childPipeResources.next();
            Pipe pipe = this.plumber.getPipe(pipeResource, this.bindings);
            if (pipe == null) {
                log.error("configured pipe {} is either not registered, or not computable by the plumber", (Object)pipeResource.getPath());
                continue;
            }
            pipe.setParent(this);
            this.subpipes.add(pipe);
        }
    }

    @Override
    protected Iterator<Resource> computeSubpipesOutput() {
        if (this.subpipes.size() > 0) {
            return new ContainerResourceIterator(this);
        }
        return EMPTY_ITERATOR;
    }

    static class ContainerResourceIterator
    implements Iterator<Resource> {
        Map<Pipe, Iterator<Resource>> iterators;
        ContainerPipe container;
        PipeBindings bindings;
        boolean computedCursor = false;
        boolean hasNext = false;
        long sleep = 0L;
        int cursor = 0;

        ContainerResourceIterator(ContainerPipe containerPipe) {
            this.container = containerPipe;
            this.bindings = this.container.bindings;
            this.iterators = new HashMap<Pipe, Iterator<Resource>>();
            Pipe firstPipe = this.container.getFirstPipe();
            this.sleep = this.container.sleep;
            this.iterators.put(firstPipe, firstPipe.getOutput());
        }

        private boolean updateCursor() {
            Pipe currentPipe = (Pipe)this.container.subpipes.get(this.cursor);
            Iterator<Resource> it = this.iterators.get(currentPipe);
            while (true) {
                if (it.hasNext() && this.cursor < this.container.subpipes.size() - 1) {
                    Resource resource = it.next();
                    this.bindings.updateBindings(currentPipe, resource);
                    Pipe nextPipe = (Pipe)this.container.subpipes.get(++this.cursor);
                    this.iterators.put(nextPipe, nextPipe.getOutput());
                    currentPipe = nextPipe;
                    log.debug("switching to {}", (Object)currentPipe);
                    it = this.iterators.get(currentPipe);
                    continue;
                }
                while (!it.hasNext() && this.cursor > 0) {
                    currentPipe = (Pipe)this.container.subpipes.get(--this.cursor);
                    log.debug("switching to {}", (Object)currentPipe);
                    it = this.iterators.get(currentPipe);
                }
                if (!it.hasNext() || this.cursor >= this.container.subpipes.size() - 1) break;
            }
            return this.cursor > 0 || this.iterators.size() == 1 && it.hasNext();
        }

        @Override
        public boolean hasNext() {
            if (!this.computedCursor) {
                this.hasNext = this.updateCursor();
            }
            return this.hasNext;
        }

        @Override
        public Resource next() {
            try {
                boolean bl = this.hasNext = this.computedCursor && this.hasNext || this.hasNext();
                if (this.hasNext) {
                    this.computedCursor = false;
                    this.hasNext = false;
                    Resource resource = this.iterators.get(this.container.getLastPipe()).next();
                    this.bindings.updateBindings(this.container.getLastPipe(), resource);
                    if (this.sleep > 0L) {
                        Thread.sleep(this.sleep);
                    }
                    return resource;
                }
            }
            catch (InterruptedException e) {
                log.error("interrupted while sleeping", (Throwable)e);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

