/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.script.ScriptException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.OutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWriter
extends OutputWriter {
    private static Logger logger = LoggerFactory.getLogger(JsonWriter.class);
    protected JsonGenerator jsonWriter;
    public static final String JSON_EXTENSION = "json";

    JsonWriter() {
        this.setWriter(new StringWriter());
    }

    @Override
    public boolean handleRequest(SlingHttpServletRequest request) {
        return request.getRequestPathInfo().getExtension().equals(JSON_EXTENSION);
    }

    @Override
    protected void initResponse(SlingHttpServletResponse response) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
    }

    @Override
    public void starts() {
        this.jsonWriter = Json.createGenerator((Writer)this.writer);
        this.jsonWriter.writeStartObject();
        this.jsonWriter.writeStartArray("items");
    }

    @Override
    public void writeItem(Resource resource) {
        if (this.customOutputs == null) {
            this.jsonWriter.write(resource.getPath());
        } else {
            this.jsonWriter.writeStartObject();
            this.jsonWriter.write("path", resource.getPath());
            for (Map.Entry entry : this.customOutputs.entrySet()) {
                Object o = null;
                try {
                    o = this.pipe.getBindings().instantiateObject((String)entry.getValue());
                    if (o instanceof JsonValue) {
                        this.jsonWriter.write((String)entry.getKey(), (JsonValue)o);
                        continue;
                    }
                    this.jsonWriter.write((String)entry.getKey(), o.toString());
                }
                catch (ScriptException e) {
                    logger.error("unable to write entry {}, will write empty value", entry, (Object)e);
                    this.jsonWriter.write("");
                }
            }
            this.jsonWriter.writeEnd();
        }
    }

    @Override
    public void ends() {
        this.jsonWriter.writeEnd();
        this.jsonWriter.write("size", this.size);
        if (this.nbErrors > 0L) {
            this.jsonWriter.write("nbErrors", this.nbErrors);
            this.jsonWriter.writeStartArray("errors");
            for (String error : this.errors) {
                this.jsonWriter.write(error);
            }
            this.jsonWriter.writeEnd();
        }
        this.jsonWriter.writeEnd();
        this.jsonWriter.flush();
    }
}

