/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.Collections;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizablePipe
extends BasePipe {
    private static Logger logger = LoggerFactory.getLogger(AuthorizablePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/authorizable";
    public static final String PN_CREATEGROUP = "createGroup";
    public static final String PN_ADDTOGROUP = "addToGroup";
    public static final String PN_ADDMEMBERS = "addMembers";
    public static final String PN_BINDMEMBERS = "bindMembers";
    UserManager userManager;
    boolean createGroup;
    boolean bindMembers;
    String addToGroup;
    String addMembers;
    Object outputBinding;

    @Override
    public Object getOutputBinding() {
        if (this.outputBinding != null) {
            return this.outputBinding;
        }
        return super.getOutputBinding();
    }

    @Override
    public boolean modifiesContent() {
        return this.createGroup || StringUtils.isNotBlank((CharSequence)this.addToGroup) || StringUtils.isNotBlank((CharSequence)this.addMembers);
    }

    public AuthorizablePipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
        this.userManager = (UserManager)this.resolver.adaptTo(UserManager.class);
        if (this.getConfiguration() != null) {
            ValueMap properties = this.getConfiguration().getValueMap();
            this.createGroup = (Boolean)properties.get(PN_CREATEGROUP, (Object)false);
            this.bindMembers = (Boolean)properties.get(PN_BINDMEMBERS, (Object)false);
            this.addToGroup = (String)properties.get(PN_ADDTOGROUP, String.class);
            this.addMembers = (String)properties.get(PN_ADDMEMBERS, String.class);
        }
    }

    @Override
    public Iterator<Resource> computeOutput() {
        try {
            Authorizable auth = this.getAuthorizable();
            if (auth != null) {
                logger.debug("Retrieved authorizable {}", (Object)auth.getID());
                if (StringUtils.isNotBlank((CharSequence)this.addToGroup)) {
                    this.addToGroup(auth);
                }
                if (StringUtils.isNotBlank((CharSequence)this.addMembers)) {
                    this.addMembers(auth);
                }
                if (this.bindMembers) {
                    this.bindMembers(auth);
                }
                Resource resource = this.resolver.getResource(auth.getPath());
                return Collections.singleton(resource).iterator();
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
        return EMPTY_ITERATOR;
    }

    Authorizable getAuthorizable() throws RepositoryException {
        Authorizable auth = null;
        String authId = this.getExpr();
        if (StringUtils.isNotBlank((CharSequence)authId)) {
            logger.debug("try to find authorizable {}", (Object)authId);
            auth = this.userManager.getAuthorizable(authId);
            if (auth == null && this.createGroup) {
                logger.info("authorizable {} does not exist, and createGroup flag is set, creating it", (Object)authId);
                if (!this.isDryRun()) {
                    auth = this.userManager.createGroup(authId);
                }
            }
        } else {
            Resource resource = this.getInput();
            if (resource != null) {
                auth = this.userManager.getAuthorizableByPath(resource.getPath());
            }
        }
        return auth;
    }

    void addToGroup(Authorizable auth) {
        try {
            String groupId = this.bindings.instantiateExpression(this.addToGroup);
            Authorizable groupAuth = this.userManager.getAuthorizable(groupId);
            if (groupAuth != null && groupAuth.isGroup()) {
                logger.info("adding {} to {}", (Object)auth.getID(), (Object)groupId);
                if (!this.isDryRun()) {
                    ((Group)groupAuth).addMember(auth);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to add current authorizable to group {}", (Object)this.addToGroup, (Object)e);
        }
    }

    void addMembers(Authorizable auth) {
        try {
            if (auth.isGroup()) {
                Group group = (Group)auth;
                String uids = this.bindings.instantiateExpression(this.addMembers);
                JsonArray array = JsonUtil.parseArray(uids);
                for (int index = 0; index < array.size(); ++index) {
                    String uid = array.getString(index);
                    Authorizable member = this.userManager.getAuthorizable(uid);
                    if (member != null) {
                        logger.info("adding {} to group {}", (Object)member.getID(), (Object)group.getID());
                        if (this.isDryRun()) continue;
                        group.addMember(member);
                        continue;
                    }
                    logger.error("computed uid {} doesn't exist, doing nothing", (Object)uid);
                }
            } else {
                logger.error("{} is not a group, can't add members", (Object)auth.getID());
            }
        }
        catch (Exception e) {
            logger.error("unable to add members {}", (Object)this.addMembers, (Object)e);
        }
    }

    void bindMembers(Authorizable auth) {
        try {
            if (auth.isGroup()) {
                Group group = (Group)auth;
                Iterator memberIterator = group.getMembers();
                JsonArrayBuilder array = Json.createArrayBuilder();
                while (memberIterator.hasNext()) {
                    array.add(((Authorizable)memberIterator.next()).getID());
                }
                this.outputBinding = JsonUtil.toString(array);
            } else {
                logger.error("{} is not a group, unable to bind members", (Object)auth.getID());
            }
        }
        catch (Exception e) {
            logger.error("unable to bind members");
        }
    }
}

