/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.pipes.CommandExecutor;
import org.apache.sling.pipes.ExecutionResult;
import org.apache.sling.pipes.OutputWriter;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBuilder;
import org.apache.sling.pipes.PipeExecutor;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.CommandUtil;
import org.apache.sling.pipes.internal.JsonWriter;
import org.apache.sling.pipes.internal.NopWriter;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, CommandExecutor.class}, property={"sling.servlet.resourceTypes=slingPipes/exec", "sling.servlet.methods=POST", "sling.servlet.extensions=txt"})
public class CommandExecutorImpl
extends SlingAllMethodsServlet
implements CommandExecutor {
    final Logger log = LoggerFactory.getLogger(CommandExecutorImpl.class);
    public static final String RESOURCE_TYPE = "slingPipes/exec";
    static final String REQ_PARAM_FILE = "pipe_cmdfile";
    static final String REQ_PARAM_CMD = "pipe_cmd";
    static final String CMD_LINE_PREFIX = "cmd_line_";
    static final String WHITE_SPACE_SEPARATOR = "\\s";
    static final String COMMENT_PREFIX = "#";
    static final String SEPARATOR = "|";
    static final String LINE_SEPARATOR = " ";
    static final String PARAMS = "@";
    static final String KEY_VALUE_SEP = "=";
    static final String FIRST_TOKEN = "first";
    static final String SECOND_TOKEN = "second";
    static final String CONFIGURATION_TOKEN = "(?<first>[\\w/\\:]+)\\s*=(?<second>[(\\w*)|\\$\\{(([^\\{^\\}]*(\\{[0-9,]+\\})?)*)\\}]+)";
    static final Pattern CONFIGURATION_PATTERN = Pattern.compile("(?<first>[\\w/\\:]+)\\s*=(?<second>[(\\w*)|\\$\\{(([^\\{^\\}]*(\\{[0-9,]+\\})?)*)\\}]+)");
    static final String KEY_NAME = "name";
    static final String KEY_PATH = "path";
    static final String KEY_EXPR = "expr";
    private static final String HELP_START = "\n a <pipe token> is <pipe> <expr|conf>? (<options>)?\n <options> are (@ <option>)* form with <option> being either\n\t'name pipeName' (used in bindings), \n\t'expr pipeExpression' (when not directly as <args>)\n\t'path pipePath' (when not directly as <args>)\n\t'with key=value ...'\n\t'outputs key=value ...'\n and <pipe> is one of the following :\n";
    Map<String, Method> methodMap;
    Map<String, PipeExecutor> executorMap;
    String help;
    @Reference
    Plumber plumber;

    @Activate
    @Modified
    public void activate() {
        this.methodMap = null;
        this.executorMap = null;
        this.help = null;
    }

    boolean isCommandCandidate(String line) {
        return StringUtils.isNotBlank((CharSequence)line) && !line.startsWith(COMMENT_PREFIX);
    }

    List<String> getCommandList(SlingHttpServletRequest request) throws IOException {
        ArrayList<String> cmds = new ArrayList<String>();
        if (request.getParameterMap().containsKey(REQ_PARAM_CMD)) {
            cmds.add(request.getParameter(REQ_PARAM_CMD));
        } else if (request.getParameterMap().containsKey(REQ_PARAM_FILE)) {
            String line;
            InputStream is = request.getRequestParameter(REQ_PARAM_FILE).getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            StringBuilder cmdBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (this.isCommandCandidate(line)) {
                    cmdBuilder.append(LINE_SEPARATOR + line.trim());
                    continue;
                }
                if (cmdBuilder.length() <= 0) continue;
                cmds.add(cmdBuilder.toString().trim());
                cmdBuilder = new StringBuilder();
            }
            if (cmdBuilder.length() > 0) {
                cmds.add(cmdBuilder.toString().trim());
            }
        }
        return cmds;
    }

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String currentCommand = null;
        PrintWriter writer = response.getWriter();
        try {
            ResourceResolver resolver = request.getResourceResolver();
            Map<String, Object> bindings = this.plumber.getBindingsFromRequest(request, true);
            List<String> cmds = this.getCommandList(request);
            if (cmds.isEmpty()) {
                writer.println("No command to execute!");
            }
            int idx_line = 0;
            for (String command : cmds) {
                if (!StringUtils.isNotBlank((CharSequence)command)) continue;
                JsonWriter pipeWriter = new JsonWriter();
                pipeWriter.starts();
                currentCommand = command;
                PipeBuilder pipeBuilder = this.parse(resolver, command.split(WHITE_SPACE_SEPARATOR));
                Pipe pipe = pipeBuilder.build();
                int n = idx_line;
                idx_line = (short)(idx_line + 1);
                bindings.put(CMD_LINE_PREFIX + n, pipe.getResource().getPath());
                writer.println(this.plumber.execute(resolver, pipe, bindings, (OutputWriter)pipeWriter, true));
            }
            response.setStatus(200);
        }
        catch (AccessControlException e) {
            response.sendError(403);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            writer.println("Error executing " + currentCommand);
            e.printStackTrace(writer);
            response.sendError(500);
            writer.println(this.help());
        }
    }

    @Override
    public ExecutionResult execute(ResourceResolver resolver, String path, String ... optionTokens) {
        Resource resource = resolver.getResource(path);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("%s resource does not exist", path));
        }
        Options options = this.getOptions(optionTokens);
        HashMap<String, Object> bMap = null;
        if (options.with != null) {
            bMap = new HashMap<String, Object>();
            CommandUtil.writeToMap(bMap, options.with);
        }
        OutputWriter writer = new NopWriter();
        if (options.writer != null) {
            writer = options.writer;
        }
        ((OutputWriter)writer).starts();
        return this.plumber.execute(resolver, path, bMap, writer, true);
    }

    @Override
    public PipeBuilder parse(ResourceResolver resolver, String ... cmds) throws InvocationTargetException, IllegalAccessException {
        PipeBuilder builder = this.plumber.newPipe(resolver);
        for (Token token : this.parseTokens(cmds)) {
            Method method = this.getMethodMap().get(token.pipeKey);
            if (method == null) {
                throw new IllegalArgumentException(token.pipeKey + " is not a valid pipe");
            }
            if (this.isExpressionExpected(method)) {
                method.invoke((Object)builder, token.args.get(0));
            } else if (this.isConfExpected(method)) {
                method.invoke((Object)builder, new Object[]{this.keyValuesToArray(token.args)});
            } else if (this.isWithoutExpectedParameter(method)) {
                method.invoke((Object)builder, new Object[0]);
            }
            if (token.options == null) continue;
            token.options.writeToBuilder(builder);
        }
        return builder;
    }

    protected void finishToken(Token currentToken, List<String> currentList) {
        if (currentToken.args != null) {
            currentToken.options = this.getOptions(currentList);
        } else {
            currentToken.args = currentList;
        }
        this.log.debug("current token : {}", (Object)currentToken);
    }

    protected Options getOptions(String[] tokens) {
        return this.getOptions(Arrays.asList(tokens));
    }

    protected Options getOptions(List<String> tokens) {
        return new Options(tokens);
    }

    protected List<Token> parseTokens(String ... commands) {
        ArrayList<Token> returnValue = new ArrayList<Token>();
        Token currentToken = new Token();
        returnValue.add(currentToken);
        ArrayList<String> currentList = new ArrayList<String>();
        block8: for (String token : commands) {
            if (currentToken.pipeKey == null) {
                currentToken.pipeKey = token;
                continue;
            }
            switch (token) {
                case "|": {
                    this.finishToken(currentToken, currentList);
                    currentList = new ArrayList();
                    currentToken = new Token();
                    returnValue.add(currentToken);
                    continue block8;
                }
                case "@": {
                    if (currentToken.args == null) {
                        currentToken.args = currentList;
                        currentList = new ArrayList();
                    }
                    currentList.add(PARAMS);
                    continue block8;
                }
                default: {
                    currentList.add(token);
                }
            }
        }
        this.finishToken(currentToken, currentList);
        return returnValue;
    }

    protected void computeMaps() {
        this.executorMap = new HashMap<String, PipeExecutor>();
        this.methodMap = new HashMap<String, Method>();
        for (Method method : PipeBuilder.class.getDeclaredMethods()) {
            PipeExecutor executor = method.getAnnotation(PipeExecutor.class);
            if (executor == null) continue;
            this.methodMap.put(executor.command(), method);
            this.executorMap.put(executor.command(), executor);
        }
    }

    protected Map<String, Method> getMethodMap() {
        if (this.methodMap == null) {
            this.computeMaps();
        }
        return this.methodMap;
    }

    protected Map<String, PipeExecutor> getExecutorMap() {
        if (this.executorMap == null) {
            this.computeMaps();
        }
        return this.executorMap;
    }

    protected boolean isExpressionExpected(Method method) {
        return method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(String.class);
    }

    protected boolean isConfExpected(Method method) {
        return method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(Object[].class);
    }

    protected boolean isWithoutExpectedParameter(Method method) {
        return method.getParameterCount() == 0;
    }

    String[] keyValuesToArray(List<String> o) {
        ArrayList<String> args = new ArrayList<String>();
        for (String pair : o) {
            Matcher matcher = CONFIGURATION_PATTERN.matcher(pair.trim());
            if (!matcher.matches()) continue;
            args.add(matcher.group(FIRST_TOKEN));
            args.add(matcher.group(SECOND_TOKEN));
        }
        return args.toArray(new String[args.size()]);
    }

    @Override
    public String help() {
        if (StringUtils.isBlank((CharSequence)this.help)) {
            StringBuilder builder = new StringBuilder();
            builder.append(HELP_START);
            for (Map.Entry<String, PipeExecutor> entry : this.getExecutorMap().entrySet()) {
                builder.append(String.format("\t%s\t\t:\t%s%n", entry.getKey(), entry.getValue().description()));
            }
            this.help = builder.toString();
        }
        return this.help;
    }

    protected class Token {
        String pipeKey;
        List<String> args;
        Options options;

        protected Token() {
        }

        public String toString() {
            return "Token{pipeKey='" + this.pipeKey + '\'' + ", args=" + this.args + ", options=" + this.options + '}';
        }
    }

    protected class Options {
        String name;
        String path;
        String expr;
        String[] with;
        OutputWriter writer;

        public String toString() {
            return "Options{name='" + this.name + '\'' + ", path='" + this.path + '\'' + ", expr='" + this.expr + '\'' + ", with=" + Arrays.toString(this.with) + ", writer=" + this.writer + '}';
        }

        void setOutputs(List<String> values) {
            this.writer = new JsonWriter();
            Object[] list = CommandExecutorImpl.this.keyValuesToArray(values);
            HashMap<String, Object> outputs = new HashMap<String, Object>();
            CommandUtil.writeToMap(outputs, list);
            this.writer.setCustomOutputs(outputs);
        }

        protected Options(List<String> options) {
            HashMap<String, Object> optionMap = new HashMap<String, Object>();
            String currentKey = null;
            ArrayList<String> currentList = null;
            for (String string : options) {
                if (CommandExecutorImpl.PARAMS.equals(string)) {
                    this.finishOption(currentKey, currentList, optionMap);
                    currentList = new ArrayList<String>();
                    currentKey = null;
                    continue;
                }
                if (currentKey == null) {
                    currentKey = string;
                    continue;
                }
                currentList.add(string);
            }
            this.finishOption(currentKey, currentList, optionMap);
            block15: for (Map.Entry entry : optionMap.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "name": {
                        this.name = (String)entry.getValue();
                        continue block15;
                    }
                    case "path": {
                        this.path = (String)entry.getValue();
                        continue block15;
                    }
                    case "expr": {
                        this.expr = (String)entry.getValue();
                        continue block15;
                    }
                    case "with": {
                        this.with = CommandExecutorImpl.this.keyValuesToArray((List)entry.getValue());
                        continue block15;
                    }
                    case "outputs": {
                        this.setOutputs((List)entry.getValue());
                        continue block15;
                    }
                }
                throw new IllegalArgumentException(String.format("%s is an unknown option", entry.getKey()));
            }
        }

        protected void finishOption(String currentKey, List<String> currentList, Map<String, Object> optionMap) {
            if (currentList != null) {
                if (currentKey.equals(CommandExecutorImpl.KEY_NAME) || currentKey.equals(CommandExecutorImpl.KEY_EXPR) || currentKey.equals(CommandExecutorImpl.KEY_PATH)) {
                    optionMap.put(currentKey, currentList.get(0));
                } else {
                    optionMap.put(currentKey, currentList);
                }
            }
        }

        void writeToBuilder(PipeBuilder builder) throws IllegalAccessException {
            if (StringUtils.isNotBlank((CharSequence)this.name)) {
                builder.name(this.name);
            }
            if (StringUtils.isNotBlank((CharSequence)this.path)) {
                builder.path(this.path);
            }
            if (StringUtils.isNotBlank((CharSequence)this.expr)) {
                builder.expr(this.expr);
            }
            if (this.with != null) {
                builder.with(this.with);
            }
        }
    }
}

