/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.OutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvWriter
extends OutputWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvWriter.class);
    private static final String CSV_EXTENSION = "csv";
    private static final String SEPARATOR = ",";
    private static final String NEW_LINE = "\n";
    private static final String HEADER_ERROR = "errors";
    List<String> headers;

    @Override
    public boolean handleRequest(SlingHttpServletRequest request) {
        return CSV_EXTENSION.equals(request.getRequestPathInfo().getExtension());
    }

    @Override
    protected void initResponse(SlingHttpServletResponse response) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("plain/text");
    }

    @Override
    public void starts() {
    }

    void writeCell(Resource resource, List<String> elts, String key) {
        if (key.equals("path")) {
            elts.add(resource.getPath());
        } else if (this.customOutputs != null) {
            try {
                elts.add(this.pipe.getBindings().instantiateExpression((String)this.customOutputs.get(key)));
            }
            catch (RuntimeException e) {
                LOGGER.error("unable to evaluate {}, will write empty value", this.customOutputs.get(key), (Object)e);
                elts.add("");
            }
        }
    }

    @Override
    protected void writeItem(Resource resource) {
        if (this.headers == null) {
            this.headers = new ArrayList<String>();
            this.headers.add("path");
            if (this.customOutputs != null) {
                this.headers.addAll(this.customOutputs.keySet());
            }
            try {
                this.writer.write(this.headers.stream().collect(Collectors.joining(SEPARATOR)) + NEW_LINE);
            }
            catch (IOException e) {
                LOGGER.error("unable to write header");
            }
        }
        try {
            ArrayList<String> elts = new ArrayList<String>();
            for (String key : this.headers) {
                this.writeCell(resource, elts, key);
            }
            String line = elts.stream().collect(Collectors.joining(SEPARATOR));
            this.writer.write(line + NEW_LINE);
        }
        catch (IOException e) {
            LOGGER.error("unable to write header", (Throwable)e);
        }
    }

    @Override
    public void ends() {
        try {
            if (!this.errors.isEmpty()) {
                this.writer.write("errors\n");
                for (String error : this.errors) {
                    this.writer.write(error + NEW_LINE);
                }
            }
            this.writer.flush();
        }
        catch (IOException e) {
            LOGGER.error("unable to flush", (Throwable)e);
        }
    }
}

