/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitNode;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovePipe
extends BasePipe {
    Logger logger = LoggerFactory.getLogger(MovePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/mv";
    public static final String PN_OVERWRITE_TARGET = "overwriteTarget";
    public static final String PN_ORDERBEFORE = "orderBeforeTarget";
    private boolean overwriteTarget = (Boolean)this.properties.get("overwriteTarget", (Object)false);
    private boolean orderBefore = (Boolean)this.properties.get("orderBeforeTarget", (Object)false);

    public MovePipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
    }

    @Override
    public boolean modifiesContent() {
        return true;
    }

    private Iterator<Resource> overwriteTarget(Resource input, Resource target) throws RepositoryException {
        this.logger.info("overwriting {}", (Object)target.getPath());
        Session session = (Session)this.resolver.adaptTo(Session.class);
        if (!this.isDryRun() && session != null) {
            Resource parent = target.getParent();
            String targetPath = target.getPath();
            Node targetParent = session.getItem(targetPath).getParent();
            if (targetParent.getPrimaryNodeType().hasOrderableChildNodes()) {
                String oldNodeName = target.getName();
                String targetPathNewNode = targetPath + UUID.randomUUID();
                String newNodeName = targetPathNewNode.substring(targetPathNewNode.lastIndexOf("/") + 1);
                session.move(input.getPath(), targetPathNewNode);
                targetParent.orderBefore(newNodeName, oldNodeName);
                session.removeItem(targetPath);
                JackrabbitNode newNode = (JackrabbitNode)session.getNode(targetPathNewNode);
                newNode.rename(oldNodeName);
                if (parent != null) {
                    return Collections.singleton(parent.getChild(oldNodeName)).iterator();
                }
            } else {
                session.removeItem(targetPath);
                session.move(input.getPath(), targetPath);
                if (parent != null) {
                    return Collections.singleton(parent.getChild(input.getName())).iterator();
                }
            }
        }
        return EMPTY_ITERATOR;
    }

    private Iterator<Resource> moveToTarget(Resource input, String targetPath) throws RepositoryException {
        this.logger.info("moving resource {} to {}", (Object)input.getPath(), (Object)targetPath);
        Session session = (Session)this.resolver.adaptTo(Session.class);
        if (!this.isDryRun() && session != null) {
            if (input.adaptTo(Node.class) != null) {
                session.move(input.getPath(), targetPath);
            } else {
                this.logger.debug("resource is a property");
                int lastLevel = targetPath.lastIndexOf("/");
                String parentPath = targetPath.substring(0, lastLevel);
                String name = targetPath.substring(lastLevel + 1, targetPath.length());
                Property sourceProperty = (Property)input.adaptTo(Property.class);
                if (sourceProperty != null) {
                    Node destNode = session.getNode(parentPath);
                    if (sourceProperty.isMultiple()) {
                        destNode.setProperty(name, sourceProperty.getValues(), sourceProperty.getType());
                    } else {
                        destNode.setProperty(name, sourceProperty.getValue(), sourceProperty.getType());
                    }
                    sourceProperty.remove();
                }
            }
            Resource target = this.resolver.getResource(targetPath);
            return Collections.singleton(target).iterator();
        }
        return EMPTY_ITERATOR;
    }

    private Iterator<Resource> reorder(Resource input, Resource target) throws RepositoryException, PersistenceException {
        if (target != null && !this.isDryRun()) {
            this.logger.info("ordering {} before {}", (Object)input.getPath(), (Object)(target != null ? 1 : 0));
            Resource parent = target.getParent();
            if (parent != null) {
                Node targetParent = (Node)parent.adaptTo(Node.class);
                String oldNodeName = target.getName();
                if (targetParent != null && targetParent.getPrimaryNodeType().hasOrderableChildNodes()) {
                    String targetNodeName = ResourceUtil.createUniqueChildName((Resource)parent, (String)input.getName());
                    String targetNodePath = targetParent.getPath() + "/" + targetNodeName;
                    Session session = (Session)this.resolver.adaptTo(Session.class);
                    if (session != null) {
                        session.move(input.getPath(), targetNodePath);
                        targetParent.orderBefore(targetNodeName, oldNodeName);
                        return Collections.singleton(parent.getChild(targetNodeName)).iterator();
                    }
                } else {
                    this.logger.warn("parent resource {} doesn't support ordering", (Object)parent.getPath());
                }
            }
        }
        return EMPTY_ITERATOR;
    }

    @Override
    protected Iterator<Resource> computeOutput() {
        Iterator<Resource> output = EMPTY_ITERATOR;
        Resource input = this.getInput();
        if (input == null || input.adaptTo(Item.class) == null) {
            this.logger.error("bad configuration, input is either not here, or not something that can be moved");
            return output;
        }
        String targetPath = this.getExpr();
        Resource targetResource = this.resolver.getResource(targetPath);
        try {
            if (targetResource == null) {
                if (this.orderBefore) {
                    this.logger.warn("target resource {} doesn't exist ordering not possible", (Object)targetPath);
                } else {
                    output = this.moveToTarget(input, targetPath);
                }
            } else if (this.overwriteTarget) {
                output = this.overwriteTarget(input, targetResource);
            } else if (this.orderBefore) {
                output = this.reorder(input, targetResource);
            } else {
                this.logger.warn("{} already exists, nothing will be done here, nothing outputed", (Object)targetPath);
            }
        }
        catch (RepositoryException | PersistenceException e) {
            this.logger.error("unable to move the resource", e);
        }
        return output;
    }
}

