/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.SuperPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencePipe
extends SuperPipe {
    private static final Logger log = LoggerFactory.getLogger(ReferencePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/reference";
    static final String PN_SKIPEXECUTION = "skipExecution";
    protected Pipe reference;
    String referencePath;

    public ReferencePipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
    }

    @Override
    public void buildChildren() {
        String expression = this.getExpr();
        if (StringUtils.isNotBlank((CharSequence)expression) && !expression.equals(this.referencePath)) {
            this.referencePath = expression;
            Resource pipeResource = this.resolver.getResource(this.referencePath);
            if (pipeResource == null) {
                throw new IllegalArgumentException("Reference configuration error: There is no resource at " + this.getExpr());
            }
            this.reference = this.plumber.getPipe(pipeResource, this.bindings);
            if (this.reference == null) {
                throw new IllegalArgumentException("Unable to build out pipe out of " + this.getPath());
            }
            this.reference.setParent(this);
            log.info("set reference to {}", (Object)this.reference);
            this.subpipes.clear();
            this.subpipes.add(this.reference);
        }
    }

    boolean shouldBeSkipped() {
        Object object;
        String skip = (String)this.properties.get(PN_SKIPEXECUTION, String.class);
        if (StringUtils.isNotBlank((CharSequence)skip) && (object = this.bindings.instantiateObject(skip)) instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    protected Iterator<Resource> computeReferredOutput() {
        this.buildChildren();
        log.debug("getting {} output", (Object)this.reference);
        return this.reference.getOutput();
    }

    @Override
    protected Iterator<Resource> computeSubpipesOutput() {
        if (!this.shouldBeSkipped()) {
            return this.computeReferredOutput();
        }
        return EMPTY_ITERATOR;
    }
}

