/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.iterator;

import java.util.Iterator;
import java.util.ListIterator;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.iterator.AbstractIterator;
import org.apache.sling.query.util.LazyList;

public class LastIterator<T>
extends AbstractIterator<Option<T>> {
    private final LazyList<Option<T>> lazyList;
    private final ListIterator<Option<T>> iterator;
    private boolean finished;
    private boolean initialized;
    private int lastIndex = -1;

    public LastIterator(Iterator<Option<T>> iterator) {
        this.lazyList = new LazyList<Option<T>>(iterator);
        this.iterator = this.lazyList.listIterator();
    }

    @Override
    protected Option<T> getElement() {
        if (this.finished) {
            return null;
        }
        this.initializeLastIndex();
        if (!this.iterator.hasNext()) {
            this.finished = true;
            return null;
        }
        Option<T> candidate = this.iterator.next();
        if (this.iterator.previousIndex() == this.lastIndex) {
            this.finished = true;
            return candidate;
        }
        return Option.empty(candidate.getArgumentId());
    }

    private void initializeLastIndex() {
        ListIterator<Option<T>> i = this.lazyList.listIterator();
        if (!this.initialized) {
            while (i.hasNext()) {
                if (i.next().isEmpty()) continue;
                this.lastIndex = i.previousIndex();
            }
        }
        this.initialized = true;
    }
}

