/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.iterator;

import java.util.Iterator;
import java.util.ListIterator;
import org.apache.sling.query.api.Predicate;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.iterator.AbstractIterator;
import org.apache.sling.query.util.IteratorUtils;
import org.apache.sling.query.util.LazyList;

public class SiblingsIterator<T>
extends AbstractIterator<T> {
    private final Predicate<T> until;
    private final ListIterator<T> siblings;
    private final Type type;
    private final TreeProvider<T> provider;
    private boolean finished;

    public SiblingsIterator(Predicate<T> until, T resource, Type type, TreeProvider<T> provider) {
        this.provider = provider;
        this.until = until;
        this.siblings = this.getRewindedIterator(resource, type);
        this.finished = false;
        this.type = type;
    }

    @Override
    protected T getElement() {
        if (this.finished) {
            return null;
        }
        if (this.type.canAdvance(this.siblings)) {
            T resource = this.type.advance(this.siblings);
            if (this.until != null && this.until.accepts(resource)) {
                this.finished = true;
                return null;
            }
            if (this.until == null) {
                this.finished = true;
            }
            return resource;
        }
        return null;
    }

    private ListIterator<T> getRewindedIterator(T resource, Type type) {
        T sibling;
        String resourceName = this.provider.getName(resource);
        T parent = this.provider.getParent(resource);
        Iterator<T> iterator = parent == null ? IteratorUtils.singleElementIterator(resource) : this.provider.listChildren(parent);
        ListIterator<T> listIterator = new LazyList<T>(iterator).listIterator();
        while (listIterator.hasNext() && !this.provider.getName(sibling = listIterator.next()).equals(resourceName)) {
        }
        if (type == Type.PREV) {
            listIterator.previous();
        }
        return listIterator;
    }

    public static enum Type {
        NEXT{

            @Override
            public boolean canAdvance(ListIterator<?> iterator) {
                return iterator.hasNext();
            }

            @Override
            public <T> T advance(ListIterator<T> iterator) {
                return iterator.next();
            }
        }
        ,
        PREV{

            @Override
            public boolean canAdvance(ListIterator<?> iterator) {
                return iterator.hasPrevious();
            }

            @Override
            public <T> T advance(ListIterator<T> iterator) {
                return iterator.previous();
            }
        };


        public abstract boolean canAdvance(ListIterator<?> var1);

        public abstract <T> T advance(ListIterator<T> var1);
    }
}

